/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.joml.Math;

public class Util {
    private Util() {
    }

    public static String getFileNameNoExt(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i < 0) {
            return fileName;
        }
        return fileName.substring(0, i);
    }

    public static void zeroRemaining(IntBuffer buf) {
        int pos = buf.position();
        int remaining = buf.remaining();
        int[] filler = new int[remaining];
        buf.put(filler);
        buf.position(pos);
    }

    public static int createHexColor(int rgb, float a) {
        return rgb | (int)Math.ceil((float)(a * 255.0f)) << 24;
    }

    public static int createHexColor(float r, float g, float b, float a) {
        int hex = 0;
        hex |= (int)Math.ceil((float)(b * 255.0f));
        hex |= (int)Math.ceil((float)(g * 255.0f)) << 8;
        hex |= (int)Math.ceil((float)(r * 255.0f)) << 16;
        return hex |= (int)Math.ceil((float)(a * 255.0f)) << 24;
    }

    public static void deleteFolderRecursive(File file) {
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (Files.isSymbolicLink(f.toPath())) continue;
                Util.deleteFolderRecursive(f);
            }
        }
        file.delete();
    }

    public static void copyDirectory(Path source, Path destination) {
        try (Stream<Path> paths = Files.walk(source, new FileVisitOption[0]);){
            paths.forEach(sourcePath -> {
                try {
                    Path targetPath = destination.resolve(source.relativize((Path)sourcePath));
                    if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                        if (!Files.exists(targetPath, new LinkOption[0])) {
                            Files.createDirectories(targetPath, new FileAttribute[0]);
                        }
                    } else {
                        Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    System.err.println("Failed to copy: " + sourcePath + " -> " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            System.err.println("Failed to walk: " + source + " -> " + e.getMessage());
        }
    }

    public static void unzip(Path zipFilePath, Path destDir) throws IOException {
        if (Files.notExists(destDir, new LinkOption[0])) {
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFilePath, new OpenOption[0]));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                Path newFilePath = destDir.resolve(zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(newFilePath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(newFilePath.getParent(), new FileAttribute[0]);
                    try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(newFilePath, new OpenOption[0]));){
                        int read;
                        byte[] buffer = new byte[1024];
                        while ((read = zis.read(buffer)) != -1) {
                            bos.write(buffer, 0, read);
                        }
                    }
                }
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
        }
    }
}

