/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.tracking.internal;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.data.relation.RelationTransformType;
import graphics.continuum.tracking.TrackedResourceRelation;
import graphics.continuum.tracking.TrackedResources;
import java.io.IOException;

public class IntRelationDeserializer
extends StdNodeBasedDeserializer<TrackedResourceRelation<Integer>> {
    protected IntRelationDeserializer() {
        super(TrackedResourceRelation.class);
    }

    @Override
    public TrackedResourceRelation<Integer> convert(JsonNode value, DeserializationContext ctxt) throws IOException {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        TrackedResources trackedResources = engineInstance.getTrackedResources();
        if (value.isInt()) {
            return trackedResources.constantRelation(value.asInt());
        }
        if (value.isTextual()) {
            return trackedResources.identityRelation(value.asText(), Integer.class);
        }
        if (value.isObject()) {
            if (!value.has("source")) {
                throw JsonMappingException.from(ctxt, "Missing required field \"source\"");
            }
            JsonNode sourceNode = value.get("source");
            if (!sourceNode.isTextual()) {
                throw JsonMappingException.from(ctxt, "\"source\" needs to be a string");
            }
            if (!value.has("transform")) {
                throw JsonMappingException.from(ctxt, "Missing required field transform");
            }
            JsonNode transformNode = value.get("transform");
            if (!transformNode.isTextual()) {
                throw JsonMappingException.from(ctxt, "\"transform\" needs to be a string");
            }
            String transformTypeName = transformNode.asText();
            RelationTransformType transformType = null;
            for (RelationTransformType type : RelationTransformType.values()) {
                if (!type.name().equalsIgnoreCase(transformTypeName)) continue;
                transformType = type;
                break;
            }
            if (transformType == null) {
                throw JsonMappingException.from(ctxt, "Invalid transform type " + transformTypeName);
            }
            Object transformParam = value.has("param") ? JsonUtil.readValue(Object.class, value.get("param"), ctxt) : null;
            return trackedResources.transformRelation(sourceNode.asText(), transformType, transformParam, Integer.class);
        }
        throw JsonMappingException.from(ctxt, "Expected an int, string or a an object for a relation");
    }
}

