/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.tracking;

import graphics.continuum.data.relation.RelationTransformType;
import graphics.continuum.renderer.uniform.GlobalUniforms;
import graphics.continuum.tracking.TrackedResource;
import graphics.continuum.tracking.TrackedResourceRelation;
import graphics.continuum.tracking.UniformTypeBase;
import graphics.continuum.tracking.internal.ConstantRelation;
import graphics.continuum.tracking.internal.IdentityRelation;
import graphics.continuum.tracking.internal.TransformingRelation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class TrackedResources {
    private final Map<String, TrackedResource<?>> trackedUniforms = new HashMap();
    private final List<TrackedResourceRelation<?>> loadedRelations = new ArrayList();

    public TrackedResources() {
        GlobalUniforms.RegisterGameUniforms(this);
    }

    public <T> void registerGlobalUniform(String name, UniformTypeBase type) {
        this.trackedUniforms.put(name, new TrackedResource(type));
    }

    public <T> void registerGlobalUniform(String name, UniformTypeBase type, T defaultValue) {
        TrackedResource trackedResource = new TrackedResource(type);
        trackedResource.update(defaultValue);
        this.trackedUniforms.put(name, trackedResource);
    }

    public void markUniformUpdate(String name, Object newValue) {
        TrackedResource<?> trackedResource = this.trackedUniforms.get(name);
        if (trackedResource != null) {
            trackedResource.update(newValue);
        }
    }

    public void resetUniformUpdates() {
        for (TrackedResource<?> trackedResource : this.trackedUniforms.values()) {
            trackedResource.resetUpdate();
        }
    }

    public <T> TrackedResource<T> getTrackedUniform(String name) {
        return this.trackedUniforms.get(name);
    }

    public Map<String, TrackedResource<?>> getAllUniforms() {
        return this.trackedUniforms;
    }

    public boolean isTrackingUniform(String name) {
        return this.trackedUniforms.containsKey(name);
    }

    public void updateRelations() {
        for (TrackedResourceRelation<?> relation : this.loadedRelations) {
            if (!relation.requiresInternalUpdate()) continue;
            relation.update();
        }
    }

    public void completeFrame() {
        for (TrackedResourceRelation<?> loadedRelation : this.loadedRelations) {
            loadedRelation.resetUpdate();
        }
        this.resetUniformUpdates();
    }

    public <T> TrackedResourceRelation<T> constantRelation(T value) {
        ConstantRelation<T> relation = new ConstantRelation<T>(value);
        this.loadedRelations.add(relation);
        return relation;
    }

    public <T> TrackedResourceRelation<T> identityRelation(String source, Class<T> targetType) {
        TrackedResource<T> trackedResource = this.getTrackedUniform(source);
        if (trackedResource == null) {
            throw new IllegalArgumentException("No such tracked value " + source);
        }
        Class<?> trackedType = trackedResource.getType().getJavaType();
        if (!targetType.isAssignableFrom(trackedType)) {
            throw new IllegalArgumentException("The tracked value " + source + " of type " + trackedType.getName() + " can't be converted into " + targetType.getName());
        }
        IdentityRelation<T> relation = new IdentityRelation<T>(trackedResource);
        this.loadedRelations.add(relation);
        return relation;
    }

    public <T, P> TrackedResourceRelation<T> transformRelation(String source, RelationTransformType transformType, P transformParam, Class<T> targetType) {
        TrackedResource<T> trackedResource = this.getTrackedUniform(source);
        if (trackedResource == null) {
            throw new IllegalArgumentException("No such tracked value " + source);
        }
        Class<?> trackedType = trackedResource.getType().getJavaType();
        Class<?> transformInputType = transformType.getInputType();
        if (!transformInputType.isAssignableFrom(trackedType)) {
            throw new IllegalArgumentException("The tracked value " + source + " of the type " + trackedType.getName() + " is not usable as an input of the transform type " + transformType.name() + " which expects " + transformInputType.getName() + " as inputs");
        }
        Class<?> transformParamType = transformType.getParamType();
        if (transformParamType == null && transformParam != null) {
            throw new IllegalArgumentException("The transform type " + transformType.name() + " does not expect a transform parameter");
        }
        if (transformParamType != null && transformParam == null) {
            throw new IllegalArgumentException("The transform type " + transformType.name() + " requires a parameter of the type " + transformParamType.getName());
        }
        if (transformParamType != null && !transformParamType.isAssignableFrom(transformParam.getClass())) {
            throw new IllegalArgumentException("The transform type " + transformType.name() + " requires a parameter of the type " + transformParamType.getName() + ", but got a " + transformParam.getClass().getName());
        }
        Class<?> transformResultType = transformType.getResultType();
        if (!targetType.isAssignableFrom(transformResultType)) {
            throw new IllegalArgumentException("Transform type " + transformType.name() + " yields values of the type " + transformResultType.getName() + ", but required something compatible with " + targetType.getName());
        }
        BiFunction<?, ?, ?> transformFunction = transformType.getTransformer();
        TransformingRelation<Object> relation = new TransformingRelation<Object>(trackedResource, value -> transformFunction.apply(value, transformParam));
        this.loadedRelations.add(relation);
        return relation;
    }

    public void destroy() {
        this.loadedRelations.clear();
        this.trackedUniforms.clear();
    }

    public static String closestResourceName(String name, List<String> resources) {
        String bestMatch = name;
        int score = Integer.MAX_VALUE;
        for (String resource : resources) {
            int currentScore = Math.abs(bestMatch.compareToIgnoreCase(resource));
            if (currentScore >= score) continue;
            bestMatch = resource;
            score = currentScore;
        }
        return bestMatch;
    }
}

