/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.tracking;

import graphics.continuum.tracking.TrackedResource;
import java.util.Objects;

public abstract class TrackedResourceRelation<T> {
    protected final TrackedResource<?> trackedResource;
    private boolean requiresUpdate;
    private T currentValue;

    protected TrackedResourceRelation(TrackedResource<?> trackedResource, T currentValue) {
        this.trackedResource = trackedResource;
        this.currentValue = currentValue;
    }

    public T getValue() {
        return this.currentValue;
    }

    public boolean requiresInternalUpdate() {
        return this.trackedResource.requiresUpdate();
    }

    public boolean requiresUpdate() {
        return this.requiresUpdate;
    }

    public void resetUpdate() {
        this.requiresUpdate = false;
    }

    public abstract void update();

    protected final void doUpdate(T newValue) {
        if (!Objects.equals(this.currentValue, newValue)) {
            this.currentValue = newValue;
            this.requiresUpdate = true;
        }
    }
}

