/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.tracking;

import graphics.continuum.tracking.UniformTypeBase;
import java.nio.ByteBuffer;
import java.util.Objects;

public class TrackedResource<T> {
    private final UniformTypeBase type;
    private boolean requiresUpdate;
    private T value;

    public TrackedResource(UniformTypeBase type) {
        this.type = type;
    }

    public void update(Object value) {
        if (Objects.equals(this.value, value)) {
            return;
        }
        this.requiresUpdate = true;
        this.value = this.type.accept(value);
    }

    public boolean requiresUpdate() {
        return this.requiresUpdate;
    }

    public UniformTypeBase getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public void resetUpdate() {
        this.requiresUpdate = false;
    }

    public int size() {
        return this.type.size();
    }

    public int align(int current) {
        return this.type.align(current);
    }

    public void write(ByteBuffer buffer) {
        this.type.write(this.value, buffer);
    }

    public void upload(int program, int index) {
        this.type.uploadSingle(program, this.value, index);
    }
}

