/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.shaderpack.impl;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.shaderpack.FocalShaderpackBase;
import graphics.continuum.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZippedFocalShaderpack
extends FocalShaderpackBase {
    private ZipFile zip;
    private final File file;
    private final Path configDir;

    public ZippedFocalShaderpack(String name, File file, Path configDir) throws IOException {
        super(name);
        this.zip = new ZipFile(file);
        this.file = file;
        this.configDir = configDir;
        this.info = this.readShaderpackInfo();
        this.extractConfigFolder();
        this.zip.close();
    }

    @Override
    public void extractConfigFolder() {
        try {
            for (Map.Entry<String, String> entry : this.info.getRedirects().entrySet()) {
                String originalPath = entry.getKey();
                String redirectPath = entry.getValue();
                Path actualRedirectPath = this.configDir.resolve(Paths.get(redirectPath, new String[0]));
                if (!this.isFolder(originalPath)) {
                    if (Files.exists(actualRedirectPath, new LinkOption[0])) continue;
                    this.extractFile(this.file.toPath(), originalPath, actualRedirectPath);
                    continue;
                }
                this.extractInternalConfigFolder(this.zip, originalPath);
            }
        }
        catch (IOException e) {
            FocalEngineCore.getInstance().getLogger().error("Failed to create configs directory", (Throwable)e);
        }
    }

    @Override
    public boolean isFolder(Path path) {
        return !this.anyExtensionPathMatcher.matches(path);
    }

    @Override
    public InputStream getData(String path) {
        String normalizedFileName = ZippedFocalShaderpack.fixPath(path);
        if (this.info != null && this.hasRedirect(normalizedFileName)) {
            try {
                Path configFilePath = this.configDir.resolve(this.getRedirected(normalizedFileName));
                return Files.newInputStream(configFilePath, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getPackData(path);
    }

    @Override
    public InputStream getPackData(String path) {
        path = ZippedFocalShaderpack.fixPath(path);
        try {
            ZipEntry entry = this.zip.getEntry(path);
            return this.zip.getInputStream(entry);
        }
        catch (IOException | NullPointerException e1) {
            try {
                ZipEntry entry = this.zip.getEntry(path.replace("/", "\\"));
                return entry != null ? this.zip.getInputStream(entry) : null;
            }
            catch (IOException e2) {
                FocalEngineCore.getInstance().getLogger().error("Failed to open zip resource", (Throwable)e2);
                return null;
            }
        }
    }

    @Override
    public void writePackToDisk(String path) {
        try {
            Util.unzip(this.file.toPath(), Paths.get(path, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Util.copyDirectory(this.configDir, Paths.get(path, new String[0]));
    }

    @Override
    public boolean hasDataFolder(String path) {
        path = ZippedFocalShaderpack.fixPath(path);
        ZipEntry entryForwardspace = this.zip.getEntry(path);
        ZipEntry entryBackspace = this.zip.getEntry(path.replace("/", "\\"));
        return entryForwardspace != null || entryBackspace != null;
    }

    @Override
    public void create() {
        try {
            this.zip = new ZipFile(this.file);
        }
        catch (IOException e) {
            FocalEngineCore.getInstance().getLogger().error("Failed to open zip resource:\n", (Throwable)e);
        }
        try {
            this.updateShaderpackInfo();
        }
        catch (IOException e) {
            FocalEngineCore.getInstance().getLogger().error("Failed to update shaderpack info: \n", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        try {
            this.zip.close();
            this.zip = null;
        }
        catch (IOException e) {
            FocalEngineCore.getInstance().getLogger().error("Failed to close zip resource:\n", (Throwable)e);
        }
    }

    private void extractFile(Path zipFile, String sourcePath, Path destPath) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(zipFile, this.getClass().getClassLoader());){
            Path fileToExtract = fileSystem.getPath(sourcePath, new String[0]);
            Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
            Files.copy(fileToExtract, destPath, new CopyOption[0]);
        }
    }

    private void extractInternalConfigFolder(ZipFile zipFile, String srcPath) throws IOException {
        Enumeration<? extends ZipEntry> entryEnumerator = zipFile.entries();
        while (entryEnumerator.hasMoreElements()) {
            int length;
            ZipEntry zipEntry = entryEnumerator.nextElement();
            String zipName = ZippedFocalShaderpack.fixPath(zipEntry.getName());
            if (!zipName.startsWith(ZippedFocalShaderpack.fixPath(srcPath)) || zipEntry.isDirectory()) continue;
            InputStream entryInputStream = zipFile.getInputStream(zipEntry);
            Path entryOutputPath = this.configDir.resolve(this.getRedirected(zipName));
            if (Files.exists(entryOutputPath, new LinkOption[0])) continue;
            Files.createDirectories(entryOutputPath.getParent(), new FileAttribute[0]);
            OutputStream entryOutputStream = Files.newOutputStream(entryOutputPath, new OpenOption[0]);
            byte[] buffer = new byte[8192];
            while ((length = entryInputStream.read(buffer)) > 0) {
                entryOutputStream.write(buffer, 0, length);
            }
            entryOutputStream.close();
            entryInputStream.close();
        }
    }
}

