/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.shaderpack.impl;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.shaderpack.FocalShaderpackBase;
import graphics.continuum.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class EncryptedFocalShaderpack
extends FocalShaderpackBase {
    private final Map<String, byte[]> data;
    private final Path configDir;

    public EncryptedFocalShaderpack(String name, Map<String, byte[]> data, Path configDir) throws IOException {
        super(name);
        this.data = data;
        this.configDir = configDir;
        this.info = this.readShaderpackInfo();
        this.extractConfigFolder();
    }

    @Override
    public void create() {
        try {
            this.updateShaderpackInfo();
        }
        catch (IOException e) {
            FocalEngineCore.getInstance().getLogger().error("Failed to update shaderpack info:\n", (Throwable)e);
        }
    }

    @Override
    public void extractConfigFolder() {
        this.data.forEach((s, bytes) -> {
            block15: {
                if (this.hasRedirect(EncryptedFocalShaderpack.fixPath(s)) && ((byte[])bytes).length > 0) {
                    Path configFilePath = this.configDir.resolve(this.getRedirected(EncryptedFocalShaderpack.fixPath(s)));
                    try {
                        Files.createDirectories(configFilePath.getParent(), new FileAttribute[0]);
                        if (Files.exists(configFilePath, new LinkOption[0])) break block15;
                        File configFile = new File(configFilePath.toString());
                        try (FileOutputStream outputStream = new FileOutputStream(configFile);){
                            outputStream.write((byte[])bytes);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public boolean isFolder(Path path) {
        return !this.anyExtensionPathMatcher.matches(path);
    }

    @Override
    public InputStream getData(String path) {
        String normalizedFileName = EncryptedFocalShaderpack.fixPath(path);
        if (this.info != null && this.hasRedirect(normalizedFileName)) {
            try {
                Path configFilePath = this.configDir.resolve(this.getRedirected(normalizedFileName));
                return Files.newInputStream(configFilePath, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getPackData(path);
    }

    @Override
    public InputStream getPackData(String path) {
        byte[] e = this.data.get(EncryptedFocalShaderpack.fixPath(path));
        return e != null ? new ByteArrayInputStream(e) : null;
    }

    @Override
    public void writePackToDisk(String path) {
        this.data.forEach((source, data) -> {
            Path destination = Paths.get(path, source);
            try {
                Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                Files.write(destination, data, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        Util.copyDirectory(this.configDir, Paths.get(path, new String[0]));
    }

    @Override
    public boolean hasDataFolder(String path) {
        return this.data.get(EncryptedFocalShaderpack.fixPath(path)) != null;
    }

    @Override
    public void dispose() {
    }

    public static EncryptedFocalShaderpack load(String name, File file, byte[] key, Path configPath) throws IOException {
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
        try (FileInputStream stream = new FileInputStream(file);){
            int read;
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(key);
                byte[] expected = md.digest();
                byte[] actual = new byte[expected.length];
                if (stream.read(actual) != actual.length) {
                    throw new IOException("Truncated file");
                }
                for (int i = 0; i < expected.length; ++i) {
                    if (expected[i] == actual[i]) continue;
                    throw new IOException("Checksum failure");
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
            byte[] buffer = new byte[key.length];
            while ((read = stream.read(buffer)) != -1) {
                for (int i = 0; i < read; ++i) {
                    int n = i;
                    buffer[n] = (byte)(buffer[n] ^ key[i]);
                }
                bufferStream.write(buffer, 0, read);
            }
        }
        bufferStream.close();
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        try (ByteArrayInputStream binaryStream = new ByteArrayInputStream(bufferStream.toByteArray());
             ZipInputStream zipStream = new ZipInputStream(binaryStream);){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                String entryName = EncryptedFocalShaderpack.fixPath(entry.getName());
                if (entry.isDirectory()) {
                    data.put(entryName, new byte[0]);
                } else {
                    try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                        int read;
                        byte[] buffer = new byte[4096];
                        while ((read = zipStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, read);
                        }
                        data.put(entryName, outputStream.toByteArray());
                    }
                }
                zipStream.closeEntry();
            }
        }
        return new EncryptedFocalShaderpack(name, data, configPath);
    }
}

