/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.shaderpack.impl;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.shaderpack.FocalShaderpackBase;
import graphics.continuum.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;

public class DirectoryFocalShaderpack
extends FocalShaderpackBase {
    private final Path baseDir;
    private final Path configDir;

    public DirectoryFocalShaderpack(String name, Path baseDir, Path configDir) throws IOException {
        super(name);
        this.baseDir = baseDir;
        this.configDir = configDir;
        this.info = this.readShaderpackInfo();
    }

    @Override
    public void create() {
        try {
            this.updateShaderpackInfo();
        }
        catch (IOException e) {
            FocalEngineCore.getInstance().getLogger().error("Failed to update shaderpack info:\n", (Throwable)e);
        }
    }

    @Override
    public void extractConfigFolder() {
        if (this.info != null) {
            try {
                for (Map.Entry<String, String> entry : this.info.getRedirects().entrySet()) {
                    String originalPath = entry.getKey();
                    Path actualOriginalPath = this.baseDir.resolve(originalPath);
                    if (!this.isFolder(originalPath)) {
                        Path redirectedPath = this.configDir.resolve(this.getRedirected(originalPath));
                        if (Files.exists(redirectedPath, new LinkOption[0])) continue;
                        Files.createDirectories(redirectedPath.getParent(), new FileAttribute[0]);
                        Files.copy(actualOriginalPath, redirectedPath, new CopyOption[0]);
                        continue;
                    }
                    Stream<Path> paths = Files.walk(actualOriginalPath, new FileVisitOption[0]);
                    Throwable throwable = null;
                    try {
                        paths.forEach(path -> {
                            Path redirectedPath = this.configDir.resolve(this.getRedirected(this.baseDir.relativize((Path)path).toString()));
                            if (!this.isFolder((Path)path) && !Files.exists(redirectedPath, new LinkOption[0])) {
                                try {
                                    Files.createDirectories(redirectedPath.getParent(), new FileAttribute[0]);
                                    Files.copy(path, redirectedPath, new CopyOption[0]);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (paths == null) continue;
                        if (throwable != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        paths.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isFolder(Path path) {
        return !this.anyExtensionPathMatcher.matches(path.getFileName());
    }

    @Override
    public InputStream getData(String path) {
        String normalizedFileName = DirectoryFocalShaderpack.fixPath(path);
        return this.getPackData(path);
    }

    @Override
    public InputStream getPackData(String path) {
        try {
            String normalizedFileName = DirectoryFocalShaderpack.fixPath(path);
            return Files.newInputStream(this.baseDir.resolve(normalizedFileName), new OpenOption[0]);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void writePackToDisk(String path) {
        Path destination = Paths.get(path, new String[0]);
        Util.copyDirectory(this.baseDir, destination);
        Util.copyDirectory(this.configDir, destination);
    }

    @Override
    public boolean hasDataFolder(String path) {
        return Files.isDirectory(this.baseDir.resolve(DirectoryFocalShaderpack.fixPath(path)), new LinkOption[0]);
    }
}

