/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.shaderpack;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.impl.api.game.FocalEngineGameInterface;
import graphics.continuum.impl.api.game.FocalEngineGameProfiler;
import graphics.continuum.renderer.framebuffer.FrameBuffer;
import graphics.continuum.renderer.framebuffer.FrameBufferManager;
import graphics.continuum.renderer.renderpass.RenderPassManager;
import graphics.continuum.renderer.shaderstorage.ShaderStorageManager;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.renderer.uniform.UniformManager;
import graphics.continuum.renderer.vertex.VertexManager;
import graphics.continuum.shaderpack.FocalShaderpackBase;
import graphics.continuum.shaderpack.impl.EncryptedFocalShaderpack;
import graphics.continuum.tracking.TrackedResources;
import graphics.continuum.util.Util;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL46C;

public class ShaderpackManager {
    public static final Path SHADERPACKS_FOLDER = Paths.get("focal", "shaderpacks");
    public static final Path CONFIGS_FOLDER = Paths.get("focal", "configs");
    public static Path TEMP_DIRECTORY = null;
    private final List<String> whitelist = new ArrayList<String>();
    private final Map<String, FocalShaderpackBase> registeredPacks = new HashMap<String, FocalShaderpackBase>();
    private final Map<String, List<byte[]>> alreadyUsedEncryptionKeys = new HashMap<String, List<byte[]>>();
    private FocalShaderpackBase currentShaderpack;
    private TrackedResources trackedResources;
    private FrameBufferManager frameBufferManager;
    private RenderPassManager renderPassManager;
    private UniformManager uniformManager;
    private TextureManager textureManager;
    private VertexManager vertexManager;
    private ShaderStorageManager shaderStorageManager;

    public ShaderpackManager() {
        this.allowPack("continuum");
    }

    public void setupShaderpack(String name) {
        this.rescan();
        this.currentShaderpack = this.getPack(name);
        if (this.currentShaderpack != null) {
            this.currentShaderpack.create();
            this.currentShaderpack.extractConfigFolder();
        }
    }

    public void loadShaderpack(String name, boolean forceReload) {
        if (this.currentShaderpack != null && this.currentShaderpack.getName().equals(name) && !forceReload) {
            return;
        }
        this.destroy();
        if (name == null) {
            this.currentShaderpack = null;
        } else {
            this.setupShaderpack(name);
            if (this.currentShaderpack == null) {
                throw new IllegalArgumentException("No shaderpack with the name " + name + " present");
            }
            try {
                this.initRenderer();
            }
            catch (Exception e) {
                FocalEngineCore.getInstance().getLogger().error("Failed to load shaderpack:", (Throwable)e);
                FocalEngineGameInterface.sendMessage("Failed to load shaderpack " + name + ": " + e.getMessage());
                this.destroy();
            }
        }
    }

    private void initRenderer() throws Exception {
        GL46C.glEnable((int)33346);
        FocalEngineCore.GL_DEBUG_GROUPS = false;
        this.currentShaderpack.create();
        this.currentShaderpack.extractConfigFolder();
        this.trackedResources = new TrackedResources();
        FocalEngineGameInterface.updateTrackedWindowUniforms(this.trackedResources);
        this.trackedResources.updateRelations();
        this.trackedResources.markUniformUpdate("firstFrame", true);
        this.vertexManager = new VertexManager(this);
        this.textureManager = new TextureManager(this);
        this.frameBufferManager = new FrameBufferManager(this);
        this.uniformManager = new UniformManager(this);
        this.shaderStorageManager = new ShaderStorageManager(this);
        this.renderPassManager = new RenderPassManager(this);
        GL46C.glUseProgram((int)0);
    }

    public void preRender() {
        FocalEngineGameProfiler.push("focal-pre-render");
        FocalEngineGameInterface.updateTrackedWindowUniforms(this.trackedResources);
        FocalEngineGameInterface.updateTrackedInGameUniforms(this.trackedResources);
        this.trackedResources.updateRelations();
        this.vertexManager.updateVertexArray();
        this.textureManager.updateAll();
        this.frameBufferManager.updateAll();
        this.shaderStorageManager.updateAll();
        this.textureManager.clearTextures();
        FrameBuffer defaultFrameBuffer = this.frameBufferManager.getDefaultFrameBuffer();
        defaultFrameBuffer.bind();
        GL46C.glNamedFramebufferTexture((int)defaultFrameBuffer.getID(), (int)36064, (int)this.textureManager.getTexture(defaultFrameBuffer.getInfo().getColorAttachment()).getTextureID(null, false), (int)0);
        GL46C.glNamedFramebufferDrawBuffer((int)defaultFrameBuffer.getID(), (int)36064);
        FocalEngineGameProfiler.pop();
    }

    public void renderFrame() {
        FocalEngineGameProfiler.push("focal-render");
        this.trackedResources.updateRelations();
        this.uniformManager.updateUniformBlocks();
        this.renderPassManager.renderFrame();
        this.trackedResources.completeFrame();
        this.trackedResources.markUniformUpdate("firstFrame", false);
        FocalEngineGameProfiler.pop();
    }

    public void destroy() {
        FocalEngineCore.GL_DEBUG_GROUPS = false;
        GL46C.glDisable((int)33346);
        if (this.renderPassManager != null) {
            this.renderPassManager.destroy(this);
        }
        if (this.frameBufferManager != null) {
            this.frameBufferManager.destroy(this);
        }
        if (this.textureManager != null) {
            this.textureManager.destroy();
        }
        if (this.uniformManager != null) {
            this.uniformManager.destroy();
        }
        if (this.vertexManager != null) {
            this.vertexManager.destroy(this);
        }
        if (this.shaderStorageManager != null) {
            this.shaderStorageManager.destroy();
        }
        if (this.trackedResources != null) {
            this.trackedResources.destroy();
        }
        this.currentShaderpack = null;
        GL46C.glUseProgram((int)0);
    }

    public FocalShaderpackBase getPack(String name) {
        String matchingKey = "";
        for (String key : this.registeredPacks.keySet()) {
            int lastIndex = key.lastIndexOf(46);
            if (lastIndex == -1) {
                lastIndex = key.length();
            }
            if (!key.substring(0, lastIndex).equals(name)) continue;
            matchingKey = key;
            break;
        }
        return !matchingKey.isEmpty() ? this.registeredPacks.get(matchingKey) : null;
    }

    public List<String> getInjectedNames() {
        ArrayList<String> injectedNames = new ArrayList<String>();
        this.registeredPacks.values().forEach(pack -> injectedNames.add(pack.getName()));
        return injectedNames;
    }

    /*
     * Exception decompiling
     */
    public byte[] getShaderpackResourceData(String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getShaderpackResourceString(String path) throws IOException {
        return new String(this.getShaderpackResourceData(path), StandardCharsets.UTF_8);
    }

    public void rescan() {
        byte[] encryptionKey;
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        Logger logger = engineInstance.getLogger();
        if (!Files.isDirectory(SHADERPACKS_FOLDER, new LinkOption[0])) {
            try {
                Files.createDirectories(SHADERPACKS_FOLDER, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("Failed to create shaderpacks directory: ", (Throwable)e);
            }
        }
        if (!Files.isDirectory(CONFIGS_FOLDER, new LinkOption[0])) {
            try {
                Files.createDirectories(CONFIGS_FOLDER, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("Failed to create configs directory: ", (Throwable)e);
            }
        }
        if (engineInstance.getAccountLoadThread().isAlive()) {
            logger.info("Account load thread is still running, waiting for thread to finish before continuing...");
            try {
                engineInstance.getAccountLoadThread().join(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.info("Account load thread finished, continuing...");
        }
        byte[] byArray = encryptionKey = engineInstance.hasAccount() ? engineInstance.getAccount().getEncryptionKey() : new byte[]{};
        if (!engineInstance.hasAccount()) {
            logger.warn("User is not currently logged into a Continuum Graphics account, so encrypted packs will be unavailable until they log in.");
        }
        try {
            this.deregisterRemovedPacks();
            try (Stream<Path> pathsStream = Files.list(SHADERPACKS_FOLDER);){
                Object[] pathsArray;
                for (Object o : pathsArray = pathsStream.toArray()) {
                    Path path = (Path)o;
                    String fileName = path.getFileName().toString();
                    String fileNameNoExt = Util.getFileNameNoExt(fileName);
                    boolean validPack = false;
                    for (String registeredPack : this.whitelist) {
                        if (!path.getFileName().toString().toLowerCase().startsWith(registeredPack)) continue;
                        validPack = true;
                        break;
                    }
                    if (!validPack || this.registeredPacks.containsKey(fileName)) continue;
                    Path packConfigFolderPath = CONFIGS_FOLDER.resolve(fileNameNoExt);
                    if (!path.toString().endsWith(".bin") || !Files.isRegularFile(path, new LinkOption[0]) || this.alreadyUsedEncryptionKeys.containsKey(fileName) && this.alreadyUsedEncryptionKeys.get(fileName).contains(encryptionKey)) continue;
                    try {
                        EncryptedFocalShaderpack pack = EncryptedFocalShaderpack.load(fileNameNoExt, path.toFile(), encryptionKey, packConfigFolderPath);
                        this.registeredPacks.put(fileName, pack);
                        this.alreadyUsedEncryptionKeys.remove(fileName);
                    }
                    catch (IOException e) {
                        if (!this.alreadyUsedEncryptionKeys.containsKey(fileName)) {
                            this.alreadyUsedEncryptionKeys.put(fileName, new ArrayList());
                        }
                        this.alreadyUsedEncryptionKeys.get(fileName).add(encryptionKey);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("Finished scanning for shader packs!");
    }

    public void deregister(String registeredName) {
        this.registeredPacks.remove(registeredName);
        this.alreadyUsedEncryptionKeys.remove(registeredName);
    }

    public void deregisterEncryptedPacks() {
        ArrayList<String> packsToRemove = new ArrayList<String>();
        for (Map.Entry<String, FocalShaderpackBase> entry : this.registeredPacks.entrySet()) {
            String registeredName = entry.getKey();
            FocalShaderpackBase registeredPack = entry.getValue();
            if (!(registeredPack instanceof EncryptedFocalShaderpack)) continue;
            packsToRemove.add(registeredName);
        }
        packsToRemove.forEach(this::deregister);
    }

    public void deregisterRemovedPacks() {
        ArrayList<String> packsToRemove = new ArrayList<String>();
        for (String registeredName : this.registeredPacks.keySet()) {
            Path registeredPath = SHADERPACKS_FOLDER.resolve(registeredName);
            if (Files.exists(registeredPath, new LinkOption[0])) continue;
            packsToRemove.add(registeredName);
        }
        packsToRemove.forEach(this::deregister);
    }

    public void allowPack(String name) {
        this.whitelist.add(name);
    }

    public boolean isAnyShaderpackLoaded() {
        return this.currentShaderpack != null;
    }

    public FocalShaderpackBase getCurrentShaderpack() {
        return this.currentShaderpack;
    }

    private void nameMinecraftObjects() {
    }

    public FrameBufferManager getFrameBufferManager() {
        return this.frameBufferManager;
    }

    public RenderPassManager getRenderPassManager() {
        return this.renderPassManager;
    }

    public UniformManager getUniformManager() {
        return this.uniformManager;
    }

    public TextureManager getTextureManager() {
        return this.textureManager;
    }

    public VertexManager getVertexManager() {
        return this.vertexManager;
    }

    public ShaderStorageManager getShaderStorageManager() {
        return this.shaderStorageManager;
    }

    public TrackedResources getTrackedResources() {
        return this.trackedResources;
    }

    private void writePackToTempDirectory() {
        if (this.currentShaderpack != null) {
            if (TEMP_DIRECTORY != null) {
                Util.deleteFolderRecursive(new File(String.valueOf(TEMP_DIRECTORY)));
                TEMP_DIRECTORY = null;
            }
            try {
                TEMP_DIRECTORY = Files.createTempDirectory(UUID.randomUUID().toString(), new FileAttribute[0]);
                this.currentShaderpack.writePackToDisk(String.valueOf(TEMP_DIRECTORY));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

