/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.shaderpack;

import com.fasterxml.jackson.core.JsonProcessingException;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.data.shaderpack.ShaderpackInfo;
import graphics.continuum.data.shaderpack.ShaderpackMetadataInfo;
import graphics.continuum.data.shaderpack.config.ShaderpackConfigInfo;
import graphics.continuum.data.shaderpack.config.UserConfigInfo;
import graphics.continuum.data.shaderpack.old.ShaderpackInfoB13;
import graphics.continuum.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public abstract class FocalShaderpackBase {
    protected final PathMatcher anyExtensionPathMatcher = FileSystems.getDefault().getPathMatcher("glob:*.*");
    protected ShaderpackInfo info;
    protected final String name;

    public FocalShaderpackBase(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract InputStream getData(String var1);

    public abstract InputStream getPackData(String var1);

    public abstract void writePackToDisk(String var1);

    public abstract boolean hasDataFolder(String var1);

    public abstract void extractConfigFolder();

    public abstract boolean isFolder(Path var1);

    public boolean isFolder(String path) {
        return this.isFolder(Paths.get(path, new String[0]));
    }

    public boolean hasDirectRedirect(String path) {
        return this.info.getRedirects().containsKey(path);
    }

    public boolean hasIndirectRedirect(String path) {
        Path actualPath = Paths.get(path, new String[0]);
        for (String internalPath : this.info.getRedirects().keySet()) {
            Path actualInternalPath = Paths.get(internalPath, new String[0]);
            if (actualPath.equals(actualInternalPath) || !actualPath.startsWith(actualInternalPath)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRedirect(String path) {
        return this.hasDirectRedirect(path) || this.hasIndirectRedirect(path);
    }

    public Pair<String, String> getDirectRedirect(String path) {
        Map<String, String> redirects = this.info.getRedirects();
        if (!redirects.containsKey(path)) {
            return null;
        }
        return new Pair<String, String>(path, redirects.get(path));
    }

    public Pair<String, String> getIndirectRedirect(String path) {
        Path actualPath = Paths.get(path, new String[0]);
        for (Map.Entry<String, String> entry : this.info.getRedirects().entrySet()) {
            String internalPath = entry.getKey();
            String redirectPath = entry.getValue();
            Path actualInternalPath = Paths.get(internalPath, new String[0]);
            if (actualPath.equals(actualInternalPath) || !actualPath.startsWith(actualInternalPath)) continue;
            return new Pair<String, String>(internalPath, redirectPath);
        }
        return null;
    }

    public Pair<String, String> getRedirect(String path) {
        Pair<String, String> directRedirect = this.getDirectRedirect(path);
        if (directRedirect != null) {
            return directRedirect;
        }
        return this.getIndirectRedirect(path);
    }

    public String getRedirected(String path) {
        Path givenPath = Paths.get(path, new String[0]);
        Pair<String, String> redirect = this.getRedirect(path);
        if (redirect == null) {
            return path;
        }
        Path originalPath = Paths.get(redirect.getA(), new String[0]);
        Path redirectPath = Paths.get(redirect.getB(), new String[0]);
        if (this.isFolder(redirectPath)) {
            return redirectPath.resolve(originalPath.relativize(givenPath)).toString();
        }
        return redirectPath.toString();
    }

    public void create() {
    }

    public void dispose() {
    }

    protected static String fixPath(String path) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public ShaderpackInfo getShaderpackInfo() {
        return this.info;
    }

    protected ShaderpackInfo readShaderpackInfo() throws IOException {
        String shaderpackInfoJson;
        try (InputStream stream = this.getPackData("/shaderpack.json");
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int read;
            if (stream == null) {
                out.close();
                ShaderpackInfo shaderpackInfo = null;
                return shaderpackInfo;
            }
            byte[] buffer = new byte[4096];
            while ((read = stream.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            shaderpackInfoJson = new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        try {
            ShaderpackInfo info = JsonUtil.MAPPER.readValue(shaderpackInfoJson, ShaderpackInfo.class);
            HashMap<String, String> tempRedirects = new HashMap<String, String>(info.getRedirects());
            tempRedirects.forEach((k, v) -> {
                info.getRedirects().remove(k);
                info.getRedirects().put(FocalShaderpackBase.fixPath(k), FocalShaderpackBase.fixPath(v));
            });
            return info;
        }
        catch (JsonProcessingException e1) {
            try {
                ShaderpackInfoB13 oldInfo = JsonUtil.MAPPER.readValue(shaderpackInfoJson, ShaderpackInfoB13.class);
                HashMap<String, String> generatedRedirects = new HashMap<String, String>();
                generatedRedirects.put(FocalShaderpackBase.fixPath(oldInfo.getDefaultInternalConfigFolder()), "");
                generatedRedirects.put("shaders/block.properties", "block.properties");
                return new ShaderpackInfo(new ShaderpackMetadataInfo("", "", null, null), new ShaderpackConfigInfo(generatedRedirects, new UserConfigInfo("configs", "userconfig")), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), true);
            }
            catch (JsonProcessingException e2) {
                throw e1;
            }
        }
    }

    public void updateShaderpackInfo() throws IOException {
        this.info = this.readShaderpackInfo();
    }
}

