/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.uniform;

import graphics.continuum.tracking.TrackedResource;
import java.nio.ByteBuffer;

public class UniformUpload {
    private int offset;
    private final ByteBuffer uploadBuffer;

    public UniformUpload(int offset, ByteBuffer uploadBuffer) {
        this.offset = offset;
        this.uploadBuffer = uploadBuffer;
    }

    public void add(TrackedResource<?> trackedResource) {
        int alignedOffset = trackedResource.align(this.uploadBuffer.position());
        this.uploadBuffer.position(alignedOffset);
        trackedResource.write(this.uploadBuffer);
        int sizeDiff = this.uploadBuffer.position() - alignedOffset;
        if (sizeDiff != trackedResource.size()) {
            throw new IllegalStateException("Uniform wrote invalid amount of bytes to the buffer, expected " + trackedResource.size() + " bytes, but got " + sizeDiff);
        }
    }

    public int offset() {
        return this.offset;
    }

    public void finish() {
        this.uploadBuffer.limit(this.uploadBuffer.position());
        this.uploadBuffer.position(this.offset);
    }

    public ByteBuffer getUploadBuffer() {
        return this.uploadBuffer;
    }
}

