/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.uniform;

import graphics.continuum.tracking.UniformTypeBase;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4fc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4fc;
import org.joml.Vector4ic;
import org.lwjgl.opengl.ARBBindlessTexture;
import org.lwjgl.opengl.ARBGPUShaderInt64;
import org.lwjgl.opengl.GL46;
import org.lwjgl.system.MemoryStack;

public enum UniformType implements UniformTypeBase
{
    BOOLEAN(4, Boolean.class, current -> {
        int padding = current % 4;
        return current - padding + (padding == 0 ? 0 : 4);
    }, (b, buffer) -> buffer.putInt(b != false ? 1 : 0), (program, b, index) -> GL46.glProgramUniform1i((int)program, (int)index, (int)(b != false ? 1 : 0))),
    FLOAT(4, Float.class, current -> {
        int padding = current % 4;
        return current - padding + (padding == 0 ? 0 : 4);
    }, (v, buffer) -> buffer.putFloat(v.floatValue()), (program, v, index) -> GL46.glProgramUniform1f((int)program, (int)index, (float)v.floatValue())),
    INTEGER(4, Integer.class, current -> {
        int padding = current % 4;
        return current - padding + (padding == 0 ? 0 : 4);
    }, (v, buffer) -> buffer.putInt((int)v), (program, v, index) -> GL46.glProgramUniform1i((int)program, (int)index, (int)v)),
    VEC2(8, Vector2fc.class, current -> {
        int padding = current % 8;
        return current - padding + (padding == 0 ? 0 : 8);
    }, (v, buffer) -> {
        v.get(buffer);
        buffer.position(buffer.position() + 8);
    }, (program, v, index) -> GL46.glProgramUniform2f((int)program, (int)index, (float)v.x(), (float)v.y())),
    IVEC2(8, Vector2ic.class, current -> {
        int padding = current % 8;
        return current - padding + (padding == 0 ? 0 : 8);
    }, (v, buffer) -> {
        v.get(buffer);
        buffer.position(buffer.position() + 8);
    }, (program, v, index) -> GL46.glProgramUniform2i((int)program, (int)index, (int)v.x(), (int)v.y())),
    VEC3(16, Vector3fc.class, current -> {
        int padding = current % 16;
        return current - padding + (padding == 0 ? 0 : 16);
    }, (v, buffer) -> {
        v.get(buffer);
        buffer.position(buffer.position() + 16);
    }, (program, v, index) -> GL46.glProgramUniform3f((int)program, (int)index, (float)v.x(), (float)v.y(), (float)v.z())),
    IVEC3(16, Vector3ic.class, current -> {
        int padding = current % 16;
        return current - padding + (padding == 0 ? 0 : 16);
    }, (v, buffer) -> {
        v.get(buffer);
        buffer.position(buffer.position() + 16);
    }, (program, v, index) -> GL46.glProgramUniform3i((int)program, (int)index, (int)v.x(), (int)v.y(), (int)v.z())),
    VEC4(16, Vector4fc.class, current -> {
        int padding = current % 16;
        return current - padding + (padding == 0 ? 0 : 16);
    }, (v, buffer) -> {
        v.get(buffer);
        buffer.position(buffer.position() + 16);
    }, (program, v, index) -> GL46.glProgramUniform4f((int)program, (int)index, (float)v.x(), (float)v.y(), (float)v.z(), (float)v.w())),
    IVEC4(16, Vector4ic.class, current -> {
        int padding = current % 16;
        return current - padding + (padding == 0 ? 0 : 16);
    }, (v, buffer) -> {
        v.get(buffer);
        buffer.position(buffer.position() + 16);
    }, (program, v, index) -> GL46.glProgramUniform4i((int)program, (int)index, (int)v.x(), (int)v.y(), (int)v.z(), (int)v.w())),
    MAT4(64, Matrix4fc.class, current -> {
        int padding = current % 16;
        return current - padding + (padding == 0 ? 0 : 16);
    }, (v, buffer) -> {
        v.get(buffer);
        buffer.position(buffer.position() + 64);
    }, (program, v, index) -> {
        try (MemoryStack stack = MemoryStack.stackPush();){
            GL46.glProgramUniformMatrix4fv((int)program, (int)index, (boolean)false, (FloatBuffer)v.get(stack.mallocFloat(16)));
        }
    }),
    SAMPLER(4, Integer.class, current -> {
        int padding = current % 4;
        return current - padding + (padding == 0 ? 0 : 4);
    }, (v, buffer) -> buffer.putInt((int)v), (program, v, index) -> GL46.glProgramUniform1i((int)program, (int)index, (int)v)),
    IMAGE(4, Integer.class, current -> {
        int padding = current % 4;
        return current - padding + (padding == 0 ? 0 : 4);
    }, (v, buffer) -> buffer.putInt((int)v), (program, v, index) -> GL46.glProgramUniform1i((int)program, (int)index, (int)v)),
    SAMPLER_BINDLESS(8, Long.class, current -> {
        int padding = current % 8;
        return current - padding + (padding == 0 ? 0 : 8);
    }, (v, buffer) -> buffer.putLong((long)v), (program, v, index) -> ARBBindlessTexture.glProgramUniformHandleui64ARB((int)program, (int)index, (long)v)),
    IMAGE_BINDLESS(8, Long.class, current -> {
        int padding = current % 8;
        return current - padding + (padding == 0 ? 0 : 8);
    }, (v, buffer) -> buffer.putLong((long)v), (program, v, index) -> ARBBindlessTexture.glProgramUniformHandleui64ARB((int)program, (int)index, (long)v)),
    INT64(8, Long.class, current -> {
        int padding = current % 8;
        return current - padding + (padding == 0 ? 0 : 8);
    }, (v, buffer) -> buffer.putLong((long)v), (program, v, index) -> ARBGPUShaderInt64.glProgramUniform1i64ARB((int)program, (int)index, (long)v));

    private final int size;
    private final Class<?> javaType;
    private final Function<Integer, Integer> aligner;
    private final BiConsumer<Object, ByteBuffer> writer;
    private final TriConsumer<Integer, Object, Integer> uploader;

    private UniformType(int size, Class<?> javaType, Function<Integer, Integer> aligner, BiConsumer<?, ByteBuffer> writer, TriConsumer<Integer, ?, Integer> uploader) {
        this.size = size;
        this.javaType = javaType;
        this.aligner = aligner;
        this.writer = writer;
        this.uploader = uploader;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public Object accept(Object value) {
        if (!this.javaType.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Tried to put value of type " + value.getClass().getName() + " into uniform of type " + this.javaType.getName() + " [" + this.name() + "]");
        }
        return value;
    }

    @Override
    public int align(int current) {
        return this.aligner.apply(current);
    }

    @Override
    public void write(Object value, ByteBuffer buffer) {
        this.writer.accept(this.accept(value), buffer);
    }

    public Function<Integer, Integer> getAligner() {
        return this.aligner;
    }

    public BiConsumer<Object, ByteBuffer> getWriter() {
        return this.writer;
    }

    @Override
    public void uploadSingle(int program, Object value, int index) {
        this.uploader.accept((Object)program, this.accept(value), (Object)index);
    }

    public static UniformType getUniformTypeFromGLType(int type) {
        switch (type) {
            case 5126: {
                return FLOAT;
            }
            case 35664: {
                return VEC2;
            }
            case 35665: {
                return VEC3;
            }
            case 35666: {
                return VEC4;
            }
            case 35676: {
                return MAT4;
            }
            case 5124: {
                return INTEGER;
            }
            case 35667: {
                return IVEC2;
            }
            case 35668: {
                return IVEC3;
            }
            case 35669: {
                return IVEC4;
            }
            case 35670: {
                return BOOLEAN;
            }
            case 5135: {
                return INT64;
            }
        }
        return null;
    }

    public static boolean isGLTypeGenericImage(int type) {
        switch (type) {
            case 36940: 
            case 36941: 
            case 36942: 
            case 36943: 
            case 36944: 
            case 36945: 
            case 36946: 
            case 36947: 
            case 36948: 
            case 36949: 
            case 36950: 
            case 36951: 
            case 36952: 
            case 36953: 
            case 36954: 
            case 36955: 
            case 36956: 
            case 36957: 
            case 36958: 
            case 36959: 
            case 36960: 
            case 36961: 
            case 36962: 
            case 36963: 
            case 36964: 
            case 36965: 
            case 36966: 
            case 36967: 
            case 36968: 
            case 36969: 
            case 36970: 
            case 36971: 
            case 36972: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGLTypeSamplerGeneric(int type) {
        switch (type) {
            case 35677: 
            case 35678: 
            case 35679: 
            case 35680: 
            case 35683: 
            case 36288: 
            case 36289: 
            case 36290: 
            case 36297: 
            case 36298: 
            case 36299: 
            case 36300: 
            case 36301: 
            case 36302: 
            case 36303: 
            case 36304: 
            case 36305: 
            case 36306: 
            case 36307: 
            case 36308: 
            case 36309: 
            case 36310: 
            case 36311: 
            case 36312: 
            case 36876: 
            case 36878: 
            case 36879: 
            case 37128: 
            case 37129: 
            case 37130: 
            case 37131: 
            case 37132: 
            case 37133: {
                return true;
            }
        }
        return false;
    }
}

