/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.uniform;

import com.fasterxml.jackson.databind.JavaType;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.data.uniform.UniformBlockInfo;
import graphics.continuum.renderer.renderpass.program.Program;
import graphics.continuum.renderer.renderpass.program.ProgramResourceInterface;
import graphics.continuum.renderer.uniform.UniformBlock;
import graphics.continuum.shaderpack.ShaderpackManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;

public class UniformManager {
    private final Map<String, UniformBlock> CURRENT_BLOCKS = new HashMap<String, UniformBlock>();

    public UniformManager(ShaderpackManager shaderpackManager) throws InvalidPropertiesFormatException {
        try {
            List uniformBlockInfos = (List)JsonUtil.MAPPER.readValue(shaderpackManager.getShaderpackResourceString("/uniforms.json"), (JavaType)JsonUtil.MAPPER.getTypeFactory().constructCollectionType(List.class, UniformBlockInfo.class));
            uniformBlockInfos.forEach(this::newBlock);
        }
        catch (IOException e) {
            FocalEngineCore.getInstance().getLogger().warn("Failed to parse 'uniforms.json'.");
        }
    }

    private void newBlock(UniformBlockInfo uniformBlockInfo) {
        this.CURRENT_BLOCKS.put(uniformBlockInfo.getName(), new UniformBlock(uniformBlockInfo));
    }

    public UniformBlock getUniformBlock(String name) {
        return this.CURRENT_BLOCKS.get(name);
    }

    public Map<String, UniformBlock> getAllBlocks() {
        return this.CURRENT_BLOCKS;
    }

    public void destroy() {
        this.CURRENT_BLOCKS.values().forEach(UniformBlock::destroy);
        this.CURRENT_BLOCKS.clear();
    }

    public void setupProgramUniforms(Program program) {
        this.bindProgramUniforms(program);
        this.bindBlockBuffers(program);
        this.bindBlockUniforms(program);
    }

    public void bindBlockBuffers(Program program) {
        program.getProgramResourceInterface().getActiveUniformBlockResources().forEach(ProgramResourceInterface.ActiveUniformBlockResource::bindBlockBuffer);
    }

    public void bindBlockUniforms(Program program) {
        program.getProgramResourceInterface().getActiveUniformBlockResources().forEach(ProgramResourceInterface.ActiveUniformBlockResource::bindBlockUniform);
    }

    public void updateUniformBlocks() {
        for (UniformBlock uniformBlock : this.CURRENT_BLOCKS.values()) {
            uniformBlock.updateNow();
        }
    }

    public void bindProgramUniforms(Program program) {
        program.getProgramResourceInterface().getActiveUniformResources().forEach(ProgramResourceInterface.ActiveUniformResource::bindUniform);
        program.getProgramResourceInterface().getActiveSamplerResources().forEach(ProgramResourceInterface.ActiveSamplerResource::bindSamplerUniform);
        program.getProgramResourceInterface().getActiveImageResources().forEach(ProgramResourceInterface.ActiveImageResource::bindImageUniform);
    }

    public void updateProgramUniforms(Program program) {
        program.getProgramResourceInterface().getActiveUniformResources().forEach(ProgramResourceInterface.ActiveUniformResource::updateUniform);
    }
}

