/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.uniform;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.uniform.UniformBlockInfo;
import graphics.continuum.renderer.uniform.UniformUpload;
import graphics.continuum.tracking.TrackedResource;
import graphics.continuum.tracking.TrackedResources;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.GL46C;
import org.lwjgl.system.MemoryUtil;

public class UniformBlock {
    private int ubo;
    private final UniformBlockInfo uniformBlockInfo;
    private final Map<TrackedResource<?>, Integer> individualBuffers;
    private ByteBuffer uniformBuffer;
    private final int boundIndex;
    private static int currentBlockCount = -1;

    public UniformBlock(UniformBlockInfo uniformBlockInfo) {
        this.uniformBlockInfo = uniformBlockInfo;
        this.individualBuffers = new LinkedHashMap();
        this.boundIndex = ++currentBlockCount;
        this.init();
    }

    public void init() {
        this.ubo = GL46C.glCreateBuffers();
        this.individualBuffers.clear();
        this.uniformBuffer = this.createUniformBuffer(this.uniformBlockInfo.getActiveUniforms());
        GL46C.glObjectLabel((int)33504, (int)this.ubo, (CharSequence)(this.uniformBlockInfo.getName() + " Buffer"));
        GL46C.glNamedBufferStorage((int)this.ubo, (long)this.uniformBuffer.capacity(), (int)256);
        GL46C.glBindBufferRange((int)35345, (int)this.boundIndex, (int)this.ubo, (long)0L, (long)this.uniformBuffer.capacity());
    }

    public void destroy() {
        currentBlockCount = -1;
        GL46C.glDeleteBuffers((int)this.ubo);
        MemoryUtil.memFree((Buffer)this.uniformBuffer);
    }

    public void reallocate() {
        GL46C.glDeleteBuffers((int)this.ubo);
        MemoryUtil.memFree((Buffer)this.uniformBuffer);
        this.init();
    }

    public boolean needsToBeReallocated() {
        int currentSize = this.uniformBuffer.capacity();
        int updatedSize = 0;
        for (TrackedResource<?> trackedResource : this.individualBuffers.keySet()) {
            int alignmentOffset = trackedResource.align(updatedSize);
            updatedSize = alignmentOffset + trackedResource.size();
        }
        return currentSize != (updatedSize = (int)Math.ceil((double)updatedSize / 16.0) * 16);
    }

    public void bindBuffer() {
        GL46C.glBindBufferRange((int)35345, (int)this.boundIndex, (int)this.ubo, (long)0L, (long)this.uniformBuffer.capacity());
    }

    public void bindBlockUniform(int program, int uniformIndex) {
        GL46C.glUniformBlockBinding((int)program, (int)uniformIndex, (int)this.boundIndex);
    }

    public int getBoundIndex() {
        return this.boundIndex;
    }

    private ByteBuffer createUniformBuffer(List<String> uniformNames) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        TrackedResources trackedResources = engineInstance.getTrackedResources();
        int size = 0;
        for (String name : uniformNames) {
            TrackedResource trackedResource = trackedResources.getTrackedUniform(name);
            if (trackedResource == null) {
                throw new IllegalArgumentException("No tracked value with the name " + name + " found for binding to a uniform block");
            }
            int offset = trackedResource.align(size);
            size = offset + trackedResource.size();
            this.individualBuffers.put(trackedResource, offset);
        }
        return MemoryUtil.memCalloc((int)((int)Math.ceil((double)size / 16.0) * 16));
    }

    public void updateNow() {
        if (this.needsToBeReallocated()) {
            this.reallocate();
        }
        Iterator<Map.Entry<TrackedResource<?>, Integer>> uniforms = this.individualBuffers.entrySet().iterator();
        UniformUpload upload = null;
        while (uniforms.hasNext()) {
            Map.Entry<TrackedResource<?>, Integer> uniformAndOffset = uniforms.next();
            TrackedResource<?> trackedResource = uniformAndOffset.getKey();
            int offset = uniformAndOffset.getValue();
            if (!trackedResource.requiresUpdate()) {
                if (upload == null) continue;
                this.dispatchUpload(upload);
                upload = null;
                continue;
            }
            if (upload == null) {
                upload = new UniformUpload(offset, (ByteBuffer)this.uniformBuffer.slice().order(ByteOrder.nativeOrder()).position(offset));
            }
            upload.add(trackedResource);
        }
        if (upload != null) {
            this.dispatchUpload(upload);
        }
    }

    private void dispatchUpload(UniformUpload upload) {
        upload.finish();
        GL45C.glNamedBufferSubData((int)this.ubo, (long)upload.offset(), (ByteBuffer)upload.getUploadBuffer());
    }

    public UniformBlockInfo getInfo() {
        return this.uniformBlockInfo;
    }
}

