/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.uniform;

import graphics.continuum.tracking.UniformTypeBase;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.lwjgl.opengl.ARBBindlessTexture;

public class ArrayUniformType
implements UniformTypeBase {
    private int size;
    private Class<?> javaType;
    private Function<Integer, Integer> aligner;
    private BiConsumer<long[], ByteBuffer> writer;

    public ArrayUniformType(int arrayLength) {
        this.init(arrayLength);
    }

    public void init(int arrayLength) {
        this.size = arrayLength * 8;
        this.javaType = long[].class;
        this.aligner = current -> {
            int padding = current % 8;
            return current - padding + (padding == 0 ? 0 : 8);
        };
        this.writer = (l, buffer) -> {
            buffer.asLongBuffer().put((long[])l);
            buffer.position(this.size);
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public Object accept(Object value) {
        if (!this.javaType.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Tried to put value of type " + value.getClass().getName() + " into uniform of type " + this.javaType.getName());
        }
        return value;
    }

    @Override
    public int align(int current) {
        return this.aligner.apply(current);
    }

    @Override
    public void write(Object value, ByteBuffer buffer) {
        this.writer.accept((long[])this.accept(value), buffer);
    }

    @Override
    public void uploadSingle(int program, Object value, int index) {
        ARBBindlessTexture.glProgramUniformHandleui64vARB((int)program, (int)index, (long[])((long[])value));
    }

    public void resize(int newSize) {
        this.init(newSize);
    }

    @Override
    public String name() {
        return "ARRAY";
    }
}

