/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.texture;

import graphics.continuum.data.texture.TextureInfoProxy;
import graphics.continuum.renderer.gl.FocalGlStateManager;
import graphics.continuum.renderer.texture.TextureBase;
import graphics.continuum.renderer.uniform.UniformType;
import graphics.continuum.util.Reference;
import org.lwjgl.opengl.GL46C;

public class TextureProxy
extends TextureBase {
    private final Reference<Integer> textureID;

    protected TextureProxy(String name, Reference<Integer> textureId) {
        super(new TextureInfoProxy(name, textureId));
        this.textureID = textureId;
        if (this.textureID.get() != 0) {
            GL46C.glObjectLabel((int)5890, (int)this.textureID.get(), (CharSequence)(this.textureInfo.getName() + " Texture"));
        }
    }

    @Override
    public int getTextureID(String name, boolean write) {
        return this.textureID.get();
    }

    public void updateTextureID(int textureID) {
        this.textureID.set(textureID);
        this.textureInfo = new TextureInfoProxy(this.getInfo().getName(), this.textureID);
        if (this.textureID.get() != 0) {
            GL46C.glObjectLabel((int)5890, (int)textureID, (CharSequence)(this.getInfo().getName() + " Texture"));
        }
    }

    @Override
    public void bindProgramSamplerUnit(String name, int unit) {
        FocalGlStateManager.bindTextureUnit(unit, this.textureID.get());
    }

    @Override
    public void bindProgramImageUnit(String name, int unit, int access) {
        GL46C.glBindImageTexture((int)unit, (int)this.textureID.get(), (int)0, (boolean)false, (int)0, (int)35002, (int)32856);
    }

    @Override
    public void bindProgramSamplerUniform(int program, int uniformIndex, int unit) {
        UniformType.SAMPLER.uploadSingle(program, unit, uniformIndex);
    }

    @Override
    public void bindProgramImageUniform(int program, int uniformIndex, int unit) {
        UniformType.IMAGE.uploadSingle(program, unit, uniformIndex);
    }

    @Override
    protected void initTexture() {
    }

    @Override
    protected void reallocateTexture() {
    }

    @Override
    public void updateInternalTexture() {
    }

    @Override
    public void destroyTexture() {
    }

    @Override
    public boolean requiresInternalUpdate() {
        return false;
    }

    @Override
    public boolean requiresUniformUpdate() {
        return false;
    }

    @Override
    public void resetUpdates() {
    }

    @Override
    public void clearTexture() {
    }

    @Override
    public void generateTextureMipmaps(String refName, boolean write) {
    }
}

