/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.texture;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.data.texture.TextureInfo;
import graphics.continuum.impl.api.game.FocalEngineGameInterface;
import graphics.continuum.impl.api.optifine.FocalEngineOptifineInterface;
import graphics.continuum.renderer.renderpass.program.Program;
import graphics.continuum.renderer.renderpass.program.ProgramResourceInterface;
import graphics.continuum.renderer.texture.PingPongTexture;
import graphics.continuum.renderer.texture.Texture;
import graphics.continuum.renderer.texture.TextureBase;
import graphics.continuum.renderer.texture.TextureBindless;
import graphics.continuum.renderer.texture.TextureProxy;
import graphics.continuum.shaderpack.ShaderpackManager;
import graphics.continuum.util.Reference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL46C;

public class TextureManager {
    private final Map<String, TextureBase> allTextures = new HashMap<String, TextureBase>();
    private final List<TextureBase> clearList = new ArrayList<TextureBase>();
    private TextureBase debugTarget;

    public TextureManager(ShaderpackManager shaderpackManager) throws InvalidPropertiesFormatException {
        this.init(shaderpackManager);
    }

    public void init(ShaderpackManager shaderpackManager) throws InvalidPropertiesFormatException {
        try {
            List textureInfos = (List)JsonUtil.MAPPER.readValue(shaderpackManager.getShaderpackResourceString("/textures.json"), (JavaType)JsonUtil.MAPPER.getTypeFactory().constructCollectionType(List.class, TextureInfo.class));
            if (textureInfos.isEmpty()) {
                throw new InvalidPropertiesFormatException("Could not create textures");
            }
            GL46C.glPixelStorei((int)3314, (int)0);
            GL46C.glPixelStorei((int)3316, (int)0);
            GL46C.glPixelStorei((int)3315, (int)0);
            GL46C.glPixelStorei((int)3317, (int)4);
            GL46C.glEnable((int)34895);
            textureInfos.forEach(this::initializeTexture);
            FocalEngineGameInterface.registerMinecraftTextures(this);
            FocalEngineOptifineInterface.registerOptifineTextures(this);
        }
        catch (MismatchedInputException e) {
            throw new InvalidPropertiesFormatException(String.join((CharSequence)"", "Failed to load 'textures.json':\n", e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InvalidPropertiesFormatException("Failed to parse 'textures.json'.");
        }
    }

    public void destroy() {
        this.allTextures.values().forEach(TextureBase::destroyTexture);
        this.allTextures.clear();
        this.clearList.clear();
        this.debugTarget = null;
    }

    public void initializeTexture(TextureInfo textureInfo) throws IllegalStateException {
        TextureBase texture = textureInfo.isPingPong() ? new PingPongTexture(textureInfo) : (textureInfo.isBindless() ? new TextureBindless(textureInfo) : new Texture(textureInfo));
        this.allTextures.put(textureInfo.getName(), texture);
        if (textureInfo.shouldClear()) {
            this.clearList.add(texture);
        }
        if (textureInfo.isDebugTarget()) {
            if (this.debugTarget != null) {
                throw new IllegalStateException("Cannot have multiple debug targets!");
            }
            this.debugTarget = texture;
        }
    }

    public void initializeTextureProxy(String name, Reference<Integer> textureId) {
        this.allTextures.put(name, new TextureProxy(name, textureId));
    }

    public TextureBase getTexture(String textureName) {
        return this.allTextures.get(PingPongTexture.ABInternalTexture.removeInternalTextureSuffix(textureName));
    }

    public boolean hasTexture(String textureName) {
        return this.allTextures.containsKey(PingPongTexture.ABInternalTexture.removeInternalTextureSuffix(textureName));
    }

    public Map<String, TextureBase> getAllTextures() {
        return this.allTextures;
    }

    public void updateAll() {
        this.debugTarget = null;
        this.allTextures.values().stream().filter(TextureBase::requiresUniformUpdate).forEach(TextureBase::resetUpdates);
        this.allTextures.values().stream().filter(TextureBase::requiresInternalUpdate).forEach(TextureBase::reallocateTexture);
        FocalEngineGameInterface.updateMinecraftTextures(this);
    }

    public void clearTextures() {
        for (TextureBase texture : this.clearList) {
            texture.clearTexture();
        }
        if (FocalEngineCore.getInstance().getShaderpackManager().getCurrentShaderpack().getShaderpackInfo().shouldFlushClears().booleanValue()) {
            GL46C.glFlush();
        }
    }

    public void postTextureOperations(Program program) {
        ProgramResourceInterface.ProgramABStates ABStates = program.getProgramResourceInterface().getProgramABStates();
        ABStates.getFlipList().forEach(PingPongTexture::flip);
        ABStates.getOverrideList().forEach(PingPongTexture::setActiveInternalTexture);
        ABStates.getSwapList().forEach(PingPongTexture::swap);
    }

    public void bindProgramTextureUnits(Program program) {
        this.bindProgramSamplerUnits(program);
        this.bindProgramImageUnits(program);
    }

    public void updateProgramTextureUnits(Program program) {
        this.updateProgramSamplerUnits(program);
        this.updateProgramImageUnits(program);
    }

    private void bindProgramSamplerUnits(Program program) {
        program.getProgramResourceInterface().getActiveSamplerResources().forEach(ProgramResourceInterface.ActiveSamplerResource::bindSamplerUnit);
    }

    private void updateProgramSamplerUnits(Program program) {
        program.getProgramResourceInterface().getActiveSamplerResources().forEach(ProgramResourceInterface.ActiveSamplerResource::updateSamplerUnit);
    }

    private void bindProgramImageUnits(Program program) {
        program.getProgramResourceInterface().getActiveImageResources().forEach(ProgramResourceInterface.ActiveImageResource::bindImageUnit);
    }

    private void updateProgramImageUnits(Program program) {
        program.getProgramResourceInterface().getActiveImageResources().forEach(ProgramResourceInterface.ActiveImageResource::updateImageUnit);
    }

    public TextureBase getDebugTarget() {
        return this.debugTarget;
    }
}

