/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.texture;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.texture.TextureInfo;
import graphics.continuum.renderer.gl.FocalGlStateManager;
import graphics.continuum.renderer.texture.TextureBase;
import graphics.continuum.renderer.uniform.ArrayUniformType;
import graphics.continuum.renderer.uniform.UniformType;
import graphics.continuum.tracking.TrackedResource;
import graphics.continuum.tracking.TrackedResources;
import java.util.Arrays;
import org.lwjgl.opengl.ARBBindlessTexture;
import org.lwjgl.opengl.GL46C;

public class TextureBindless
extends TextureBase {
    private int TEXTURE_ID = -1;
    private long SAMPLER_HANDLE = -1L;
    private long[] IMAGE_HANDLES = null;
    private final TrackedResource<Long> SAMPLER_HANDLE_UNIFORM;
    private final TrackedResource<Long> IMAGE_HANDLE_UNIFORM;

    protected TextureBindless(TextureInfo textureInfo) throws IllegalArgumentException {
        super(textureInfo);
        if (!this.getInfo().isBindless()) {
            throw new IllegalArgumentException("Focal Internal Error: Texture resource \"" + this.getInfo().getName() + "\" was created as bindless when info.isBindless is false. Skipping resource.");
        }
        this.SAMPLER_HANDLE_UNIFORM = new TrackedResource(UniformType.SAMPLER_BINDLESS);
        this.IMAGE_HANDLE_UNIFORM = new TrackedResource(UniformType.IMAGE_BINDLESS);
        this.initTexture();
    }

    @Override
    public void updateInternalTexture() {
        this.reallocateTexture();
    }

    @Override
    protected void initTexture() {
        if (this.TEXTURE_ID != -1) {
            this.destroyTexture();
        }
        this.TEXTURE_ID = this.getInfo().getTextureType().createTexture();
        GL46C.glObjectLabel((int)5890, (int)this.TEXTURE_ID, (CharSequence)(this.getInfo().getName() + " Texture"));
        this.getInfo().getParameters().forEach((key, value) -> GL46C.glTextureParameteri((int)this.TEXTURE_ID, (int)key, (int)value));
        String textureResourceLocation = this.getInfo().getResourceLocation();
        TextureInfo.TextureType textureType = this.getInfo().getTextureType();
        if (textureResourceLocation == null) {
            textureType.genTextureStorage(this.TEXTURE_ID, this.getInfo());
        } else {
            textureType.loadImage(this.TEXTURE_ID, this.getInfo(), textureResourceLocation);
        }
        if (this.getInfo().shouldInitialize()) {
            this.clearTexture();
        }
        this.generateHandles();
    }

    @Override
    protected void reallocateTexture() {
        this.initTexture();
    }

    private void generateHandles() {
        this.SAMPLER_HANDLE = ARBBindlessTexture.glGetTextureHandleARB((int)this.TEXTURE_ID);
        this.IMAGE_HANDLES = new long[this.getInfo().shouldGenerateMipHandles() ? this.getInfo().getLevelOfDetail() : 1];
        Arrays.setAll(this.IMAGE_HANDLES, idx -> ARBBindlessTexture.glGetImageHandleARB((int)this.TEXTURE_ID, (int)idx, (boolean)this.getInfo().isLayered(), (int)0, (int)this.getInfo().getPixelFormat()));
        ARBBindlessTexture.glMakeTextureHandleResidentARB((long)this.SAMPLER_HANDLE);
        Arrays.stream(this.IMAGE_HANDLES).forEach(handle -> ARBBindlessTexture.glMakeImageHandleResidentARB((long)handle, (int)35002));
        this.SAMPLER_HANDLE_UNIFORM.update(this.SAMPLER_HANDLE);
        this.IMAGE_HANDLE_UNIFORM.update(this.IMAGE_HANDLES[0]);
        TrackedResources tracked = FocalEngineCore.getInstance().getTrackedResources();
        String handlesTrackedValueName = this.getInfo().getName() + "Handles";
        if (!tracked.isTrackingUniform(handlesTrackedValueName)) {
            tracked.registerGlobalUniform(handlesTrackedValueName, new ArrayUniformType(this.IMAGE_HANDLES.length), this.IMAGE_HANDLES);
        } else {
            TrackedResource handlesTrackedResource = tracked.getTrackedUniform(handlesTrackedValueName);
            ((ArrayUniformType)handlesTrackedResource.getType()).resize(this.IMAGE_HANDLES.length);
            tracked.markUniformUpdate(handlesTrackedValueName, this.IMAGE_HANDLES);
        }
    }

    @Override
    public void destroyTexture() {
        if (this.SAMPLER_HANDLE != -1L) {
            ARBBindlessTexture.glMakeTextureHandleNonResidentARB((long)this.SAMPLER_HANDLE);
        }
        if (this.IMAGE_HANDLES != null) {
            Arrays.stream(this.IMAGE_HANDLES).forEach(ARBBindlessTexture::glMakeImageHandleNonResidentARB);
        }
        if (this.TEXTURE_ID != -1) {
            FocalGlStateManager.deleteTexture(this.TEXTURE_ID);
        }
        this.SAMPLER_HANDLE = -1L;
        this.IMAGE_HANDLES = null;
        this.TEXTURE_ID = -1;
    }

    @Override
    public int getTextureID(String name, boolean access) {
        return this.TEXTURE_ID;
    }

    @Override
    public boolean requiresInternalUpdate() {
        return this.getInfo().requiresUpdate();
    }

    @Override
    public boolean requiresUniformUpdate() {
        return this.SAMPLER_HANDLE_UNIFORM.requiresUpdate() || this.IMAGE_HANDLE_UNIFORM.requiresUpdate();
    }

    @Override
    public void resetUpdates() {
        this.SAMPLER_HANDLE_UNIFORM.resetUpdate();
        this.IMAGE_HANDLE_UNIFORM.resetUpdate();
    }

    @Override
    public void bindProgramSamplerUnit(String name, int unit) {
    }

    @Override
    public void bindProgramImageUnit(String name, int unit, int access) {
    }

    @Override
    public void bindProgramSamplerUniform(int program, int uniformIndex, int unit) {
        this.SAMPLER_HANDLE_UNIFORM.upload(program, uniformIndex);
    }

    @Override
    public void bindProgramImageUniform(int program, int uniformIndex, int unit) {
        this.IMAGE_HANDLE_UNIFORM.upload(program, uniformIndex);
    }

    @Override
    public void clearTexture() {
        this.clearTextureBasic(this.TEXTURE_ID, this.getInfo().getClearColor());
    }

    @Override
    public void generateTextureMipmaps(String refName, boolean write) {
        if ((this.getInfo().getLevelOfDetail() > 1 || this.getInfo().getLevelOfDetail() == -1) && this.getInfo().getPixelFormatType() != 5124 && this.getInfo().getPixelFormatType() != 5125) {
            GL46C.glGenerateTextureMipmap((int)this.TEXTURE_ID);
        }
    }
}

