/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.texture;

import graphics.continuum.data.texture.TextureInfo;
import org.lwjgl.opengl.GL44C;

public abstract class TextureBase {
    protected TextureInfo textureInfo;

    protected TextureBase(TextureInfo textureInfo) {
        this.textureInfo = textureInfo;
    }

    public TextureInfo getInfo() {
        return this.textureInfo;
    }

    protected abstract void initTexture();

    protected abstract void reallocateTexture();

    public abstract void updateInternalTexture();

    public abstract void destroyTexture();

    public abstract int getTextureID(String var1, boolean var2);

    public abstract boolean requiresInternalUpdate();

    public abstract boolean requiresUniformUpdate();

    public abstract void resetUpdates();

    public abstract void bindProgramSamplerUnit(String var1, int var2);

    public abstract void bindProgramImageUnit(String var1, int var2, int var3);

    public abstract void bindProgramSamplerUniform(int var1, int var2, int var3);

    public abstract void bindProgramImageUniform(int var1, int var2, int var3);

    public abstract void clearTexture();

    protected void clearTextureBasic(int texture, float[] clearColor) {
        int pixelDataType = this.textureInfo.getPixelFormatType();
        if (pixelDataType == 5131) {
            pixelDataType = 5126;
        }
        GL44C.glClearTexImage((int)texture, (int)0, (int)this.textureInfo.getPixelFormatLayout(), (int)pixelDataType, (float[])clearColor);
    }

    public abstract void generateTextureMipmaps(String var1, boolean var2);
}

