/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.texture;

import graphics.continuum.data.texture.TextureInfo;
import graphics.continuum.renderer.gl.FocalGlStateManager;
import graphics.continuum.renderer.texture.TextureBase;
import graphics.continuum.renderer.uniform.UniformType;
import org.lwjgl.opengl.GL46C;

public class Texture
extends TextureBase {
    private int TEXTURE_ID;

    protected Texture(TextureInfo textureInfo) {
        super(textureInfo);
        this.initTexture();
    }

    @Override
    protected void initTexture() {
        if (this.TEXTURE_ID != -1) {
            this.destroyTexture();
        }
        this.TEXTURE_ID = this.getInfo().getTextureType().createTexture();
        GL46C.glObjectLabel((int)5890, (int)this.TEXTURE_ID, (CharSequence)(this.getInfo().getName() + " Texture"));
        this.getInfo().getParameters().forEach((key, value) -> GL46C.glTextureParameteri((int)this.TEXTURE_ID, (int)key, (int)value));
        String textureResourceLocation = this.getInfo().getResourceLocation();
        TextureInfo.TextureType textureType = this.getInfo().getTextureType();
        if (textureResourceLocation == null) {
            textureType.genTextureStorage(this.TEXTURE_ID, this.getInfo());
        } else {
            textureType.loadImage(this.TEXTURE_ID, this.getInfo(), textureResourceLocation);
        }
        if (this.getInfo().shouldInitialize()) {
            this.clearTexture();
        }
    }

    @Override
    protected void reallocateTexture() {
        this.initTexture();
    }

    @Override
    public void updateInternalTexture() {
        this.reallocateTexture();
    }

    @Override
    public void destroyTexture() {
        FocalGlStateManager.deleteTexture(this.TEXTURE_ID);
        this.TEXTURE_ID = -1;
    }

    @Override
    public int getTextureID(String name, boolean write) {
        return this.TEXTURE_ID;
    }

    @Override
    public boolean requiresInternalUpdate() {
        return this.getInfo().requiresUpdate();
    }

    @Override
    public boolean requiresUniformUpdate() {
        return false;
    }

    @Override
    public void resetUpdates() {
    }

    @Override
    public void bindProgramSamplerUnit(String name, int unit) {
        FocalGlStateManager.bindTextureUnit(unit, this.TEXTURE_ID);
    }

    @Override
    public void bindProgramImageUnit(String name, int unit, int access) {
        GL46C.glBindImageTexture((int)unit, (int)this.TEXTURE_ID, (int)0, (boolean)this.getInfo().isLayered(), (int)0, (int)access, (int)this.getInfo().getPixelFormat());
    }

    @Override
    public void bindProgramSamplerUniform(int program, int uniformIndex, int unit) {
        UniformType.SAMPLER.uploadSingle(program, unit, uniformIndex);
    }

    @Override
    public void bindProgramImageUniform(int program, int uniformIndex, int unit) {
        UniformType.IMAGE.uploadSingle(program, unit, uniformIndex);
    }

    @Override
    public void clearTexture() {
        this.clearTextureBasic(this.TEXTURE_ID, this.getInfo().getClearColor());
    }

    @Override
    public void generateTextureMipmaps(String refName, boolean write) {
        if ((this.getInfo().getLevelOfDetail() > 1 || this.getInfo().getLevelOfDetail() == -1) && this.getInfo().getPixelFormatType() != 5124 && this.getInfo().getPixelFormatType() != 5125) {
            GL46C.glGenerateTextureMipmap((int)this.TEXTURE_ID);
        }
    }
}

