/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.texture;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.texture.TextureInfo;
import graphics.continuum.renderer.texture.Texture;
import graphics.continuum.renderer.texture.TextureBase;
import graphics.continuum.renderer.uniform.UniformType;
import org.lwjgl.opengl.GL43C;

public class PingPongTexture
extends TextureBase {
    private Texture TEXTURE_A;
    private Texture TEXTURE_B;
    private ABInternalTexture activeTexture = ABInternalTexture.A;

    protected PingPongTexture(TextureInfo textureInfo) {
        super(textureInfo);
        if (textureInfo.isBindless()) {
            FocalEngineCore.getInstance().getLogger().warn("PingPong texture: " + textureInfo.getName() + " can not be bindless. Creating bound textures instead.");
        }
        this.TEXTURE_A = new Texture(textureInfo);
        this.TEXTURE_B = new Texture(textureInfo);
        GL43C.glObjectLabel((int)5890, (int)this.TEXTURE_A.getTextureID(null, false), (CharSequence)(textureInfo.getName() + " A Texture"));
        GL43C.glObjectLabel((int)5890, (int)this.TEXTURE_B.getTextureID(null, false), (CharSequence)(textureInfo.getName() + " B Texture"));
    }

    @Override
    protected void initTexture() {
        this.TEXTURE_A.initTexture();
        this.TEXTURE_B.initTexture();
    }

    @Override
    protected void reallocateTexture() {
        this.TEXTURE_A.reallocateTexture();
        this.TEXTURE_B.reallocateTexture();
    }

    @Override
    public void updateInternalTexture() {
        this.reallocateTexture();
    }

    @Override
    public void destroyTexture() {
        this.TEXTURE_A.destroyTexture();
        this.TEXTURE_B.destroyTexture();
    }

    private ABInternalTexture getActiveTextureAtReference(String name, boolean write) {
        if (name == null) {
            return this.activeTexture;
        }
        ABInternalTexture internalTexture = this.activeTexture;
        if (ABInternalTexture.hasAbsoluteInternalTextureSuffix(name)) {
            internalTexture = ABInternalTexture.fromTextureName(name);
        } else if (ABInternalTexture.hasRelativeInternalTextureSuffix(name)) {
            internalTexture = name.toLowerCase().endsWith("w") ? this.activeTexture.other() : this.activeTexture;
        } else if (write) {
            internalTexture = this.activeTexture.other();
        }
        return internalTexture;
    }

    @Override
    public int getTextureID(String name, boolean write) {
        return this.getActiveTextureAtReference(name, write) == ABInternalTexture.A ? this.TEXTURE_A.getTextureID(null, false) : this.TEXTURE_B.getTextureID(null, false);
    }

    @Override
    public boolean requiresInternalUpdate() {
        return this.getInfo().requiresUpdate();
    }

    @Override
    public boolean requiresUniformUpdate() {
        return this.TEXTURE_A.requiresUniformUpdate();
    }

    @Override
    public void resetUpdates() {
        this.TEXTURE_A.resetUpdates();
        this.TEXTURE_B.resetUpdates();
    }

    @Override
    public void bindProgramSamplerUnit(String name, int unit) {
        if (this.getActiveTextureAtReference(name, false) == ABInternalTexture.A) {
            this.TEXTURE_A.bindProgramSamplerUnit(name, unit);
        } else {
            this.TEXTURE_B.bindProgramSamplerUnit(name, unit);
        }
    }

    @Override
    public void bindProgramImageUnit(String name, int unit, int access) {
        if (this.getActiveTextureAtReference(name, access != 35000) == ABInternalTexture.A) {
            this.TEXTURE_A.bindProgramImageUnit(name, unit, access);
        } else {
            this.TEXTURE_B.bindProgramImageUnit(name, unit, access);
        }
    }

    @Override
    public void bindProgramSamplerUniform(int program, int uniformIndex, int unit) {
        UniformType.SAMPLER.uploadSingle(program, unit, uniformIndex);
    }

    @Override
    public void bindProgramImageUniform(int program, int uniformIndex, int unit) {
        UniformType.IMAGE.uploadSingle(program, unit, uniformIndex);
    }

    @Override
    public void clearTexture() {
        if (this.getInfo().shouldClearA()) {
            this.TEXTURE_A.clearTexture();
        }
        if (this.getInfo().shouldClearB()) {
            this.TEXTURE_B.clearTexture();
        }
    }

    @Override
    public void generateTextureMipmaps(String refName, boolean write) {
        this.TEXTURE_A.generateTextureMipmaps(refName, write);
        this.TEXTURE_B.generateTextureMipmaps(refName, write);
    }

    public void flip() {
        this.activeTexture = this.activeTexture.other();
    }

    public void swap() {
        Texture temp = this.TEXTURE_A;
        this.TEXTURE_A = this.TEXTURE_B;
        this.TEXTURE_B = temp;
    }

    public ABInternalTexture getActiveInternalTexture() {
        return this.activeTexture;
    }

    public void setActiveInternalTexture(ABInternalTexture newActiveTexture) {
        this.activeTexture = newActiveTexture;
    }

    public static enum ABInternalTexture {
        A{

            @Override
            public ABInternalTexture other() {
                return B;
            }
        }
        ,
        B{

            @Override
            public ABInternalTexture other() {
                return A;
            }
        };


        public abstract ABInternalTexture other();

        public static ABInternalTexture fromCharacter(String character) {
            switch (character.toLowerCase()) {
                case "a": {
                    return A;
                }
                case "b": {
                    return B;
                }
            }
            return null;
        }

        public static ABInternalTexture fromTextureName(String textureName) {
            return ABInternalTexture.fromCharacter(textureName.substring(textureName.lastIndexOf("_") + 1));
        }

        public static boolean hasAbsoluteInternalTextureSuffix(String textureName) {
            return textureName.toLowerCase().endsWith("_a") || textureName.toLowerCase().endsWith("_b");
        }

        public static boolean hasRelativeInternalTextureSuffix(String textureName) {
            return textureName.toLowerCase().endsWith("_r") || textureName.toLowerCase().endsWith("_w");
        }

        public static String removeInternalTextureSuffix(String textureName) {
            boolean hasSuffix = ABInternalTexture.hasAbsoluteInternalTextureSuffix(textureName) || ABInternalTexture.hasRelativeInternalTextureSuffix(textureName);
            return hasSuffix ? textureName.substring(0, textureName.lastIndexOf("_")) : textureName;
        }
    }
}

