/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.shaderstorage;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.shaderstorage.ShaderStorageInfo;
import graphics.continuum.tracking.TrackedResources;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL46C;
import org.lwjgl.system.MemoryStack;

public class ShaderStorageObject {
    private final ShaderStorageInfo info;
    private int ID;

    public ShaderStorageObject(ShaderStorageInfo info) {
        this.info = info;
        this.init();
    }

    public void init() {
        if (this.ID != -1) {
            this.destroy();
        }
        this.ID = GL46C.glCreateBuffers();
        if (this.info.shouldClassifyTilesVariance()) {
            TrackedResources tracked = FocalEngineCore.getInstance().getTrackedResources();
            int numTiles = (int)(Math.ceil((double)((Integer)tracked.getTrackedUniform("windowWidth").getValue()).intValue() / 8.0) * Math.ceil((double)((Integer)tracked.getTrackedUniform("windowHeight").getValue()).intValue() / 8.0));
            GL46C.glNamedBufferStorage((int)this.ID, (long)((long)numTiles * 2L * 4L), (int)0);
        } else if (this.info.shouldClassifyTilesMask()) {
            TrackedResources tracked = FocalEngineCore.getInstance().getTrackedResources();
            int numTiles = (int)(Math.ceil((double)((Integer)tracked.getTrackedUniform("windowWidth").getValue()).intValue() / 8.0) * Math.ceil((double)((Integer)tracked.getTrackedUniform("windowHeight").getValue()).intValue() / 8.0));
            GL46C.glNamedBufferStorage((int)this.ID, (long)((long)numTiles * 4L), (int)0);
        } else if (this.info.shouldClassifyRayList()) {
            TrackedResources tracked = FocalEngineCore.getInstance().getTrackedResources();
            int numPixels = (Integer)tracked.getTrackedUniform("windowWidth").getValue() * (Integer)tracked.getTrackedUniform("windowHeight").getValue();
            GL46C.glNamedBufferStorage((int)this.ID, (long)((long)numPixels * 4L), (int)0);
        } else if (this.info.getImageHandle() != null) {
            TrackedResources tracked = FocalEngineCore.getInstance().getTrackedResources();
            long[] handles = (long[])tracked.getTrackedUniform(this.info.getImageHandle()).getValue();
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer handleBuff = stack.malloc(handles.length * 8);
                handleBuff.asLongBuffer().put(handles);
                GL46C.glNamedBufferStorage((int)this.ID, (ByteBuffer)handleBuff, (int)0);
            }
        } else {
            GL46C.glNamedBufferStorage((int)this.ID, (long)this.info.getBytes(), (int)0);
        }
        GL46C.glObjectLabel((int)33504, (int)this.ID, (CharSequence)(this.info.getName() + " SSBO"));
    }

    public void destroy() {
        GL46C.glDeleteBuffers((int)this.ID);
        this.ID = -1;
    }

    public int getID() {
        return this.ID;
    }

    public boolean requiresUpdate() {
        if (this.info.shouldClassifyTilesVariance() || this.info.shouldClassifyTilesMask() || this.info.shouldClassifyRayList()) {
            TrackedResources tracked = FocalEngineCore.getInstance().getTrackedResources();
            return tracked.getTrackedUniform("windowWidth").requiresUpdate() || tracked.getTrackedUniform("windowHeight").requiresUpdate();
        }
        if (this.info.getImageHandle() != null) {
            return FocalEngineCore.getInstance().getTrackedResources().getTrackedUniform(this.info.getImageHandle()).requiresUpdate();
        }
        return false;
    }

    public ShaderStorageInfo getInfo() {
        return this.info;
    }
}

