/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.shaderstorage;

import com.fasterxml.jackson.databind.JavaType;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.data.shaderstorage.ShaderStorageInfo;
import graphics.continuum.renderer.renderpass.program.Program;
import graphics.continuum.renderer.renderpass.program.ProgramResourceInterface;
import graphics.continuum.renderer.shaderstorage.ShaderStorageObject;
import graphics.continuum.shaderpack.ShaderpackManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;

public class ShaderStorageManager {
    private final Map<String, ShaderStorageObject> STORAGE_OJECTS = new HashMap<String, ShaderStorageObject>();

    public ShaderStorageManager(ShaderpackManager shaderpackManager) throws InvalidPropertiesFormatException {
        this.init(shaderpackManager);
    }

    public void init(ShaderpackManager shaderpackManager) throws InvalidPropertiesFormatException {
        try {
            List shaderStorageObjects = (List)JsonUtil.MAPPER.readValue(shaderpackManager.getShaderpackResourceString("/storageObjects.json"), (JavaType)JsonUtil.MAPPER.getTypeFactory().constructCollectionType(List.class, ShaderStorageInfo.class));
            shaderStorageObjects.forEach(this::newStorageObject);
        }
        catch (IOException e) {
            throw new InvalidPropertiesFormatException("Failed to parse 'storageObjects.json'.");
        }
    }

    public void bindShaderStorageObjects(Program program) {
        program.getProgramResourceInterface().getActiveShaderStorageResources().forEach(ProgramResourceInterface.ActiveShaderStorageResource::bind);
    }

    public void destroy() {
        this.STORAGE_OJECTS.values().forEach(ShaderStorageObject::destroy);
        this.STORAGE_OJECTS.clear();
    }

    public void newStorageObject(ShaderStorageInfo shaderStorageInfo) {
        this.STORAGE_OJECTS.put(shaderStorageInfo.getName(), new ShaderStorageObject(shaderStorageInfo));
    }

    public ShaderStorageObject getStorageObject(String name) {
        return this.STORAGE_OJECTS.get(name);
    }

    public Map<String, ShaderStorageObject> getAllStorageObjects() {
        return this.STORAGE_OJECTS;
    }

    public void updateAll() {
        for (ShaderStorageObject storageObject : this.STORAGE_OJECTS.values()) {
            if (!storageObject.requiresUpdate()) continue;
            storageObject.init();
        }
    }
}

