/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.renderpass.program;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.data.renderpass.ComputeRenderPassInfo;
import graphics.continuum.data.renderpass.RasterRenderPassInfo;
import graphics.continuum.data.renderpass.RenderPassInfo;
import graphics.continuum.renderer.renderpass.program.Program;
import graphics.continuum.renderer.shaderstorage.ShaderStorageObject;
import graphics.continuum.renderer.texture.PingPongTexture;
import graphics.continuum.renderer.texture.TextureBase;
import graphics.continuum.renderer.uniform.UniformBlock;
import graphics.continuum.renderer.uniform.UniformType;
import graphics.continuum.tracking.TrackedResource;
import graphics.continuum.tracking.TrackedResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL46C;

public class ProgramResourceInterface {
    private final int PROGRAM_ID;
    protected final Program program;
    private final List<ActiveUniformResource> activeUniformResources;
    private final List<ActiveUniformBlockResource> activeUniformBlockResources;
    private final List<ActiveShaderStorageResource> activeShaderStorageResources;
    private final List<ActiveSamplerResource> activeSamplerResources;
    private final List<ActiveImageResource> activeImageResources;
    protected final List<String> activeWriteImages;
    protected final ProgramABStates ABStates;
    protected int textureCount = -1;
    protected int imageCount = -1;

    ProgramResourceInterface(Program program) {
        this.program = program;
        this.PROGRAM_ID = program.getProgramID();
        if (program.getRenderPassInfo().getProgramType() == RenderPassInfo.Type.COMPUTE) {
            this.activeWriteImages = ((ComputeRenderPassInfo)program.getRenderPassInfo()).getOutputImages();
        } else if (program.getRenderPassInfo().getProgramType() == RenderPassInfo.Type.RASTER) {
            this.activeWriteImages = new ArrayList<String>(((RasterRenderPassInfo)program.getRenderPassInfo()).getOutputImages());
            this.activeWriteImages.addAll(new ArrayList<String>(((RasterRenderPassInfo)program.getRenderPassInfo()).getDrawBuffers()));
        } else {
            this.activeWriteImages = Collections.emptyList();
        }
        this.ABStates = new ProgramABStates();
        this.activeUniformResources = new ArrayList<ActiveUniformResource>();
        this.activeUniformBlockResources = new ArrayList<ActiveUniformBlockResource>();
        this.activeShaderStorageResources = new ArrayList<ActiveShaderStorageResource>();
        this.activeSamplerResources = new ArrayList<ActiveSamplerResource>();
        this.activeImageResources = new ArrayList<ActiveImageResource>();
        this.introspectProgramUniforms();
        this.introspectProgramUniformBlocks();
        this.introspectProgramShaderStorage();
    }

    private void introspectProgramUniforms() {
        int activeUniformCount = GL46C.glGetProgramInterfacei((int)this.PROGRAM_ID, (int)37601, (int)37621);
        int[] uniformProperties = new int[]{37629, 37626};
        block4: for (int i = 0; i < activeUniformCount; ++i) {
            int[] currentUniform = new int[uniformProperties.length];
            GL46C.glGetProgramResourceiv((int)this.PROGRAM_ID, (int)37601, (int)i, (int[])uniformProperties, null, (int[])currentUniform);
            if (currentUniform[0] != -1) continue;
            String name = GL46C.glGetProgramResourceName((int)this.PROGRAM_ID, (int)37601, (int)i);
            UniformType uniformType = this.getUniformType(name, currentUniform[1]);
            if (uniformType == null) {
                FocalEngineCore.getInstance().getLogger().warn("Skipping resource, no value assigned for " + name + ".");
                continue;
            }
            switch (uniformType) {
                case SAMPLER: 
                case SAMPLER_BINDLESS: {
                    this.activeSamplerResources.add(new ActiveSamplerResource(name, GL46C.glGetUniformLocation((int)this.PROGRAM_ID, (CharSequence)name)));
                    continue block4;
                }
                case IMAGE: 
                case IMAGE_BINDLESS: {
                    this.activeImageResources.add(new ActiveImageResource(name, GL46C.glGetUniformLocation((int)this.PROGRAM_ID, (CharSequence)name)));
                    continue block4;
                }
                default: {
                    this.activeUniformResources.add(new ActiveUniformResource(name, GL46C.glGetUniformLocation((int)this.PROGRAM_ID, (CharSequence)name)));
                }
            }
        }
    }

    private void introspectProgramUniformBlocks() {
        int activeUniformBlockCount = GL46C.glGetProgramInterfacei((int)this.PROGRAM_ID, (int)37602, (int)37621);
        for (int idx = 0; idx < activeUniformBlockCount; ++idx) {
            String name = GL46C.glGetProgramResourceName((int)this.PROGRAM_ID, (int)37602, (int)idx);
            this.activeUniformBlockResources.add(new ActiveUniformBlockResource(name, idx));
        }
    }

    private void introspectProgramShaderStorage() {
        int activeShaderStorageCount = GL46C.glGetProgramInterfacei((int)this.PROGRAM_ID, (int)37606, (int)37621);
        for (int idx = 0; idx < activeShaderStorageCount; ++idx) {
            String name = GL46C.glGetProgramResourceName((int)this.PROGRAM_ID, (int)37606, (int)idx);
            this.activeShaderStorageResources.add(new ActiveShaderStorageResource(name, idx));
        }
    }

    public List<ActiveUniformResource> getActiveUniformResources() {
        return this.activeUniformResources;
    }

    public List<ActiveUniformBlockResource> getActiveUniformBlockResources() {
        return this.activeUniformBlockResources;
    }

    public List<ActiveShaderStorageResource> getActiveShaderStorageResources() {
        return this.activeShaderStorageResources;
    }

    public List<ActiveImageResource> getActiveImageResources() {
        return this.activeImageResources;
    }

    public List<ActiveSamplerResource> getActiveSamplerResources() {
        return this.activeSamplerResources;
    }

    protected UniformType getUniformType(String name, int type) {
        FocalEngineCore focal = FocalEngineCore.getInstance();
        boolean isArray = name.endsWith("[0]");
        String valueName = isArray ? name.substring(0, name.lastIndexOf(91)) : name;
        valueName = PingPongTexture.ABInternalTexture.removeInternalTextureSuffix(valueName);
        TextureBase texture = focal.getTextureManager().getTexture(valueName);
        if (texture != null) {
            if (UniformType.isGLTypeSamplerGeneric(type)) {
                return texture.getInfo().isBindless() ? UniformType.SAMPLER_BINDLESS : UniformType.SAMPLER;
            }
            if (UniformType.isGLTypeGenericImage(type)) {
                return texture.getInfo().isBindless() ? UniformType.IMAGE_BINDLESS : UniformType.IMAGE;
            }
            focal.getLogger().warn("Texture Uniform Resource: " + name + " used with invalid uniform type: " + JsonUtil.getGLFieldFromValue(type) + " in program " + this.program.getRenderPassInfo().getName() + ". Expected: SAMPLER or IMAGE");
            return null;
        }
        TrackedResource trackedResource = focal.getTrackedResources().getTrackedUniform(valueName);
        if (trackedResource != null) {
            if (trackedResource.getType() == UniformType.getUniformTypeFromGLType(type)) {
                return (UniformType)trackedResource.getType();
            }
            focal.getLogger().warn("Value Uniform Resource: " + name + " used with invalid uniform type: " + JsonUtil.getGLFieldFromValue(type) + " in program " + this.program.getRenderPassInfo().getName() + ". Expected: " + ((UniformType)trackedResource.getType()).name().toLowerCase());
            return null;
        }
        TrackedResource<?> programUniform = this.program.getProgramUniform(valueName);
        if (programUniform != null) {
            if (programUniform.getType() == UniformType.getUniformTypeFromGLType(type)) {
                return (UniformType)programUniform.getType();
            }
            focal.getLogger().warn("Program Uniform Resource: " + name + " used with invalid uniform type: " + JsonUtil.getGLFieldFromValue(type) + " in program " + this.program.getRenderPassInfo().getName() + ". Expected: " + ((UniformType)programUniform.getType()).name().toLowerCase());
            return null;
        }
        ArrayList<String> resources = new ArrayList<String>(focal.getTrackedResources().getAllUniforms().keySet());
        resources.addAll(new ArrayList<String>(focal.getTrackedResources().getAllUniforms().keySet()));
        resources.addAll(new ArrayList<String>(focal.getTextureManager().getAllTextures().keySet()));
        resources.addAll(new ArrayList<String>(focal.getUniformManager().getAllBlocks().keySet()));
        resources.addAll(new ArrayList<String>(focal.getShaderStorageManager().getAllStorageObjects().keySet()));
        String closestResourceName = TrackedResources.closestResourceName(valueName, resources);
        String closestType = focal.getTrackedResources().getTrackedUniform(closestResourceName).getType().name().toLowerCase();
        focal.getLogger().warn("Uniform Resource: " + valueName + " in program: " + this.program.getRenderPassInfo().getName() + " is unknown. Did you mean " + closestType + " " + closestResourceName + "?");
        return null;
    }

    protected void incrementTexture() {
        ++this.textureCount;
    }

    protected void incrementImage() {
        ++this.imageCount;
    }

    public ProgramABStates getProgramABStates() {
        return this.ABStates;
    }

    public class ProgramABStates {
        private final List<PingPongTexture> flipList = new ArrayList<PingPongTexture>();
        private final List<PingPongTexture> swapList = new ArrayList<PingPongTexture>();
        private final Map<PingPongTexture, PingPongTexture.ABInternalTexture> overrideList = new HashMap<PingPongTexture, PingPongTexture.ABInternalTexture>();
        private List<String> disabledFlips = new ArrayList<String>();

        private ProgramABStates() {
            RenderPassInfo renderPassInfo = ProgramResourceInterface.this.program.getRenderPassInfo();
            if (renderPassInfo instanceof RasterRenderPassInfo) {
                RasterRenderPassInfo rasterRenderPassInfo = (RasterRenderPassInfo)renderPassInfo;
                this.disabledFlips = rasterRenderPassInfo.getDisabledFlips();
                rasterRenderPassInfo.getDrawBuffers().forEach(this::interpretWriteFlip);
                rasterRenderPassInfo.getForcedFlips().forEach(this::interpretForceFlip);
                rasterRenderPassInfo.getInternalTextureSwaps().forEach(this::interpretSwap);
                rasterRenderPassInfo.getForcedActiveTextures().forEach(this::interpretOverride);
            } else if (renderPassInfo instanceof ComputeRenderPassInfo) {
                ComputeRenderPassInfo computeRenderPassInfo = (ComputeRenderPassInfo)renderPassInfo;
                this.disabledFlips = computeRenderPassInfo.getDisabledFlips();
                computeRenderPassInfo.getForcedFlips().forEach(this::interpretForceFlip);
                computeRenderPassInfo.getInternalTextureSwaps().forEach(this::interpretSwap);
                computeRenderPassInfo.getForcedActiveTextures().forEach(this::interpretOverride);
            }
        }

        public List<PingPongTexture> getFlipList() {
            return this.flipList;
        }

        public List<PingPongTexture> getSwapList() {
            return this.swapList;
        }

        public Map<PingPongTexture, PingPongTexture.ABInternalTexture> getOverrideList() {
            return this.overrideList;
        }

        private void interpretWriteFlip(String textureName) {
            TextureBase texture = FocalEngineCore.getInstance().getTextureManager().getTexture(textureName);
            if (texture instanceof PingPongTexture && !PingPongTexture.ABInternalTexture.hasAbsoluteInternalTextureSuffix(textureName) && !this.disabledFlips.contains(texture.getInfo().getName())) {
                this.flipList.add((PingPongTexture)texture);
            }
        }

        private void interpretForceFlip(String textureName) {
            TextureBase texture = FocalEngineCore.getInstance().getTextureManager().getTexture(textureName);
            if (texture instanceof PingPongTexture) {
                this.flipList.add((PingPongTexture)texture);
            }
        }

        private void interpretSwap(String textureName) {
            TextureBase texture = FocalEngineCore.getInstance().getTextureManager().getTexture(textureName);
            if (texture instanceof PingPongTexture) {
                this.swapList.add((PingPongTexture)texture);
            }
        }

        private void interpretOverride(String textureName, String activeTexture) {
            TextureBase texture = FocalEngineCore.getInstance().getTextureManager().getTexture(textureName);
            if (texture instanceof PingPongTexture) {
                this.overrideList.put((PingPongTexture)texture, PingPongTexture.ABInternalTexture.fromCharacter(activeTexture));
            }
        }
    }

    public class ActiveImageResource {
        private final String name;
        private final TextureBase texture;
        private final int uniformIndex;
        private final int imageUnit;
        private final int access;
        private final boolean updatingUnit;

        public ActiveImageResource(String name, int uniformIndex) {
            this.name = name;
            this.texture = FocalEngineCore.getInstance().getTextureManager().getTexture(name);
            this.uniformIndex = uniformIndex;
            this.updatingUnit = this.texture instanceof PingPongTexture;
            int n = this.access = ProgramResourceInterface.this.activeWriteImages.contains(PingPongTexture.ABInternalTexture.removeInternalTextureSuffix(name)) ? 35002 : 35000;
            if (!this.texture.getInfo().isBindless()) {
                ProgramResourceInterface.this.incrementImage();
            }
            this.imageUnit = ProgramResourceInterface.this.imageCount;
        }

        public void bindImageUnit() {
            this.texture.bindProgramImageUnit(this.name, this.imageUnit, this.access);
        }

        public void updateImageUnit() {
            if (this.updatingUnit) {
                this.texture.bindProgramImageUnit(this.name, this.imageUnit, this.access);
            }
        }

        public void bindImageUniform() {
            this.texture.bindProgramImageUniform(ProgramResourceInterface.this.PROGRAM_ID, this.uniformIndex, this.imageUnit);
        }
    }

    public class ActiveSamplerResource {
        private final String name;
        private final int uniformIndex;
        private final int textureUnit;
        private final TextureBase texture;
        private final boolean updatingUnit;

        public ActiveSamplerResource(String name, int uniformIndex) {
            this.name = name;
            this.texture = FocalEngineCore.getInstance().getTextureManager().getTexture(name);
            this.uniformIndex = uniformIndex;
            boolean bl = this.updatingUnit = this.texture instanceof PingPongTexture && !PingPongTexture.ABInternalTexture.hasAbsoluteInternalTextureSuffix(name);
            if (!this.texture.getInfo().isBindless()) {
                ProgramResourceInterface.this.incrementTexture();
            }
            this.textureUnit = ProgramResourceInterface.this.textureCount;
        }

        public void bindSamplerUnit() {
            if (this.texture.getInfo().isBindless() && (this.texture.requiresUniformUpdate() || this.texture.requiresInternalUpdate())) {
                this.texture.bindProgramSamplerUniform(ProgramResourceInterface.this.PROGRAM_ID, this.uniformIndex, this.textureUnit);
            } else {
                this.texture.bindProgramSamplerUnit(this.name, this.textureUnit);
            }
        }

        public void updateSamplerUnit() {
            if (this.updatingUnit) {
                this.texture.bindProgramSamplerUnit(this.name, this.textureUnit);
            }
        }

        public void bindSamplerUniform() {
            this.texture.bindProgramSamplerUniform(ProgramResourceInterface.this.PROGRAM_ID, this.uniformIndex, this.textureUnit);
        }
    }

    public class ActiveShaderStorageResource {
        private final String name;
        private final int uniformIndex;
        private final ShaderStorageObject storageObject;

        public String getName() {
            return this.name;
        }

        public ActiveShaderStorageResource(String name, int uniformIndex) {
            this.name = name;
            this.storageObject = FocalEngineCore.getInstance().getShaderStorageManager().getStorageObject(name);
            this.uniformIndex = uniformIndex;
        }

        public void bind() {
            GL46C.glBindBufferBase((int)37074, (int)this.uniformIndex, (int)this.storageObject.getID());
            GL46C.glShaderStorageBlockBinding((int)ProgramResourceInterface.this.PROGRAM_ID, (int)this.uniformIndex, (int)this.uniformIndex);
        }
    }

    public class ActiveUniformBlockResource {
        private final String name;
        private final int uniformIndex;
        private final UniformBlock uniformBlock;

        public ActiveUniformBlockResource(String name, int uniformIndex) {
            this.name = name;
            this.uniformBlock = FocalEngineCore.getInstance().getUniformManager().getUniformBlock(name);
            this.uniformIndex = uniformIndex;
        }

        public String getName() {
            return this.name;
        }

        public void bindBlockUniform() {
            this.uniformBlock.bindBlockUniform(ProgramResourceInterface.this.PROGRAM_ID, this.uniformIndex);
        }

        public void bindBlockBuffer() {
            this.uniformBlock.bindBuffer();
        }
    }

    public class ActiveUniformResource {
        private final String name;
        private final TrackedResource<?> trackedResource;
        private final int uniformIndex;

        public ActiveUniformResource(String name, int uniformIndex) {
            this.name = name;
            this.trackedResource = ProgramResourceInterface.this.program.getProgramUniform(name);
            this.uniformIndex = uniformIndex;
        }

        public String getName() {
            return this.name;
        }

        public void bindUniform() {
            this.trackedResource.upload(ProgramResourceInterface.this.PROGRAM_ID, this.uniformIndex);
        }

        public void updateUniform() {
            if (this.trackedResource.requiresUpdate()) {
                this.trackedResource.upload(ProgramResourceInterface.this.PROGRAM_ID, this.uniformIndex);
            }
        }
    }
}

