/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.renderpass.program;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.renderpass.ComputeRenderPassInfo;
import graphics.continuum.data.renderpass.RasterRenderPassInfo;
import graphics.continuum.data.renderpass.RenderPassInfo;
import graphics.continuum.data.renderpass.ShaderType;
import graphics.continuum.renderer.renderpass.ShaderLoader;
import graphics.continuum.renderer.renderpass.program.ProgramResourceInterface;
import graphics.continuum.renderer.uniform.UniformType;
import graphics.continuum.tracking.TrackedResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL46C;

public class Program {
    private final int PROGRAM_ID;
    private final Map<ShaderType, String> shaders;
    private final List<Integer> shaderIDs = new ArrayList<Integer>();
    private final ProgramResourceInterface programResourceInterface;
    private final RenderPassInfo renderPassInfo;
    private final TrackedResource<Integer> iterations = new TrackedResource(UniformType.INTEGER);
    private final TrackedResource<Integer> groupIteration = new TrackedResource(UniformType.INTEGER);
    private final TrackedResource<Integer> syncExecutions = new TrackedResource(UniformType.INTEGER);
    private final TrackedResource<Vector3ic> dispatchSize = new TrackedResource(UniformType.IVEC3);

    public Program(RenderPassInfo renderPassInfo, Map<ShaderType, String> shaders) {
        this.renderPassInfo = renderPassInfo;
        this.PROGRAM_ID = GL46C.glCreateProgram();
        this.shaders = shaders;
        ShaderLoader.compileShaders(this, this.shaderIDs::add);
        GL46C.glLinkProgram((int)this.PROGRAM_ID);
        this.shaderIDs.forEach(GL20C::glDeleteShader);
        int linkStatus = GL46C.glGetProgrami((int)this.PROGRAM_ID, (int)35714);
        if (linkStatus == 0) {
            String log = GL46C.glGetProgramInfoLog((int)this.PROGRAM_ID);
            FocalEngineCore.getInstance().getLogger().error("Shaders program {} failed to link: {}", (Object)renderPassInfo.getName(), (Object)log);
            throw new IllegalStateException("Shaders program " + renderPassInfo.getName() + " failed to link:\n" + log);
        }
        this.setLabel(renderPassInfo);
        this.programResourceInterface = new ProgramResourceInterface(this);
        this.updateCurrentIteration(0);
        this.updateCurrentGroupIteration(0);
        this.updateCurrentSyncExecution(0);
        this.updateCurrentDispatchSize();
    }

    private void setLabel(RenderPassInfo renderPassInfo) {
        switch (renderPassInfo.getProgramType()) {
            case RASTER: {
                String frameBufferName = ((RasterRenderPassInfo)renderPassInfo).getFrameBufferName();
                GL46C.glObjectLabel((int)33506, (int)this.PROGRAM_ID, (CharSequence)(renderPassInfo.getName() + " Raster Program for Frame Buffer " + frameBufferName));
                break;
            }
            case COMPUTE: {
                GL46C.glObjectLabel((int)33506, (int)this.PROGRAM_ID, (CharSequence)(renderPassInfo.getName() + " Compute Program"));
                break;
            }
            default: {
                GL46C.glObjectLabel((int)33506, (int)this.PROGRAM_ID, (CharSequence)renderPassInfo.getName());
            }
        }
    }

    public TrackedResource<?> getProgramUniform(String uniformName) {
        switch (uniformName) {
            case "dispatchSize": {
                return this.dispatchSize;
            }
            case "iteration": {
                return this.iterations;
            }
            case "syncExecution": {
                return this.syncExecutions;
            }
            case "groupIteration": {
                return this.groupIteration;
            }
        }
        return FocalEngineCore.getInstance().getTrackedResources().getTrackedUniform(uniformName);
    }

    public void updateCurrentIteration(Integer iteration) {
        this.iterations.update(iteration);
    }

    public void updateCurrentGroupIteration(Integer iteration) {
        this.groupIteration.update(iteration);
    }

    public void updateCurrentSyncExecution(Integer execution) {
        this.syncExecutions.update(execution);
    }

    public void updateCurrentDispatchSize() {
        if (this.renderPassInfo instanceof ComputeRenderPassInfo) {
            ComputeRenderPassInfo computeInfo = (ComputeRenderPassInfo)this.renderPassInfo;
            this.dispatchSize.update(new Vector3i(computeInfo.getDispatchResolutionX().intValue(), computeInfo.getDispatchResolutionY().intValue(), computeInfo.getDispatchResolutionZ().intValue()));
        }
    }

    public Map<ShaderType, String> getShaders() {
        return this.shaders;
    }

    public int getProgramID() {
        return this.PROGRAM_ID;
    }

    public void use() {
        GL46C.glUseProgram((int)this.PROGRAM_ID);
    }

    public void release() {
        GL46C.glUseProgram((int)0);
    }

    public RenderPassInfo getRenderPassInfo() {
        return this.renderPassInfo;
    }

    public ProgramResourceInterface getProgramResourceInterface() {
        return this.programResourceInterface;
    }
}

