/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.renderpass.passes;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.renderpass.ComputeRenderPassInfo;
import graphics.continuum.data.renderpass.RasterRenderPassInfo;
import graphics.continuum.data.renderpass.RenderPassGroupInfo;
import graphics.continuum.data.renderpass.RenderPassInfo;
import graphics.continuum.data.texture.TextureInfo;
import graphics.continuum.renderer.renderpass.RenderPass;
import graphics.continuum.renderer.renderpass.passes.ComputeRenderPass;
import graphics.continuum.renderer.renderpass.passes.RasterRenderPass;
import graphics.continuum.renderer.texture.TextureBase;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.renderer.uniform.UniformType;
import graphics.continuum.tracking.TrackedResource;
import graphics.continuum.tracking.TrackedResources;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL46C;

public class RenderPassGroup
extends RenderPass {
    private final RenderPassGroupInfo groupInfo;
    TrackedResource<?> groupIteration = new TrackedResource(UniformType.INTEGER);
    private final List<RenderPass> ALL_PASSES = new ArrayList<RenderPass>();

    public RenderPassGroup(RenderPassGroupInfo info) {
        super(info);
        this.groupInfo = info;
        info.getPasses().forEach(this::register);
    }

    public void register(RenderPassInfo renderPassInfo) {
        Logger logger = FocalEngineCore.getInstance().getLogger();
        switch (renderPassInfo.getProgramType()) {
            case RASTER: {
                logger.info("Registering raster render pass {} to render pass group {}", (Object)renderPassInfo.getName(), (Object)this.groupInfo.getName());
                this.ALL_PASSES.add(new RasterRenderPass((RasterRenderPassInfo)renderPassInfo));
                break;
            }
            case COMPUTE: {
                logger.info("Registering compute render pass {} to render pass group {}", (Object)renderPassInfo.getName(), (Object)this.groupInfo.getName());
                this.ALL_PASSES.add(new ComputeRenderPass((ComputeRenderPassInfo)renderPassInfo));
                break;
            }
            case GROUP: {
                logger.info("Registering render pass sub-group {} to render pass group {}", (Object)renderPassInfo.getName(), (Object)this.groupInfo.getName());
                this.ALL_PASSES.add(new RenderPassGroup((RenderPassGroupInfo)renderPassInfo));
            }
        }
    }

    @Override
    public void render() {
        TrackedResource runConditionValue;
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        TrackedResources trackedResources = engineInstance.getTrackedResources();
        TextureManager textureManager = engineInstance.getTextureManager();
        String runConditionValueName = this.groupInfo.getRunIfTrueValueName();
        if (runConditionValueName != null && !runConditionValueName.isEmpty() && (runConditionValue = trackedResources.getTrackedUniform(runConditionValueName)).getValue() instanceof Boolean && !((Boolean)runConditionValue.getValue()).booleanValue()) {
            return;
        }
        GL46C.glPushDebugGroup((int)33354, (int)0, (CharSequence)(this.getRenderPassInfo().getName() + " Group"));
        int iterations = this.groupInfo.getIterations();
        for (int i = 0; i < iterations; ++i) {
            if (iterations > 1) {
                GL46C.glPushDebugGroup((int)33354, (int)0, (CharSequence)("Iteration " + i));
            }
            this.groupIteration.update(i);
            if (this.groupInfo.shouldPreFlush()) {
                GL46C.glFlush();
            }
            int iterI = i;
            this.ALL_PASSES.forEach(pass -> {
                if (pass instanceof RasterRenderPass) {
                    ((RasterRenderPass)pass).getRasterProgram().updateCurrentGroupIteration(iterI);
                } else if (pass instanceof ComputeRenderPass) {
                    ((ComputeRenderPass)pass).getComputeProgram().updateCurrentGroupIteration(iterI);
                }
            });
            this.ALL_PASSES.forEach(RenderPass::render);
            for (String textureName : this.groupInfo.getForcedMipmaps()) {
                TextureBase texture = textureManager.getTexture(textureName);
                TextureInfo textureInfo = texture.getInfo();
                if (!this.groupInfo.getForcedMipmaps().contains(textureInfo.getName())) continue;
                boolean isWriteTexture = textureName.endsWith("_w");
                texture.generateTextureMipmaps(textureName, isWriteTexture);
            }
            if (this.groupInfo.shouldPostFlush()) {
                GL46C.glFlush();
            }
            if (iterations <= 1) continue;
            GL46C.glPopDebugGroup();
        }
        GL46C.glPopDebugGroup();
    }

    @Override
    public void destroy() {
        this.ALL_PASSES.forEach(RenderPass::destroy);
        this.ALL_PASSES.clear();
    }

    public RenderPassGroupInfo getInfo() {
        return this.groupInfo;
    }
}

