/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.renderpass.passes;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.renderpass.BlendState;
import graphics.continuum.data.renderpass.FramebufferBlit;
import graphics.continuum.data.renderpass.GeometryType;
import graphics.continuum.data.renderpass.RasterRenderPassInfo;
import graphics.continuum.data.texture.TextureInfo;
import graphics.continuum.renderer.framebuffer.FrameBuffer;
import graphics.continuum.renderer.framebuffer.FrameBufferManager;
import graphics.continuum.renderer.renderpass.RenderPass;
import graphics.continuum.renderer.renderpass.program.Program;
import graphics.continuum.renderer.shaderstorage.ShaderStorageManager;
import graphics.continuum.renderer.texture.TextureBase;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.renderer.uniform.UniformManager;
import graphics.continuum.renderer.vertex.VertexManager;
import graphics.continuum.tracking.TrackedResource;
import graphics.continuum.tracking.TrackedResources;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL46C;

public class RasterRenderPass
extends RenderPass {
    private final Program rasterProgram;
    private final RasterRenderPassInfo rasterInfo;
    protected final Map<String, Integer> activeDrawBuffers = new HashMap<String, Integer>();
    protected final int[] colorAttachmentBuffer;

    public RasterRenderPass(RasterRenderPassInfo renderPassInfo) throws IllegalStateException {
        super(renderPassInfo);
        this.rasterInfo = renderPassInfo;
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        TextureManager textureManager = engineInstance.getTextureManager();
        renderPassInfo.getDrawBuffers().forEach(textureName -> {
            if (!textureManager.hasTexture((String)textureName)) {
                throw new IllegalStateException("Texture '" + textureName + "' used as raster render pass drawbuffer, texture does not exist.");
            }
        });
        renderPassInfo.getInternalTextureSwaps().forEach(texureName -> {
            if (!engineInstance.getTextureManager().hasTexture((String)texureName)) {
                throw new IllegalStateException("Internal textures for texture '" + texureName + "' swapped after raster render pass, texture does not exist.");
            }
        });
        this.rasterProgram = new Program(this.rasterInfo, renderPassInfo.getShaders());
        this.rasterProgram.use();
        List<String> currentDrawBuffer = renderPassInfo.getDrawBuffers();
        this.colorAttachmentBuffer = new int[currentDrawBuffer.size()];
        this.setColorAttachments(currentDrawBuffer, this.activeDrawBuffers, this.colorAttachmentBuffer);
        engineInstance.getUniformManager().setupProgramUniforms(this.rasterProgram);
    }

    @Override
    public void render() {
        TrackedResource runConditionValue;
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        TrackedResources trackedResources = engineInstance.getTrackedResources();
        String runConditionValueName = this.rasterInfo.getRunIfTrueValueName();
        if (runConditionValueName != null && !runConditionValueName.isEmpty() && (runConditionValue = trackedResources.getTrackedUniform(runConditionValueName)).getValue() instanceof Boolean && !((Boolean)runConditionValue.getValue()).booleanValue()) {
            return;
        }
        GL46C.glPushDebugGroup((int)33354, (int)0, (CharSequence)this.info.getName());
        int iterations = this.rasterInfo.getIterations();
        TextureManager textureManager = engineInstance.getTextureManager();
        FrameBufferManager frameBufferManager = engineInstance.getFrameBufferManager();
        ShaderStorageManager shaderStorageManager = engineInstance.getShaderStorageManager();
        VertexManager vertexManager = engineInstance.getVertexManager();
        UniformManager uniformManager = engineInstance.getUniformManager();
        this.rasterProgram.use();
        frameBufferManager.updateRenderPassFrameBufferBinding(this);
        vertexManager.bindVertexArray(this);
        shaderStorageManager.bindShaderStorageObjects(this.rasterProgram);
        textureManager.bindProgramTextureUnits(this.rasterProgram);
        this.rasterProgram.updateCurrentDispatchSize();
        if (this.rasterInfo.getGeometryType() == GeometryType.FULLSCREEN && this.rasterInfo.isDepthBlend() == null) {
            GL11C.glDepthMask((boolean)false);
            GL46C.glDisable((int)2929);
        } else if (this.rasterInfo.isDepthBlend() == null) {
            GL11C.glDepthMask((boolean)true);
        } else if (this.rasterInfo.isDepthBlend().booleanValue()) {
            GL11C.glDepthMask((boolean)true);
            GL46C.glEnable((int)2929);
        } else {
            GL11C.glDepthMask((boolean)false);
            GL46C.glDisable((int)2929);
        }
        if (!this.rasterInfo.getBufferBlendStates().isEmpty()) {
            GL46C.glEnable((int)3042);
            for (BlendState blendState : this.rasterInfo.getBufferBlendStates()) {
                blendState.updateBlendState(this.activeDrawBuffers.get(blendState.textureName) - 36064);
            }
        }
        for (int i = 0; i < iterations; ++i) {
            if (iterations > 1) {
                GL46C.glPushDebugGroup((int)33354, (int)0, (CharSequence)("Iteration " + i));
            }
            this.rasterProgram.updateCurrentIteration(i);
            frameBufferManager.updateRenderPassRenderTargets(this);
            uniformManager.updateProgramUniforms(this.rasterProgram);
            textureManager.updateProgramTextureUnits(this.rasterProgram);
            if (this.rasterInfo.getInstanceCount() <= 1) {
                GL46C.glDrawArrays((int)4, (int)0, (int)3);
            } else {
                GL46C.glDrawArraysInstanced((int)4, (int)0, (int)3, (int)this.rasterInfo.getInstanceCount());
            }
            for (String textureName : this.rasterInfo.getOutputImages()) {
                boolean shouldGenerateMipmaps;
                TextureBase texture = textureManager.getTexture(textureName);
                TextureInfo textureInfo = texture.getInfo();
                boolean bl = shouldGenerateMipmaps = textureInfo.shouldAutoGenerateMipmaps() && !this.rasterInfo.getSkippedMipmaps().contains(textureInfo.getName()) || this.rasterInfo.getForcedMipmaps().contains(textureInfo.getName());
                if (!shouldGenerateMipmaps) continue;
                boolean isWriteTexture = textureName.endsWith("_w");
                texture.generateTextureMipmaps(textureName, isWriteTexture);
            }
            textureManager.postTextureOperations(this.rasterProgram);
            if (iterations <= 1) continue;
            GL46C.glPopDebugGroup();
        }
        if (!this.rasterInfo.getBufferBlendStates().isEmpty()) {
            GL46C.glEnable((int)3042);
            GL46C.glBlendFunc((int)770, (int)771);
            GL46C.glBlendEquation((int)32774);
        }
        GL11C.glDepthMask((boolean)true);
        GL46C.glEnable((int)2929);
        for (FramebufferBlit framebufferBlit : this.rasterInfo.getFramebufferBlits()) {
            String sourceFrameBufferName = framebufferBlit.getSourceFrameBuffer();
            FrameBuffer sourceFrameBuffer = sourceFrameBufferName == null || sourceFrameBufferName.isEmpty() ? frameBufferManager.getBoundFrameBuffer() : frameBufferManager.getFrameBuffer(sourceFrameBufferName);
            sourceFrameBuffer.blitToFrameBuffer(framebufferBlit);
        }
        if (this.rasterInfo.getFlush()) {
            GL46C.glFlush();
        }
        GL46C.glPopDebugGroup();
    }

    @Override
    public void destroy() {
        GL46C.glDeleteProgram((int)this.rasterProgram.getProgramID());
    }

    public Program getRasterProgram() {
        return this.rasterProgram;
    }

    public Map<String, Integer> getActiveDrawBuffers() {
        return this.activeDrawBuffers;
    }

    public int[] getColorAttachmentBuffer() {
        return this.colorAttachmentBuffer;
    }
}

