/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.renderpass.passes;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.renderpass.ComputeRenderPassInfo;
import graphics.continuum.data.renderpass.FramebufferBlit;
import graphics.continuum.data.texture.TextureInfo;
import graphics.continuum.renderer.framebuffer.FrameBuffer;
import graphics.continuum.renderer.framebuffer.FrameBufferManager;
import graphics.continuum.renderer.renderpass.RenderPass;
import graphics.continuum.renderer.renderpass.program.Program;
import graphics.continuum.renderer.shaderstorage.ShaderStorageManager;
import graphics.continuum.renderer.shaderstorage.ShaderStorageObject;
import graphics.continuum.renderer.texture.TextureBase;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.renderer.uniform.UniformManager;
import graphics.continuum.tracking.TrackedResource;
import graphics.continuum.tracking.TrackedResources;
import org.lwjgl.opengl.GL43C;

public class ComputeRenderPass
extends RenderPass {
    private final Program computeProgram;
    private final ComputeRenderPassInfo computeInfo;
    private int dispatchGroupsX;
    private int dispatchGroupsY;
    private int dispatchGroupsZ;

    public ComputeRenderPass(ComputeRenderPassInfo renderPassInfo) throws IllegalStateException {
        super(renderPassInfo);
        this.computeInfo = renderPassInfo;
        FocalEngineCore modInstance = FocalEngineCore.getInstance();
        renderPassInfo.getOutputImages().forEach(imageName -> {
            if (!modInstance.getTextureManager().hasTexture((String)imageName)) {
                throw new IllegalStateException("Texture '" + imageName + "' used as compute render pass output image, texture does not exist.");
            }
        });
        renderPassInfo.getInternalTextureSwaps().forEach(textureName -> {
            if (!modInstance.getTextureManager().hasTexture((String)textureName)) {
                throw new IllegalStateException("Internal textures for texture '" + textureName + "' swapped after compute render pass, texture does not exist.");
            }
        });
        renderPassInfo.getFramebufferBlits().forEach(blit -> {
            if (blit.getSourceFrameBuffer() == null) {
                throw new IllegalStateException("Framebuffer blit on compute pass " + renderPassInfo.getName() + " targeting framebuffer " + blit.getTargetFrameBuffer() + " is missing source framebuffer, compute passes need source framebuffers for framebuffer blits!");
            }
            if (blit.getSourceTexture() == null) {
                throw new IllegalStateException("Framebuffer blit on compute pass " + renderPassInfo.getName() + " targeting framebuffer " + blit.getTargetFrameBuffer() + " is missing source texture, compute passes need source textures for framebuffer blits!");
            }
        });
        this.computeProgram = new Program(this.computeInfo, renderPassInfo.getShaders());
        this.computeProgram.use();
        if (renderPassInfo.getDispatchGroupsX() != null) {
            this.dispatchGroupsX = this.computeInfo.getDispatchGroupsX();
            this.dispatchGroupsY = this.computeInfo.getDispatchGroupsY();
            this.dispatchGroupsZ = this.computeInfo.getDispatchGroupsZ();
        } else {
            int[] localGroupSize = new int[3];
            if (this.computeInfo.getLocalGroupX() != null && this.computeInfo.getLocalGroupY() != null && this.computeInfo.getLocalGroupZ() != null) {
                localGroupSize[0] = this.computeInfo.getLocalGroupX();
                localGroupSize[1] = this.computeInfo.getLocalGroupY();
                localGroupSize[2] = this.computeInfo.getLocalGroupZ();
            } else {
                GL43C.glGetProgramiv((int)this.computeProgram.getProgramID(), (int)33383, (int[])localGroupSize);
            }
            this.dispatchGroupsX = (int)Math.ceil((float)renderPassInfo.getDispatchResolutionX().intValue() / (float)localGroupSize[0]);
            this.dispatchGroupsY = (int)Math.ceil((float)renderPassInfo.getDispatchResolutionY().intValue() / (float)localGroupSize[1]);
            this.dispatchGroupsZ = (int)Math.ceil((float)renderPassInfo.getDispatchResolutionZ().intValue() / (float)localGroupSize[2]);
        }
        modInstance.getUniformManager().setupProgramUniforms(this.computeProgram);
        this.computeProgram.release();
    }

    @Override
    public void render() {
        TrackedResource runConditionValue;
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        TrackedResources trackedResources = engineInstance.getTrackedResources();
        String runConditionValueName = this.computeInfo.getRunIfTrueValueName();
        if (runConditionValueName != null && !runConditionValueName.isEmpty() && (runConditionValue = trackedResources.getTrackedUniform(runConditionValueName)).getValue() instanceof Boolean && !((Boolean)runConditionValue.getValue()).booleanValue()) {
            return;
        }
        GL43C.glPushDebugGroup((int)33354, (int)0, (CharSequence)this.getRenderPassInfo().getName());
        int iterations = this.computeInfo.getIterations();
        TextureManager textureManager = engineInstance.getTextureManager();
        FrameBufferManager frameBufferManager = engineInstance.getFrameBufferManager();
        ShaderStorageManager shaderStorageManager = engineInstance.getShaderStorageManager();
        UniformManager uniformManager = engineInstance.getUniformManager();
        this.computeProgram.use();
        this.updateDispatchGroups();
        shaderStorageManager.bindShaderStorageObjects(this.computeProgram);
        textureManager.bindProgramTextureUnits(this.computeProgram);
        this.computeProgram.updateCurrentDispatchSize();
        for (int i = 0; i < iterations; ++i) {
            if (iterations > 1) {
                GL43C.glPushDebugGroup((int)33354, (int)0, (CharSequence)("Iteration " + i));
            }
            this.computeProgram.updateCurrentIteration(i);
            for (int eidx = 0; eidx < this.computeInfo.getSyncExecutions(); ++eidx) {
                this.computeProgram.updateCurrentSyncExecution(eidx);
                uniformManager.updateProgramUniforms(this.computeProgram);
                if (i != 0 || eidx != 0) {
                    textureManager.updateProgramTextureUnits(this.computeProgram);
                }
                if (this.computeInfo.getDispatchIndirectBuffer() != null) {
                    ShaderStorageObject ssbo = shaderStorageManager.getStorageObject(this.computeInfo.getDispatchIndirectBuffer());
                    GL43C.glBindBuffer((int)37102, (int)ssbo.getID());
                    GL43C.glDispatchComputeIndirect((long)0L);
                } else if (this.computeInfo.shouldExecuteMipchain().booleanValue()) {
                    int newDispatchX = (int)Math.ceil((double)this.dispatchGroupsX / Math.pow(2.0, i));
                    int newDispatchY = (int)Math.ceil((double)this.dispatchGroupsY / Math.pow(2.0, i));
                    int newDispatchZ = this.dispatchGroupsZ;
                    GL43C.glDispatchCompute((int)newDispatchX, (int)newDispatchY, (int)newDispatchZ);
                } else {
                    GL43C.glDispatchCompute((int)this.dispatchGroupsX, (int)this.dispatchGroupsY, (int)this.dispatchGroupsZ);
                }
                if (this.computeInfo.getMemoryBarriers().isEmpty()) continue;
                GL43C.glMemoryBarrier((int)this.getActiveMemoryBarriers());
            }
            for (String textureName : this.computeInfo.getOutputImages()) {
                boolean shouldGenerateMipmaps;
                TextureBase texture = textureManager.getTexture(textureName);
                TextureInfo textureInfo = texture.getInfo();
                boolean bl = shouldGenerateMipmaps = textureInfo.shouldAutoGenerateMipmaps() && !this.computeInfo.getSkippedMipmaps().contains(textureInfo.getName()) || this.computeInfo.getForcedMipmaps().contains(textureInfo.getName());
                if (!shouldGenerateMipmaps) continue;
                boolean isWriteTexture = textureName.endsWith("_w");
                texture.generateTextureMipmaps(textureName, isWriteTexture);
            }
            textureManager.postTextureOperations(this.computeProgram);
            if (iterations <= 1) continue;
            GL43C.glPopDebugGroup();
        }
        for (FramebufferBlit blit : this.computeInfo.getFramebufferBlits()) {
            String sourceFrameBufferName = blit.getSourceFrameBuffer();
            FrameBuffer sourceFrameBuffer = frameBufferManager.getFrameBuffer(sourceFrameBufferName);
            sourceFrameBuffer.blitToFrameBuffer(blit);
        }
        if (this.computeInfo.getFlush()) {
            GL43C.glFlush();
        }
        this.computeProgram.release();
        GL43C.glPopDebugGroup();
    }

    private void updateDispatchGroups() {
        if (this.computeInfo.getDispatchGroupsX() == null && this.computeInfo.requiresUpdate()) {
            int[] localGroupSize = new int[3];
            if (this.computeInfo.getLocalGroupX() != null) {
                localGroupSize[0] = this.computeInfo.getLocalGroupX();
                localGroupSize[1] = this.computeInfo.getLocalGroupX();
                localGroupSize[2] = this.computeInfo.getLocalGroupX();
            } else {
                GL43C.glGetProgramiv((int)this.computeProgram.getProgramID(), (int)33383, (int[])localGroupSize);
            }
            this.dispatchGroupsX = (int)Math.ceil((float)this.computeInfo.getDispatchResolutionX().intValue() / (float)localGroupSize[0]);
            this.dispatchGroupsY = (int)Math.ceil((float)this.computeInfo.getDispatchResolutionY().intValue() / (float)localGroupSize[1]);
            this.dispatchGroupsZ = (int)Math.ceil((float)this.computeInfo.getDispatchResolutionZ().intValue() / (float)localGroupSize[2]);
        }
    }

    public Program getComputeProgram() {
        return this.computeProgram;
    }

    @Override
    public void destroy() {
        GL43C.glDeleteProgram((int)this.computeProgram.getProgramID());
    }

    private int getActiveMemoryBarriers() {
        int memoryBarriers = 0;
        for (Integer memoryBarrier : this.computeInfo.getMemoryBarriers()) {
            memoryBarriers |= memoryBarrier.intValue();
        }
        return memoryBarriers;
    }
}

