/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.renderpass;

import graphics.continuum.impl.api.optifine.OptifineShaderParser;
import graphics.continuum.renderer.renderpass.program.Program;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL46C;

public class ShaderLoader {
    public static void compileShaders(Program program, Consumer<Integer> shaderIdCallback) {
        program.getShaders().forEach((shaderType, shaderFilePath) -> {
            int glType = 0;
            switch (shaderType) {
                case VERTEX: {
                    glType = 35633;
                    break;
                }
                case FRAGMENT: {
                    glType = 35632;
                    break;
                }
                case GEOMETRY: {
                    glType = 36313;
                    break;
                }
                case COMPUTE: {
                    glType = 37305;
                    break;
                }
                case RASTER_PACK: {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
            }
            int shader = GL46C.glCreateShader((int)glType);
            GL46C.glObjectLabel((int)33505, (int)shader, (CharSequence)shaderFilePath);
            shaderIdCallback.accept(shader);
            StringBuilder source = OptifineShaderParser.getParsedShaderSource(shaderFilePath);
            GL46C.glShaderSource((int)shader, (CharSequence)source);
            GL46C.glCompileShader((int)shader);
            if (GL46C.glGetShaderi((int)shader, (int)35713) == 0) {
                String errorLog = GL46C.glGetShaderInfoLog((int)shader);
                String errorMsg = String.join((CharSequence)"", "Failed to compile ", shaderFilePath, ".", "\n", errorLog);
                throw new IllegalStateException(errorMsg);
            }
            GL46C.glAttachShader((int)program.getProgramID(), (int)shader);
        });
    }
}

