/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.renderpass;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.data.renderpass.ComputeRenderPassInfo;
import graphics.continuum.data.renderpass.LegacyRenderPassInfo;
import graphics.continuum.data.renderpass.RasterRenderPassInfo;
import graphics.continuum.data.renderpass.RenderPassGroupInfo;
import graphics.continuum.data.renderpass.RenderPassInfo;
import graphics.continuum.renderer.renderpass.RenderPass;
import graphics.continuum.renderer.renderpass.passes.ComputeRenderPass;
import graphics.continuum.renderer.renderpass.passes.LegacyRenderPass;
import graphics.continuum.renderer.renderpass.passes.RasterRenderPass;
import graphics.continuum.renderer.renderpass.passes.RenderPassGroup;
import graphics.continuum.shaderpack.ShaderpackManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class RenderPassManager {
    private final List<RenderPass> RENDER_PASSES = new ArrayList<RenderPass>();
    private final Map<String, LegacyRenderPass> LEGACY_PASSES = new HashMap<String, LegacyRenderPass>();

    public RenderPassManager(ShaderpackManager shaderpackManager) throws InvalidPropertiesFormatException {
        this.init(shaderpackManager);
    }

    public void init(ShaderpackManager shaderpackManager) throws InvalidPropertiesFormatException {
        try {
            List renderPassInfos = (List)JsonUtil.MAPPER.readValue(shaderpackManager.getShaderpackResourceString("/renderpass.json"), (JavaType)JsonUtil.MAPPER.getTypeFactory().constructCollectionType(List.class, RenderPassInfo.class));
            if (renderPassInfos.isEmpty()) {
                throw new InvalidPropertiesFormatException("Could not create render passes");
            }
            renderPassInfos.forEach(this::register);
        }
        catch (MismatchedInputException e) {
            throw new InvalidPropertiesFormatException(String.join((CharSequence)"", "Failed to load 'renderpass.json':\n", e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InvalidPropertiesFormatException("Failed to parse 'renderpass.json'.");
        }
    }

    public void destroy(ShaderpackManager shaderpackManager) {
        this.RENDER_PASSES.forEach(RenderPass::destroy);
        this.RENDER_PASSES.clear();
    }

    public void register(RenderPassInfo renderPassInfo) {
        Logger logger = FocalEngineCore.getInstance().getLogger();
        switch (renderPassInfo.getProgramType()) {
            case RASTER: {
                logger.info("Registering raster render pass {}", (Object)renderPassInfo.getName());
                this.RENDER_PASSES.add(new RasterRenderPass((RasterRenderPassInfo)renderPassInfo));
                break;
            }
            case COMPUTE: {
                logger.info("Registering compute render pass {}", (Object)renderPassInfo.getName());
                this.RENDER_PASSES.add(new ComputeRenderPass((ComputeRenderPassInfo)renderPassInfo));
                break;
            }
            case LEGACY: {
                this.LEGACY_PASSES.put(((LegacyRenderPassInfo)renderPassInfo).getRenderPassName(), new LegacyRenderPass((LegacyRenderPassInfo)renderPassInfo));
                break;
            }
            case GROUP: {
                logger.info("Registering render pass group {}", (Object)renderPassInfo.getName());
                this.RENDER_PASSES.add(new RenderPassGroup((RenderPassGroupInfo)renderPassInfo));
            }
        }
    }

    public LegacyRenderPass getLegacyRenderPass(String optifineProgramName) {
        return this.LEGACY_PASSES.get(optifineProgramName);
    }

    public void renderFrame() {
        for (RenderPass renderPass : this.RENDER_PASSES) {
            renderPass.render();
        }
    }
}

