/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.renderpass;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.renderpass.RenderPassInfo;
import graphics.continuum.renderer.texture.TextureManager;
import java.util.List;
import java.util.Map;

public abstract class RenderPass {
    protected final RenderPassInfo info;

    protected RenderPass(RenderPassInfo info) {
        this.info = info;
    }

    public abstract void render();

    public abstract void destroy();

    public RenderPassInfo getRenderPassInfo() {
        return this.info;
    }

    public void setColorAttachments(List<String> currentDrawBuffer, Map<String, Integer> activeDrawBuffers, int[] colorAttachmentBuffer) {
        TextureManager textureManager = FocalEngineCore.getInstance().getTextureManager();
        int idx = 0;
        for (String textureName : currentDrawBuffer) {
            boolean textureExists = textureManager.hasTexture(textureName);
            if (!textureExists) {
                throw new IllegalStateException("No texture with the name '" + textureName + "' exists.");
            }
            activeDrawBuffers.put(textureName, 36064 + idx);
            colorAttachmentBuffer[idx] = 36064 + idx;
            ++idx;
        }
    }
}

