/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.gl;

import java.util.Arrays;
import org.lwjgl.opengl.GL46C;

public class FocalGlStateManager {
    protected static final int MAX_SAMPLERS = 80;
    public static final int TEXTURE_UNIT_NEVER_BOUND = -1;
    public static final int TEXTURE_UNIT_UNBOUND = 0;
    protected static final int[] textureUnitBindings = new int[80];

    public static void bindTextureUnit(int textureUnit, int textureID) {
        if (textureUnitBindings[textureUnit = FocalGlStateManager.correctTextureUnit(textureUnit)] != textureID) {
            FocalGlStateManager.textureUnitBindings[textureUnit] = textureID;
            GL46C.glBindTextureUnit((int)textureUnit, (int)textureID);
        }
    }

    public static int unbindTextureUnit(int textureUnit) {
        textureUnit = FocalGlStateManager.correctTextureUnit(textureUnit);
        int previouslyBoundTexture = textureUnitBindings[textureUnit];
        FocalGlStateManager.textureUnitBindings[textureUnit] = 0;
        GL46C.glBindTextureUnit((int)textureUnit, (int)0);
        return previouslyBoundTexture;
    }

    public static void updateTextureUnit(int textureUnit, int textureID) {
        if (textureUnitBindings[textureUnit = FocalGlStateManager.correctTextureUnit(textureUnit)] != textureID) {
            FocalGlStateManager.textureUnitBindings[textureUnit] = textureID;
        }
    }

    public static int getTextureUnitBinding(int textureUnit) {
        return textureUnitBindings[FocalGlStateManager.correctTextureUnit(textureUnit)];
    }

    public static void deleteTexture(int texture) {
        GL46C.glDeleteTextures((int)texture);
        for (int textureUnit = 0; textureUnit < textureUnitBindings.length && textureUnitBindings[textureUnit] != -1; ++textureUnit) {
            if (textureUnitBindings[textureUnit] != texture) continue;
            FocalGlStateManager.unbindTextureUnit(textureUnit);
        }
    }

    public static void deleteTextures(int[] textures) {
        GL46C.glDeleteTextures((int[])textures);
        for (int textureUnit = 0; textureUnit < textureUnitBindings.length && textureUnitBindings[textureUnit] != -1; ++textureUnit) {
            for (int texture : textures) {
                if (textureUnitBindings[textureUnit] != texture) continue;
                FocalGlStateManager.unbindTextureUnit(textureUnit);
            }
        }
    }

    private static int correctTextureUnit(int textureUnit) {
        return textureUnit >= 33984 ? textureUnit - 33984 : textureUnit;
    }

    static {
        Arrays.fill(textureUnitBindings, -1);
    }
}

