/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.framebuffer;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.data.framebuffer.FrameBufferInfo;
import graphics.continuum.data.renderpass.RasterRenderPassInfo;
import graphics.continuum.renderer.framebuffer.FrameBuffer;
import graphics.continuum.renderer.renderpass.passes.RasterRenderPass;
import graphics.continuum.renderer.texture.TextureBase;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.shaderpack.ShaderpackManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL46C;

public class FrameBufferManager {
    private String boundFrameBufferName;
    private String defaultFrameBufferName;
    private String legacyDepthBuffer;
    private final Map<String, FrameBuffer> frameBuffers = new HashMap<String, FrameBuffer>();

    public FrameBufferManager(ShaderpackManager shaderpackManager) throws InvalidPropertiesFormatException {
        this.init(shaderpackManager);
    }

    public void register(FrameBufferInfo frameBufferInfo) {
        if (frameBufferInfo.isDefaultFBO()) {
            this.defaultFrameBufferName = frameBufferInfo.getName();
        }
        this.frameBuffers.put(frameBufferInfo.getName(), new FrameBuffer(frameBufferInfo, this));
    }

    public void init(ShaderpackManager shaderpackManager) throws InvalidPropertiesFormatException {
        try {
            List frameBufferInfos = (List)JsonUtil.MAPPER.readValue(shaderpackManager.getShaderpackResourceString("/framebuffers.json"), (JavaType)JsonUtil.MAPPER.getTypeFactory().constructCollectionType(List.class, FrameBufferInfo.class));
            if (frameBufferInfos.isEmpty()) {
                throw new InvalidPropertiesFormatException("No FrameBufferInfos in the framebuffers.json");
            }
            frameBufferInfos.forEach(this::register);
            if (this.defaultFrameBufferName == null) {
                this.defaultFrameBufferName = "";
                FocalEngineCore.getInstance().getLogger().warn("No default FBO set, if no FBO is specified the program will fail.");
            }
        }
        catch (MismatchedInputException e) {
            throw new InvalidPropertiesFormatException(String.join((CharSequence)"", "Failed to load 'framebuffers.json':\n", e.getMessage()));
        }
        catch (IOException e) {
            throw new InvalidPropertiesFormatException("Failed to parse 'framebuffers.json'.");
        }
    }

    public void destroy(ShaderpackManager shaderpackManager) {
        this.frameBuffers.values().forEach(FrameBuffer::destroy);
        this.frameBuffers.clear();
    }

    public void updateRenderPassFrameBufferBinding(RasterRenderPass rasterRenderPass) {
        RasterRenderPassInfo renderPassInfo = (RasterRenderPassInfo)rasterRenderPass.getRenderPassInfo();
        String selectedFrameBufferName = renderPassInfo.getFrameBufferName();
        if (selectedFrameBufferName == null) {
            selectedFrameBufferName = this.defaultFrameBufferName;
        }
        if (!selectedFrameBufferName.equals(this.boundFrameBufferName)) {
            FrameBuffer currentFrameBuffer = this.frameBuffers.get(selectedFrameBufferName);
            currentFrameBuffer.bindAndUpdateViewport();
            this.setBoundFrameBufferName(selectedFrameBufferName);
        }
    }

    public void updateRenderPassRenderTargets(RasterRenderPass rasterRenderPass) {
        this.frameBuffers.get(this.boundFrameBufferName).updateDrawBuffers(rasterRenderPass.getActiveDrawBuffers(), rasterRenderPass.getColorAttachmentBuffer());
    }

    public void resetFrameBufferTargets() {
        String defaultColorAttachmentName;
        FrameBuffer boundFrameBuffer = this.frameBuffers.get(this.boundFrameBufferName);
        if (boundFrameBuffer != null && (defaultColorAttachmentName = boundFrameBuffer.getInfo().getColorAttachment()) != null && !defaultColorAttachmentName.isEmpty()) {
            TextureManager textureManager = FocalEngineCore.getInstance().getTextureManager();
            int textureID = textureManager.getTexture(defaultColorAttachmentName).getTextureID(defaultColorAttachmentName, true);
            GL46C.glNamedFramebufferTexture((int)boundFrameBuffer.getID(), (int)36064, (int)textureID, (int)0);
            GL46C.glNamedFramebufferDrawBuffer((int)boundFrameBuffer.getID(), (int)36064);
        }
    }

    public void updateAll() {
        for (FrameBuffer frameBuffer : this.frameBuffers.values()) {
            frameBuffer.update();
        }
    }

    public void setBoundFrameBufferName(String frameBufferName) {
        this.boundFrameBufferName = frameBufferName;
    }

    public void resetBoundFrameBufferName() {
        this.setBoundFrameBufferName("");
    }

    public FrameBuffer getFrameBuffer(String frameBufferName) {
        return this.frameBuffers.get(frameBufferName);
    }

    public FrameBuffer getDefaultFrameBuffer() {
        return this.frameBuffers.get(this.defaultFrameBufferName);
    }

    public FrameBuffer getBoundFrameBuffer() {
        return this.frameBuffers.get(this.boundFrameBufferName);
    }

    public void setLegacyDepthBuffer(String legacyDepthBuffer) {
        this.legacyDepthBuffer = legacyDepthBuffer;
    }

    public TextureBase getLegacyDepthBuffer() {
        if (this.legacyDepthBuffer == null || this.legacyDepthBuffer.isEmpty()) {
            return null;
        }
        return FocalEngineCore.getInstance().getTextureManager().getTexture(this.legacyDepthBuffer);
    }
}

