/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.renderer.framebuffer;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.framebuffer.FrameBufferInfo;
import graphics.continuum.data.renderpass.FramebufferBlit;
import graphics.continuum.impl.api.game.FocalEngineGameInterface;
import graphics.continuum.renderer.framebuffer.FrameBufferManager;
import graphics.continuum.renderer.texture.TextureBase;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.tracking.TrackedResourceRelation;
import java.util.Map;
import org.lwjgl.opengl.GL46C;

public class FrameBuffer {
    private int FBO_ID;
    private final FrameBufferInfo frameBufferInfo;
    private final TrackedResourceRelation<Integer> width;
    private final TrackedResourceRelation<Integer> height;
    FrameBufferManager frameBufferManager;

    public FrameBuffer(FrameBufferInfo frameBufferInfo, FrameBufferManager frameBufferManager) {
        this.frameBufferInfo = frameBufferInfo;
        this.frameBufferManager = frameBufferManager;
        this.width = frameBufferInfo.getWidth();
        this.height = frameBufferInfo.getHeight();
        this.init();
    }

    private void init() {
        if (this.frameBufferInfo.isMinecraftFBO()) {
            this.FBO_ID = -1;
            return;
        }
        this.FBO_ID = GL46C.glCreateFramebuffers();
        GL46C.glObjectLabel((int)36160, (int)this.FBO_ID, (CharSequence)this.frameBufferInfo.getName());
        GL46C.glNamedFramebufferParameteri((int)this.FBO_ID, (int)37648, (int)this.getWidth());
        GL46C.glNamedFramebufferParameteri((int)this.FBO_ID, (int)37649, (int)this.getHeight());
        this.setFrameBufferAttachments();
    }

    public void updateDrawBuffers(Map<String, Integer> activeDrawBuffers, int[] colorAttachmentBuffer) {
        if (this.frameBufferInfo.isMinecraftFBO()) {
            return;
        }
        this.bind();
        TextureManager textureManager = FocalEngineCore.getInstance().getTextureManager();
        for (Map.Entry<String, Integer> entry : activeDrawBuffers.entrySet()) {
            String textureName = entry.getKey();
            int attachment = entry.getValue();
            int textureID = textureManager.getTexture(textureName).getTextureID(textureName, true);
            GL46C.glNamedFramebufferTexture((int)this.FBO_ID, (int)attachment, (int)textureID, (int)0);
        }
        GL46C.glNamedFramebufferDrawBuffers((int)this.FBO_ID, (int[])colorAttachmentBuffer);
    }

    public void setFrameBufferAttachments() {
        TextureManager textureManager = FocalEngineCore.getInstance().getTextureManager();
        String colorAttachment = this.frameBufferInfo.getColorAttachment();
        String depthAttachment = this.frameBufferInfo.getDepthAttachment();
        if (colorAttachment != null && !colorAttachment.isEmpty()) {
            int textureID = textureManager.getTexture(colorAttachment).getTextureID(colorAttachment, true);
            GL46C.glNamedFramebufferTexture((int)this.FBO_ID, (int)36064, (int)textureID, (int)0);
            GL46C.glNamedFramebufferDrawBuffers((int)this.FBO_ID, (int)36064);
        } else if (colorAttachment != null) {
            int renderBuffer = GL46C.glCreateRenderbuffers();
            GL46C.glObjectLabel((int)36161, (int)renderBuffer, (CharSequence)(this.frameBufferInfo.getName() + " Color RenderBuffer"));
            GL46C.glNamedRenderbufferStorage((int)renderBuffer, (int)32856, (int)this.getWidth(), (int)this.getHeight());
            GL46C.glNamedFramebufferRenderbuffer((int)this.FBO_ID, (int)36064, (int)36161, (int)renderBuffer);
            GL46C.glNamedFramebufferDrawBuffers((int)this.FBO_ID, (int)36064);
        }
        if (depthAttachment != null) {
            boolean isMinecraftDepthBuffer = depthAttachment.equals("minecraftFBODepth");
            TextureBase depthTexture = textureManager.getTexture(depthAttachment);
            int depthTextureID = depthTexture.getTextureID(depthAttachment, true);
            if (!isMinecraftDepthBuffer && !depthAttachment.isEmpty()) {
                int pixelFormat = depthTexture.getInfo().getPixelFormat();
                GL46C.glNamedFramebufferTexture((int)this.FBO_ID, (int)(pixelFormat == 36013 || pixelFormat == 35056 ? 33306 : 36096), (int)depthTextureID, (int)0);
            } else if (isMinecraftDepthBuffer) {
                FocalEngineCore.getInstance().getGameInterface();
                int minecraftFramebufferWidth = FocalEngineGameInterface.getMainRenderTargetWidth();
                FocalEngineCore.getInstance().getGameInterface();
                int minecraftFramebufferHeight = FocalEngineGameInterface.getMainRenderTargetHeight();
                GL46C.glNamedRenderbufferStorage((int)depthTextureID, (int)33190, (int)minecraftFramebufferWidth, (int)minecraftFramebufferHeight);
                GL46C.glNamedFramebufferRenderbuffer((int)this.FBO_ID, (int)36096, (int)36161, (int)depthTextureID);
            } else {
                int renderBuffer = GL46C.glCreateRenderbuffers();
                GL46C.glObjectLabel((int)36161, (int)renderBuffer, (CharSequence)(this.frameBufferInfo.getName() + " Depth RenderBuffer"));
                GL46C.glNamedRenderbufferStorage((int)renderBuffer, (int)36013, (int)this.getWidth(), (int)this.getHeight());
                GL46C.glNamedFramebufferRenderbuffer((int)this.FBO_ID, (int)33306, (int)36161, (int)renderBuffer);
            }
        }
        if (this.frameBufferInfo.getLegacyDepthAttachment() != null) {
            this.frameBufferManager.setLegacyDepthBuffer(this.frameBufferInfo.getLegacyDepthAttachment());
        }
    }

    public void update() {
        if (this.frameBufferInfo.isMinecraftFBO()) {
            if (this.FBO_ID == -1) {
                this.FBO_ID = FocalEngineGameInterface.getMainRenderTargetID();
                GL46C.glObjectLabel((int)36160, (int)this.FBO_ID, (CharSequence)"Minecraft framebuffer");
            }
            return;
        }
        if (this.width.requiresUpdate() || this.height.requiresUpdate()) {
            if (this.FBO_ID != 0) {
                GL46C.glDeleteFramebuffers((int)this.FBO_ID);
            }
            this.init();
            return;
        }
        this.setFrameBufferAttachments();
    }

    public void bind() {
        GL46C.glBindFramebuffer((int)36160, (int)this.FBO_ID);
    }

    public void bindAndUpdateViewport() {
        this.bind();
        this.updateViewport();
    }

    public void updateViewport() {
        GL46C.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
    }

    public void blitToFrameBuffer(FramebufferBlit blit) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        TextureManager textureManager = engineInstance.getTextureManager();
        if (blit.getSourceTexture() != null && !blit.getSourceTexture().isEmpty()) {
            int sourceTextureID = textureManager.getTexture(blit.getSourceTexture()).getTextureID(blit.getSourceTexture(), false);
            GL46C.glNamedFramebufferTexture((int)this.FBO_ID, (int)36064, (int)sourceTextureID, (int)0);
            GL46C.glNamedFramebufferDrawBuffers((int)this.FBO_ID, (int)36064);
        }
        FrameBuffer destinationFrameBuffer = engineInstance.getFrameBufferManager().getFrameBuffer(blit.getTargetFrameBuffer());
        if (blit.getTargetTexture() != null && !blit.getTargetTexture().isEmpty()) {
            int targetTextureID = textureManager.getTexture(blit.getTargetTexture()).getTextureID(blit.getTargetTexture(), true);
            GL46C.glNamedFramebufferTexture((int)destinationFrameBuffer.getID(), (int)36064, (int)targetTextureID, (int)0);
            GL46C.glNamedFramebufferDrawBuffers((int)destinationFrameBuffer.getID(), (int)36064);
        }
        GL46C.glBlitNamedFramebuffer((int)this.FBO_ID, (int)destinationFrameBuffer.getID(), (int)0, (int)0, (int)this.width.getValue(), (int)this.height.getValue(), (int)0, (int)0, (int)destinationFrameBuffer.getWidth(), (int)destinationFrameBuffer.getHeight(), (int)16384, (int)blit.getFilter());
    }

    public int getWidth() {
        float downscaleFactor = this.frameBufferInfo.getDownscaleFactor().floatValue();
        return downscaleFactor > 0.0f ? (int)Math.ceil((float)this.width.getValue().intValue() / downscaleFactor) : this.width.getValue();
    }

    public int getHeight() {
        float downscaleFactor = this.frameBufferInfo.getDownscaleFactor().floatValue();
        return downscaleFactor > 0.0f ? (int)Math.ceil((float)this.height.getValue().intValue() / downscaleFactor) : this.height.getValue();
    }

    public void destroy() {
        if (!this.frameBufferInfo.isMinecraftFBO()) {
            GL46C.glDeleteFramebuffers((int)this.FBO_ID);
        }
    }

    public int getID() {
        return this.FBO_ID;
    }

    public FrameBufferInfo getInfo() {
        return this.frameBufferInfo;
    }
}

