/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.product;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProduct;
import graphics.continuum.data.copp.ContinuumProductItem;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.data.copp.models.COPPDownload;
import graphics.continuum.impl.api.game.FocalEngineGameInterface;
import graphics.continuum.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProductManager {
    private final Map<ContinuumProductType, ContinuumProduct> productList = new HashMap<ContinuumProductType, ContinuumProduct>();
    private ContinuumProductType selectedProduct;

    public Map<ContinuumProductType, ContinuumProduct> getProductList() {
        return this.productList;
    }

    public ContinuumProduct getProduct(ContinuumProductType productType) {
        return this.productList.get((Object)productType);
    }

    public void addProduct(ContinuumProduct product) {
        this.productList.put(product.getProductType(), product);
    }

    public void addProducts(List<ContinuumProduct> products) {
        products.forEach(product -> this.productList.put(product.getProductType(), (ContinuumProduct)product));
    }

    public void clearProducts() {
        this.selectProduct(null);
        this.productList.clear();
    }

    public ContinuumProduct getSelectedProduct() {
        return this.getProduct(this.selectedProduct);
    }

    public ContinuumProductType getSelectedProductType() {
        return this.selectedProduct;
    }

    public void selectProduct(ContinuumProductType productType) {
        this.selectedProduct = productType;
    }

    public void sortDownloads(List<COPPDownload> downloads) {
        this.clearProducts();
        for (COPPDownload download : downloads) {
            ContinuumProductType productType = ContinuumProductType.getTypeOf(download.productFamily);
            if (productType == null) continue;
            if (!this.productList.containsKey((Object)productType)) {
                this.productList.put(productType, new ContinuumProduct(productType));
            }
            ContinuumProductItem productItem = new ContinuumProductItem(this.productList.get((Object)productType), download);
            this.productList.get((Object)productType).addItem(productItem);
        }
        FocalEngineCore.getInstance().getDownloadManager().createDownloadBinsForProductsIfNoneExist(new ArrayList<ContinuumProductType>(this.productList.keySet()));
    }

    public boolean isProductItemInstalled(ContinuumProductItem productItem) {
        ContinuumProductType productType = productItem.product.getProductType();
        return new File(productType.getInstallPath(productItem)).exists();
    }

    public Map<ContinuumProductType, List<ContinuumProductItem>> getInstalledItems() {
        HashMap<ContinuumProductType, List<ContinuumProductItem>> installedItems = new HashMap<ContinuumProductType, List<ContinuumProductItem>>();
        for (Map.Entry<ContinuumProductType, ContinuumProduct> entry : this.productList.entrySet()) {
            ContinuumProductType productType = entry.getKey();
            ContinuumProduct product = entry.getValue();
            LinkedList<ContinuumProductItem> itemList = new LinkedList<ContinuumProductItem>();
            for (ContinuumProductItem item : product.getAccessibleItems()) {
                if (!this.isProductItemInstalled(item)) continue;
                itemList.add(item);
            }
            installedItems.put(productType, itemList);
        }
        return installedItems;
    }

    public void checkForUpdatesAndNotify() {
        Map<ContinuumProductType, List<ContinuumProductItem>> installedItems = this.getInstalledItems();
        HashMap latestAvailableItems = new HashMap();
        HashMap latestInstalledItems = new HashMap();
        ArrayList<ContinuumProductItem> tempSortedItems = new ArrayList<ContinuumProductItem>();
        for (ContinuumProductType productType : this.productList.keySet()) {
            tempSortedItems.clear();
            tempSortedItems.addAll(this.productList.get((Object)productType).getAccessibleItems());
            tempSortedItems.sort(Comparator.reverseOrder());
            if (tempSortedItems.size() > 0) {
                latestAvailableItems.put(productType, tempSortedItems.get(0));
            }
            tempSortedItems.clear();
            tempSortedItems.addAll((Collection)installedItems.get((Object)productType));
            tempSortedItems.sort(Comparator.reverseOrder());
            if (tempSortedItems.size() <= 0) continue;
            latestInstalledItems.put(productType, tempSortedItems.get(0));
        }
        ArrayList<Pair<ContinuumProductItem, ContinuumProductItem>> itemsToUpdate = new ArrayList<Pair<ContinuumProductItem, ContinuumProductItem>>();
        for (Map.Entry entry : latestAvailableItems.entrySet()) {
            ContinuumProductType productType = (ContinuumProductType)((Object)entry.getKey());
            ContinuumProductItem productItem = (ContinuumProductItem)entry.getValue();
            ContinuumProductItem installedItem = (ContinuumProductItem)latestInstalledItems.get((Object)productType);
            if (installedItem == null || productItem.compareTo(installedItem) <= 0) continue;
            itemsToUpdate.add(new Pair<ContinuumProductItem, ContinuumProductItem>(installedItem, productItem));
        }
        for (Pair pair : itemsToUpdate) {
            FocalEngineGameInterface.sendToast("Update Available", String.format("%1$s %2$s -> %3$s", ((ContinuumProductItem)pair.getA()).productName, ((ContinuumProductItem)pair.getA()).displayedVersionID, ((ContinuumProductItem)pair.getB()).product.getProductType().getTruncatedDisplayVersionID((ContinuumProductItem)pair.getB())));
        }
    }
}

