/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.product;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProductItem;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.network.ContinuumAccount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DownloadManager {
    private final Map<ContinuumProductType, List<DownloadRequest>> activeDownloads = new HashMap<ContinuumProductType, List<DownloadRequest>>();

    public void downloadItem(ContinuumProductItem item) {
        ContinuumAccount continuumAccount = FocalEngineCore.getInstance().getAccount();
        ContinuumProductType productType = item.product.getProductType();
        new Thread(() -> continuumAccount.downloadProduct(item, productType.getDownloadPath(item), productType.getInstallPath(item)), "Downloader Thread").start();
    }

    public void createDownloadBinsForProducts(List<ContinuumProductType> productTypes) {
        productTypes.forEach(productType -> {
            List cfr_ignored_0 = this.activeDownloads.put((ContinuumProductType)((Object)productType), new ArrayList());
        });
    }

    public void createDownloadBinsForProductsIfNoneExist(List<ContinuumProductType> productTypes) {
        productTypes.forEach(productType -> {
            if (!this.activeDownloads.containsKey(productType)) {
                this.activeDownloads.put((ContinuumProductType)((Object)productType), new ArrayList());
            }
        });
    }

    public void destroyAllDownloadBins() {
        this.activeDownloads.values().forEach(List::clear);
        this.activeDownloads.clear();
    }

    public void addDownloadToBin(ContinuumProductType bin, DownloadRequest downloadRequest) {
        this.activeDownloads.get((Object)bin).add(downloadRequest);
    }

    public void removeDownloadFromBin(ContinuumProductType bin, DownloadRequest downloadRequest) {
        this.activeDownloads.get((Object)bin).remove(downloadRequest);
    }

    public boolean hasItemDownload(ContinuumProductItem item) {
        for (DownloadRequest downloadRequest : this.activeDownloads.get((Object)item.product.getProductType())) {
            if (!downloadRequest.getProduct().equals(item)) continue;
            return true;
        }
        return false;
    }

    public Map<ContinuumProductType, List<DownloadRequest>> getAllDownloads() {
        return this.activeDownloads;
    }

    public List<DownloadRequest> getDownloadsForProduct(ContinuumProductType productType) {
        return this.activeDownloads.get((Object)productType);
    }

    public static enum DownloadState {
        DOWNLOADING,
        FINISHED,
        CANCELLED,
        FAILED;

    }

    public static class DownloadRequest {
        private final ContinuumProductItem product;
        private DownloadState state;
        private long downloadSize = 0L;
        private long fileSize = -1L;
        private boolean downloadFailed = false;
        private String reason = "";

        public DownloadRequest(ContinuumProductItem product) {
            this.product = product;
            this.state = DownloadState.DOWNLOADING;
        }

        public ContinuumProductItem getProduct() {
            return this.product;
        }

        public void restart() {
            this.state = DownloadState.DOWNLOADING;
        }

        public void cancel() {
            this.state = DownloadState.CANCELLED;
        }

        public boolean wasCancelled() {
            return this.state == DownloadState.CANCELLED;
        }

        public void setSize(long size) {
            this.fileSize = size;
        }

        public void increment(int read) {
            this.downloadSize += (long)read;
        }

        public float getProgress() {
            return (float)((double)this.downloadSize / (double)this.fileSize);
        }

        public boolean hasFinished() {
            return this.downloadSize >= this.fileSize;
        }

        public boolean hasStarted() {
            return this.downloadSize >= 0L;
        }

        public boolean hasFailed() {
            return this.downloadFailed;
        }

        public void signalFailed(String reason) {
            this.state = DownloadState.FAILED;
            this.downloadFailed = true;
            this.reason = reason;
        }

        public void signalFinished() {
            this.state = DownloadState.FINISHED;
        }

        public String getFailureReason() {
            return this.reason;
        }

        public DownloadState getState() {
            return this.state;
        }
    }
}

