/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.network;

import graphics.continuum.data.JsonUtil;
import graphics.continuum.network.ParameterType;
import graphics.continuum.network.RestClient;
import graphics.continuum.network.RestResponse;
import graphics.continuum.util.Pair;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;

public class RestRequest {
    private String endpoint;
    private RestClient restClient;
    private String accessToken;
    private Object bodyObject;
    private List<Pair<String, String>> queryString;
    private List<Pair<String, String>> urlSegment;

    public RestRequest(RestClient restClient, String endpoint, String accessToken) {
        this.setRestClient(restClient);
        this.setEndpoint(endpoint);
        this.setAccessToken(accessToken);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public Object getBodyObject() {
        return this.bodyObject;
    }

    private void setBodyObject(Object bodyObject) {
        this.bodyObject = bodyObject;
    }

    public List<Pair<String, String>> getQueryString() {
        return this.queryString;
    }

    public void setQueryString(List<Pair<String, String>> queryString) {
        this.queryString = queryString;
    }

    public List<Pair<String, String>> getUrlSegment() {
        return this.urlSegment;
    }

    public void setUrlSegment(List<Pair<String, String>> urlSegment) {
        this.urlSegment = urlSegment;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    private void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    private void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    private void appendQueryString(StringBuilder stringBuilder, String key, String value) throws UnsupportedEncodingException {
        if (stringBuilder.length() > 0) {
            stringBuilder.append("&");
        }
        stringBuilder.append(key);
        stringBuilder.append("=");
        stringBuilder.append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
    }

    private void appendQueryString(StringBuilder stringBuilder, Pair<String, String> keyValuePair) throws UnsupportedEncodingException {
        this.appendQueryString(stringBuilder, keyValuePair.getKey(), keyValuePair.getValue());
    }

    public RestRequest addParameter(String key, String value, ParameterType parameterType) {
        switch (parameterType) {
            case URL_SEGMENT: {
                return this.addUrlSegment(key, value);
            }
            case QUERY_STRING: {
                return this.addQueryString(key, value);
            }
        }
        throw new IllegalArgumentException("Invalid parameter type specific");
    }

    public RestRequest addParameter(Pair<String, String> keyValuePair) {
        return this.addParameter(keyValuePair.getKey(), keyValuePair.getValue(), ParameterType.QUERY_STRING);
    }

    public RestRequest addUrlSegment(String key, String value) {
        if (this.getUrlSegment() == null) {
            this.setUrlSegment(new ArrayList<Pair<String, String>>());
        }
        this.getUrlSegment().add(new Pair<String, String>(key, value));
        return this;
    }

    public RestRequest addQueryString(String key, String value) {
        if (this.getQueryString() == null) {
            this.setQueryString(new ArrayList<Pair<String, String>>());
        }
        this.getQueryString().add(new Pair<String, String>(key, value));
        return this;
    }

    public RestRequest setBody(Object obj) {
        this.setBodyObject(obj);
        return this;
    }

    public RestResponse executeGet() throws IOException, URISyntaxException {
        return this.sendInternal("GET");
    }

    public RestResponse executePost() throws IOException, URISyntaxException {
        return this.sendInternal("POST");
    }

    private HttpURLConnection prepareRequest(String httpMethod) throws IOException, URISyntaxException {
        StringBuilder queryStringBuilder = new StringBuilder();
        RestClient restClient = this.getRestClient();
        if (this.getQueryString() != null) {
            for (Pair<String, String> pair : this.getQueryString()) {
                this.appendQueryString(queryStringBuilder, pair);
            }
        }
        for (Pair<String, String> pair : this.getRestClient().getDefaultQueryString()) {
            this.appendQueryString(queryStringBuilder, pair);
        }
        String endpoint = this.getEndpoint();
        if (this.getUrlSegment() != null) {
            for (Pair<String, String> pair : this.getUrlSegment()) {
                endpoint = endpoint.replace("{" + pair.getKey() + "}", pair.getValue());
            }
        }
        URIBuilder uRIBuilder = new URIBuilder();
        uRIBuilder.setHost(this.getRestClient().getBaseUrl().toString());
        uRIBuilder.setPath(endpoint);
        uRIBuilder.setScheme("https");
        if (queryStringBuilder.length() > 0) {
            uRIBuilder.setCustomQuery(queryStringBuilder.toString());
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRIBuilder.build().toURL().openConnection();
        httpURLConnection.setRequestMethod(httpMethod.toString());
        httpURLConnection.setRequestProperty("User-Agent", "Minecraft_Forge-FocalEngine");
        if (restClient.getAccessToken() != null) {
            httpURLConnection.setRequestProperty("Authorization", "Bearer " + (restClient.requiresBase64Encode() ? Base64.getEncoder().encodeToString(restClient.getAccessToken().getBytes()) : restClient.getAccessToken()));
        }
        if (restClient.getOAuthToken() != null) {
            httpURLConnection.setRequestProperty("Authorization", "OAuth " + (restClient.requiresBase64Encode() ? Base64.getEncoder().encodeToString(restClient.getOAuthToken().getBytes()) : restClient.getOAuthToken()));
        }
        if (restClient.getLoginToken() != null) {
            httpURLConnection.setRequestProperty("Authorization", "LToken " + (restClient.requiresBase64Encode() ? Base64.getEncoder().encodeToString(restClient.getLoginToken().getBytes()) : restClient.getLoginToken()));
        }
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    private RestResponse sendInternal(String httpMethod) throws IOException, URISyntaxException {
        HttpURLConnection httpURLConnection = this.prepareRequest(httpMethod);
        if (httpMethod.equals("POST")) {
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setRequestProperty("Accept", "*/*");
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                JsonUtil.MAPPER.writeValue(outputStream, this.getBodyObject());
                outputStream.flush();
            }
        }
        int unused = httpURLConnection.getResponseCode();
        return new RestResponse(httpURLConnection);
    }
}

