/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.network;

import graphics.continuum.network.RestRequest;
import graphics.continuum.util.Pair;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class RestClient {
    private int maxRetryCount;
    private String accessToken;
    private String oAuthToken;
    private String loginToken;
    private boolean requiresBase64Encode;
    private List<Pair<String, String>> defaultQueryString;
    private URI baseUrl;

    public RestClient(URI baseUrl) {
        this.setBaseUrl(baseUrl);
        this.setDefaultQueryString(new ArrayList<Pair<String, String>>());
        this.setMaxRetryCount(0);
    }

    public void setAccessToken(String token) {
        this.accessToken = token;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) throws IllegalArgumentException {
        if (maxRetryCount < 0) {
            throw new IllegalArgumentException("Value cannot be less than 0 (zero).");
        }
        this.maxRetryCount = maxRetryCount;
    }

    public String getOAuthToken() {
        return this.oAuthToken;
    }

    public void setOAuthToken(String oAuthToken) {
        this.oAuthToken = oAuthToken;
    }

    public String getLoginToken() {
        return this.loginToken;
    }

    public void setLoginToken(String privateToken) {
        this.loginToken = privateToken;
    }

    public boolean requiresBase64Encode() {
        return this.requiresBase64Encode;
    }

    public void setRequiresBase64Encode(boolean requiresBase64Encode) {
        this.requiresBase64Encode = requiresBase64Encode;
    }

    public List<Pair<String, String>> getDefaultQueryString() {
        return this.defaultQueryString;
    }

    public void setDefaultQueryString(List<Pair<String, String>> defaultQueryString) {
        this.defaultQueryString = defaultQueryString;
    }

    public URI getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URI baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void addDefaultQueryString(String key, String value) {
        this.getDefaultQueryString().add(new Pair<String, String>(key, value));
    }

    public RestRequest create(String endpoint) {
        return new RestRequest(this, endpoint, this.getAccessToken());
    }
}

