/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.network;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.JsonUtil;
import graphics.continuum.data.copp.ContinuumProductItem;
import graphics.continuum.data.copp.models.COPPDownload;
import graphics.continuum.data.copp.models.requests.COPPLoginRequest;
import graphics.continuum.data.copp.models.responses.impl.COPPLoginResponse;
import graphics.continuum.data.copp.models.responses.impl.COPPUserResponse;
import graphics.continuum.impl.api.game.FocalEngineGameInterface;
import graphics.continuum.network.RestClient;
import graphics.continuum.network.RestRequest;
import graphics.continuum.network.RestResponse;
import graphics.continuum.product.DownloadManager;
import graphics.continuum.util.Pair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContinuumAccount {
    private static final String BASE_URL = "checkout.continuum.graphics";
    private static final String CLIENT_ID = "1";
    private static final String SCOPE = "client.continuumopti.all";
    private static final Path ACCOUNT_JSON_PATH = Paths.get(".", "config", "focal-engine", "account.json");
    @JsonProperty(value="siteUsername", required=true)
    private String username;
    @JsonIgnore
    private String usernameWithPrefix;
    @JsonIgnore
    private String minecraftUUID;
    @JsonProperty(value="loginToken", required=true)
    private String loginToken;
    @JsonProperty(value="accessToken", required=true)
    private String accessToken;
    @JsonProperty(value="accessTokenExpiryDate", required=true)
    private Date accessTokenExpiryDate;
    @JsonProperty(value="downloads", required=true)
    private List<COPPDownload> downloads;
    @JsonIgnore
    private final byte[] encryptionKey;
    @JsonProperty(value="adhocAccount")
    private boolean adhocAccount;

    @JsonCreator
    public ContinuumAccount(@JsonProperty(value="siteUsername", required=true) String username, @JsonProperty(value="loginToken", required=true) String loginToken, @JsonProperty(value="accessToken", required=true) String accessToken, @JsonProperty(value="accessTokenExpiryDate", required=true) Date accessTokenExpiryDate, @JsonProperty(value="downloads", required=true) List<COPPDownload> downloads, @JsonProperty(value="adhocAccount") Boolean adhocAccount) {
        this.adhocAccount = adhocAccount != null ? adhocAccount : loginToken == null;
        this.username = username;
        this.usernameWithPrefix = this.adhocAccount ? "mc:" + username : username;
        this.minecraftUUID = FocalEngineGameInterface.getUuid().replace("-", "");
        this.loginToken = loginToken;
        this.accessToken = accessToken;
        this.accessTokenExpiryDate = accessTokenExpiryDate;
        this.downloads = downloads;
        this.encryptionKey = ContinuumAccount.computeEncryptionKey(this.usernameWithPrefix.toLowerCase(), this.minecraftUUID);
    }

    public static Pair<ContinuumAccount, COPPLoginResponse> login(String username, String password) throws IOException, URISyntaxException {
        Logger logger = FocalEngineCore.getInstance().getLogger();
        logger.info("Attempting to log user " + username + " in...");
        RestClient restClient = new RestClient(URI.create(BASE_URL));
        String UUID2 = FocalEngineGameInterface.getUuid();
        COPPLoginRequest coppLoginRequest = new COPPLoginRequest(CLIENT_ID, "code-01", username, password, SCOPE, UUID2);
        RestRequest restRequest = restClient.create("/api/v1/account/login");
        restRequest.setBody(coppLoginRequest);
        RestResponse restResponse = restRequest.executePost();
        String content = restResponse.getStringContent();
        COPPLoginResponse coppLoginResponse = JsonUtil.MAPPER.readValue(content, COPPLoginResponse.class);
        if (!coppLoginResponse.isSuccess()) {
            return new Pair<Object, COPPLoginResponse>(null, coppLoginResponse);
        }
        Calendar expiresIn = Calendar.getInstance();
        expiresIn.add(13, coppLoginResponse.getAccessTokenExpiresIn());
        COPPUserResponse userResponse = ContinuumAccount.getUserData(coppLoginResponse.getAccessToken());
        ContinuumAccount account = new ContinuumAccount(userResponse.getUsername(), coppLoginResponse.getLoginToken(), coppLoginResponse.getAccessToken(), expiresIn.getTime(), null, false);
        if (expiresIn.getTime().compareTo(new Date()) <= 0) {
            account.refreshAccessToken();
        }
        account.refreshDownloadsList(false);
        if (coppLoginResponse.isSuccess()) {
            logger.info("Successfully logged user " + username + " in!");
        } else {
            logger.error("Failed to log user " + username + "in:\n" + coppLoginResponse.getMessage());
        }
        return new Pair<ContinuumAccount, COPPLoginResponse>(account, coppLoginResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ContinuumAccount loadAccountJson() {
        Logger logger = FocalEngineCore.getInstance().getLogger();
        if (!Files.exists(ACCOUNT_JSON_PATH, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(ACCOUNT_JSON_PATH);){
            ContinuumAccount continuumAccount = JsonUtil.MAPPER.readValue((Reader)reader, ContinuumAccount.class);
            return continuumAccount;
        }
        catch (IOException e) {
            logger.error("Failed to read account json: ", (Throwable)e);
            return null;
        }
    }

    public static ContinuumAccount createAdhocAccount() {
        Calendar fakeExpiryDate = Calendar.getInstance();
        fakeExpiryDate.add(1, 100);
        ContinuumAccount freeAccount = new ContinuumAccount(FocalEngineGameInterface.getUsername(), null, null, fakeExpiryDate.getTime(), null, true);
        boolean refreshSuccessful = freeAccount.refreshDownloadsList(true);
        if (refreshSuccessful) {
            FocalEngineCore.getInstance().getProductManager().sortDownloads(freeAccount.getDownloads());
        }
        return freeAccount;
    }

    public void saveAccountJson() throws IOException {
        Logger logger = FocalEngineCore.getInstance().getLogger();
        logger.info("Saving account...");
        if (!Files.exists(ACCOUNT_JSON_PATH.getParent(), new LinkOption[0])) {
            Files.createDirectories(ACCOUNT_JSON_PATH.getParent(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(ACCOUNT_JSON_PATH, new OpenOption[0]);){
            JsonUtil.MAPPER.writeValue(writer, (Object)this);
            logger.info("Successfully saved account!");
        }
        catch (IOException e) {
            logger.error("Failed to write account json: ", (Throwable)e);
        }
    }

    public void deleteAccountJson() {
        Logger logger = FocalEngineCore.getInstance().getLogger();
        logger.info("Deleting account...");
        File cancelledFile = new File(ACCOUNT_JSON_PATH.toString());
        if (cancelledFile.delete()) {
            logger.info("Successfully deleted account!");
        } else {
            logger.error("Failed to delete account!");
        }
    }

    public static COPPUserResponse getUserData(String accessToken) throws IOException, URISyntaxException {
        RestClient restClient = new RestClient(URI.create(BASE_URL));
        restClient.setAccessToken(accessToken);
        RestRequest restRequest = restClient.create("/api/v1/account/me");
        RestResponse restResponse = restRequest.executeGet();
        String content = restResponse.getStringContent();
        return JsonUtil.MAPPER.readValue(content, COPPUserResponse.class);
    }

    public boolean refreshAccessToken() {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        engineInstance.getLogger().info("Attempting to refresh access token.");
        RestClient restClient = new RestClient(URI.create(BASE_URL));
        restClient.setLoginToken(this.loginToken);
        restClient.setRequiresBase64Encode(true);
        RestRequest restRequest = restClient.create("/api/v1/account/login/refresh");
        try {
            RestResponse restResponse = restRequest.executePost();
            String content = restResponse.getStringContent();
            COPPLoginResponse coppLoginResponse = JsonUtil.MAPPER.readValue(content, COPPLoginResponse.class);
            if (coppLoginResponse.isSuccess()) {
                this.accessToken = coppLoginResponse.getAccessToken();
                Calendar expireDate = Calendar.getInstance();
                expireDate.add(13, coppLoginResponse.getAccessTokenExpiresIn());
                this.accessTokenExpiryDate = expireDate.getTime();
                this.saveAccountJson();
                engineInstance.getLogger().info("Successfully refreshed access token!");
                return true;
            }
            engineInstance.getLogger().error("Failed to refresh access token:\n" + coppLoginResponse.getMessage());
            engineInstance.getLogger().error("Logging user " + this.username + " out, please try and log in again.");
            FocalEngineCore.getInstance().forgetAccount();
            return false;
        }
        catch (IOException | URISyntaxException e) {
            engineInstance.getLogger().error("Failed to refresh access token:", (Throwable)e);
            engineInstance.getLogger().error("Logging user " + this.username + " out, please try and log in again.");
            FocalEngineCore.getInstance().forgetAccount();
            return false;
        }
    }

    public boolean refreshDownloadsList(boolean alreadyRefreshedAccessToken) {
        try {
            FocalEngineCore.getInstance().getLogger().info("Grabbing latest product downloads...");
            this.downloads = ContinuumAccount.requestDownloadInfo(this.accessToken);
            this.saveAccountJson();
            FocalEngineCore.getInstance().getLogger().info("Successfully grabbed latest product downloads!");
            return true;
        }
        catch (IOException | URISyntaxException e) {
            if (e.getLocalizedMessage().contains("401")) {
                FocalEngineCore.getInstance().getLogger().warn("Encountered a 401 error, attempting to refresh access token and trying again.");
                if (!alreadyRefreshedAccessToken && this.refreshAccessToken()) {
                    return this.refreshDownloadsList(true);
                }
                FocalEngineCore.getInstance().getLogger().error("Access token refresh failed, aborting.");
                return false;
            }
            FocalEngineCore.getInstance().getLogger().error("Failed to grab latest product downloads from the site:", (Throwable)e);
            return false;
        }
    }

    public static List<COPPDownload> requestDownloadInfo(String accessToken) throws IOException, URISyntaxException {
        RestClient restClient = new RestClient(URI.create(BASE_URL));
        restClient.setAccessToken(accessToken);
        RestRequest restRequest = restClient.create("/downloads/available_downloads");
        RestResponse restResponse = restRequest.executeGet();
        String content = restResponse.getStringContent();
        return (List)JsonUtil.MAPPER.readValue(content, (JavaType)JsonUtil.MAPPER.getTypeFactory().constructCollectionType(List.class, COPPDownload.class));
    }

    public void downloadProduct(ContinuumProductItem product, String downloadName, String installName) {
        DownloadManager.DownloadRequest downloadRequest = new DownloadManager.DownloadRequest(product);
        FocalEngineCore.getInstance().getDownloadManager().addDownloadToBin(product.product.getProductType(), downloadRequest);
        RestClient restClient = new RestClient(URI.create(BASE_URL));
        restClient.setAccessToken(this.accessToken);
        RestRequest restRequest = restClient.create("/downloads/get_download/{downloadId}");
        restRequest.addUrlSegment("downloadId", Integer.toString(product.downloadID));
        restRequest.addQueryString("uuid", this.minecraftUUID);
        restRequest.addQueryString("username", this.usernameWithPrefix);
        try {
            RestResponse restResponse = restRequest.executeGet();
            restResponse.writeToFile(downloadName, installName, downloadRequest);
        }
        catch (IOException | URISyntaxException e) {
            downloadRequest.signalFailed(e.getLocalizedMessage());
            FocalEngineCore.getInstance().getLogger().error(installName + " failed to download: ", (Throwable)e);
        }
    }

    public static byte[] computeEncryptionKey(String username, String uuid) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(username.getBytes(StandardCharsets.UTF_8));
            md.update(uuid.getBytes(StandardCharsets.UTF_8));
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getMinecraftUUID() {
        return this.minecraftUUID;
    }

    public String getLoginToken() {
        return this.loginToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Date getAccessTokenExpiryDate() {
        return this.accessTokenExpiryDate;
    }

    public List<COPPDownload> getDownloads() {
        return this.downloads;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public boolean isAdhocAccount() {
        return this.adhocAccount;
    }

    public void setAdhocAccount(boolean adhocAccount) {
        this.adhocAccount = adhocAccount;
    }
}

