/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.loader.core;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    private static final Logger LOGGER = LogManager.getLogger((String)"FocalEngine");

    public static String findAndCheckMcVersion() {
        try {
            String version = Utils.getVersionFromJson();
            if (version == null) {
                version = Utils.getVersionFromFabric();
            }
            return Utils.checkSupportedVersion(version);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String getVersionFromJson() throws IOException {
        try (InputStream versionJson = Utils.class.getClassLoader().getResourceAsStream("/version.json");){
            if (versionJson == null) {
                String string = null;
                return string;
            }
            JsonObject version = new JsonParser().parse((Reader)new InputStreamReader(new BufferedInputStream(versionJson))).getAsJsonObject();
            String string = version.get("id").getAsString();
            return string;
        }
    }

    private static String getVersionFromFabric() {
        try {
            Class<?> fabricLoaderClass = Class.forName("net.fabricmc.loader.api.FabricLoader");
            Method getInstanceMethod = fabricLoaderClass.getMethod("getInstance", new Class[0]);
            Object fabricLoaderInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method getModContainerMethod = fabricLoaderClass.getMethod("getModContainer", String.class);
            Optional minecraftContainerOptional = (Optional)getModContainerMethod.invoke(fabricLoaderInstance, "minecraft");
            return minecraftContainerOptional.map(Utils::getVersionFromModMetadata).orElse(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Failed to get version from Fabric", (Throwable)e);
            return null;
        }
    }

    private static String getVersionFromModMetadata(Object container) {
        try {
            Method getMetadataMethod = container.getClass().getMethod("getMetadata", new Class[0]);
            getMetadataMethod.setAccessible(true);
            Object modMetadata = getMetadataMethod.invoke(container, new Object[0]);
            Method getVersionMethod = modMetadata.getClass().getMethod("getVersion", new Class[0]);
            getVersionMethod.setAccessible(true);
            return getVersionMethod.invoke(modMetadata, new Object[0]).toString();
        }
        catch (Exception e) {
            LOGGER.error("Failed to get version from ModMetadata", (Throwable)e);
            return null;
        }
    }

    private static String checkSupportedVersion(String version) {
        if (version == null) {
            return null;
        }
        String mixinVersion = null;
        switch (version) {
            case "1.20.1": 
            case "1.20.4": {
                mixinVersion = version;
                break;
            }
            default: {
                LOGGER.error("FocalEngine: Unsupported Minecraft version: " + version + ", Mixins will not load, an error message will be shown later");
            }
        }
        if (mixinVersion != null) {
            LOGGER.info("FocalEngine: Found Minecraft version: " + mixinVersion);
        }
        return mixinVersion;
    }
}

