/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge1204.mixin.api;

import com.mojang.blaze3d.pipeline.RenderTarget;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.shaderpack.ShaderpackInfo;
import graphics.continuum.forge1204.gui.toasts.TextToast;
import graphics.continuum.forge1204.mixin.access.GameRendererInvoker;
import graphics.continuum.forge1204.mixin.access.ShadersMultiTexTextureManagerAccess;
import graphics.continuum.forge1204.mixin.access.TextureAtlasAccessor;
import graphics.continuum.impl.api.game.FocalEngineGameInterface;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.renderer.texture.TextureProxy;
import graphics.continuum.renderer.uniform.GlobalUniforms;
import graphics.continuum.tracking.TrackedResource;
import graphics.continuum.tracking.TrackedResources;
import graphics.continuum.util.Reference;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.optifine.shaders.ItemAliases;
import net.optifine.shaders.MultiTexID;
import net.optifine.shaders.Shaders;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={FocalEngineGameInterface.class}, remap=false)
public class FocalEngineGameInterfaceMixin {
    @Overwrite
    public static void sendMessage(String message) {
        if (Minecraft.m_91087_().f_91065_ != null && Minecraft.m_91087_().f_91065_.m_93076_() != null) {
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)message));
        }
    }

    @Overwrite
    public static void sendToast(String title, String body) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new TextToast(title, body));
    }

    @Overwrite
    public static void registerMinecraftTextures(TextureManager textureManager) {
        textureManager.initializeTextureProxy("minecraftFBOColor", new Reference<Integer>(0));
        textureManager.initializeTextureProxy("minecraftFBODepth", new Reference<Integer>(0));
        textureManager.initializeTextureProxy("blockAlbedoAtlas", new Reference<Integer>(0));
        textureManager.initializeTextureProxy("blockNormalAtlas", new Reference<Integer>(0));
        textureManager.initializeTextureProxy("blockSpecularAtlas", new Reference<Integer>(0));
    }

    @Overwrite
    public static void updateMinecraftTextures(TextureManager textureManager) {
        RenderTarget mcFrameBuffer = Minecraft.m_91087_().m_91385_();
        ((TextureProxy)textureManager.getTexture("minecraftFBOColor")).updateTextureID(mcFrameBuffer.m_83975_());
        ((TextureProxy)textureManager.getTexture("minecraftFBODepth")).updateTextureID(mcFrameBuffer.m_83980_());
        MultiTexID blockAtlasTextures = ((ShadersMultiTexTextureManagerAccess)Minecraft.m_91087_().f_90987_.m_118506_(TextureAtlas.f_118259_)).invoker$getMultiTexID();
        ((TextureProxy)textureManager.getTexture("blockAlbedoAtlas")).updateTextureID(blockAtlasTextures.base);
        ((TextureProxy)textureManager.getTexture("blockNormalAtlas")).updateTextureID(blockAtlasTextures.norm);
        ((TextureProxy)textureManager.getTexture("blockSpecularAtlas")).updateTextureID(blockAtlasTextures.spec);
    }

    @Overwrite
    public static String getUsername() {
        return Minecraft.m_91087_().m_91094_().m_92546_();
    }

    @Overwrite
    public static String getUuid() {
        return Minecraft.m_91087_().m_91094_().m_240411_().toString();
    }

    @Overwrite
    public static String getGameVersion() {
        return Minecraft.m_91087_().m_91388_();
    }

    @Overwrite
    public static int getFontWidth(String line) {
        return Minecraft.m_91087_().f_91062_.m_92895_(line);
    }

    @Overwrite
    public static int getMainRenderTargetID() {
        return Minecraft.m_91087_().m_91385_().f_83920_;
    }

    @Overwrite
    public static int getMainRenderTargetWidth() {
        return Minecraft.m_91087_().m_91385_().f_83915_;
    }

    @Overwrite
    public static int getMainRenderTargetHeight() {
        return Minecraft.m_91087_().m_91385_().f_83916_;
    }

    @Overwrite
    public static void updateTrackedWindowUniforms(TrackedResources tracked) {
        int windowWidth = Minecraft.m_91087_().m_91268_().m_85441_();
        int windowHeight = Minecraft.m_91087_().m_91268_().m_85442_();
        tracked.markUniformUpdate("renderScale", Float.valueOf(Shaders.configRenderResMul));
        int scaledWindowWidth = (int)((float)windowWidth * Shaders.configRenderResMul);
        int scaledWindowHeight = (int)((float)windowHeight * Shaders.configRenderResMul);
        tracked.markUniformUpdate("windowWidth", scaledWindowWidth);
        tracked.markUniformUpdate("windowHeight", scaledWindowHeight);
        tracked.markUniformUpdate("aspectRatio", Float.valueOf((float)scaledWindowWidth / (float)scaledWindowHeight));
        tracked.markUniformUpdate("pixelSize", new Vector2f((float)(1.0 / (double)scaledWindowWidth), (float)(1.0 / (double)scaledWindowHeight)));
        tracked.markUniformUpdate("nativeWindowWidth", windowWidth);
        tracked.markUniformUpdate("nativeWindowHeight", windowHeight);
    }

    @Unique
    private static int focal$getDimensionId(Level world) {
        return world == null ? 0 : FocalEngineGameInterfaceMixin.focal$getDimensionId((ResourceKey<Level>)world.m_46472_());
    }

    @Unique
    private static int focal$getDimensionId(ResourceKey<Level> dimension) {
        if (dimension == Level.f_46429_) {
            return -1;
        }
        if (dimension == Level.f_46430_) {
            return 1;
        }
        return 0;
    }

    @Overwrite
    public static void updateTrackedInGameUniforms(TrackedResources tracked) {
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        Entity viewEntity = Minecraft.m_91087_().m_91288_();
        float partialTicks = Minecraft.m_91087_().m_91296_();
        Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        ShaderpackInfo info = FocalEngineCore.getInstance().getShaderpackManager().getCurrentShaderpack().getShaderpackInfo();
        if (clientWorld != null && viewEntity != null && Minecraft.m_91087_().f_91074_ != null) {
            TextureAtlasAccessor atlas = (TextureAtlasAccessor)Minecraft.m_91087_().f_90987_.m_118506_(InventoryMenu.f_39692_);
            Vector3f cameraPosition = new Vector3f((float)renderInfo.m_90583_().f_82479_, (float)renderInfo.m_90583_().f_82480_, (float)renderInfo.m_90583_().f_82481_);
            tracked.markUniformUpdate("previousCameraPosition", (Boolean)tracked.getTrackedUniform("firstFrame").getValue() != false ? cameraPosition : tracked.getTrackedUniform("cameraPosition").getValue());
            tracked.markUniformUpdate("cameraPosition", cameraPosition);
            tracked.markUniformUpdate("atlasDimensions", new Vector2i(atlas.accessor$getWidth(), atlas.accessor$getHeight()));
            tracked.markUniformUpdate("atlasTexelSize", new Vector2f(1.0f / (float)atlas.accessor$getWidth(), 1.0f / (float)atlas.accessor$getHeight()));
            int previousWorldTime = (Integer)tracked.getTrackedUniform("worldTime").getValue();
            tracked.markUniformUpdate("previousWorldTime", previousWorldTime);
            tracked.markUniformUpdate("worldTime", (int)(clientWorld.m_46468_() % 24000L));
            tracked.markUniformUpdate("worldDay", (int)(clientWorld.m_46468_() / 24000L));
            tracked.markUniformUpdate("moonPhase", clientWorld.m_46941_());
            tracked.markUniformUpdate("brightness", Float.valueOf((float)((Double)Minecraft.m_91087_().f_91066_.m_231927_().m_231551_()).doubleValue()));
            tracked.markUniformUpdate("blindness", Float.valueOf(Minecraft.m_91087_().f_91074_.m_21023_(MobEffects.f_19610_) ? 1.0f : 0.0f));
            tracked.markUniformUpdate("nausea", Float.valueOf(Minecraft.m_91087_().f_91074_.m_21023_(MobEffects.f_19604_) ? 1.0f : 0.0f));
            tracked.markUniformUpdate("nightVision", Float.valueOf(Minecraft.m_91087_().f_91074_.m_21023_(MobEffects.f_19611_) ? 1.0f : 0.0f));
            FocalEngineGameInterfaceMixin.focal$figureOutRainStrength(tracked, clientWorld, partialTicks);
            Vec3 lookDirection = viewEntity.m_20154_();
            Vector3f viewVector = new Vector3f((float)lookDirection.f_82479_, (float)lookDirection.f_82480_, (float)lookDirection.f_82481_);
            tracked.markUniformUpdate("viewVector", viewVector);
            float farClippingPlane = Math.max((float)((Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_()).intValue() * 32.0f, 173.0f);
            tracked.markUniformUpdate("near", Float.valueOf(0.05f));
            tracked.markUniformUpdate("far", Float.valueOf(farClippingPlane));
            tracked.markUniformUpdate("dimensionID", FocalEngineGameInterfaceMixin.focal$getDimensionId((Level)clientWorld));
            FogType cameraFluidState = renderInfo.m_167685_();
            if (cameraFluidState == FogType.WATER) {
                tracked.markUniformUpdate("isEyeInWater", 1);
            } else if (cameraFluidState == FogType.LAVA) {
                tracked.markUniformUpdate("isEyeInWater", 2);
            } else {
                tracked.markUniformUpdate("isEyeInWater", 0);
            }
            if (++GlobalUniforms.frameCounter >= 720720) {
                GlobalUniforms.frameCounter = 0;
            }
            long systemTime = System.currentTimeMillis();
            if (GlobalUniforms.lastSystemTime == 0L) {
                GlobalUniforms.lastSystemTime = systemTime;
            }
            long diffSystemTime = systemTime - GlobalUniforms.lastSystemTime;
            GlobalUniforms.lastSystemTime = systemTime;
            float frameTime = (float)diffSystemTime / 1000.0f;
            GlobalUniforms.frameTimeCounter += frameTime;
            tracked.markUniformUpdate("frameCounter", GlobalUniforms.frameCounter);
            tracked.markUniformUpdate("frameTime", Float.valueOf(frameTime));
            tracked.markUniformUpdate("frameTimeCounter", Float.valueOf(GlobalUniforms.frameTimeCounter %= 3600.0f));
            tracked.markUniformUpdate("nextTaaJitter", GlobalUniforms.taaJitterOffsets[Math.max(0, GlobalUniforms.frameCounter + 1) % 16].div((float)Minecraft.m_91087_().m_91268_().m_85441_(), (float)Minecraft.m_91087_().m_91268_().m_85442_(), new Vector2f()));
            tracked.markUniformUpdate("previousTaaJitter", GlobalUniforms.taaJitterOffsets[Math.max(0, GlobalUniforms.frameCounter - 1) % 16].div((float)Minecraft.m_91087_().m_91268_().m_85441_(), (float)Minecraft.m_91087_().m_91268_().m_85442_(), new Vector2f()));
            tracked.markUniformUpdate("taaJitter", GlobalUniforms.taaJitterOffsets[GlobalUniforms.frameCounter % 16].div((float)Minecraft.m_91087_().m_91268_().m_85441_(), (float)Minecraft.m_91087_().m_91268_().m_85442_(), new Vector2f()));
            float rainStrength = ((Float)tracked.getTrackedUniform("rainStrength").getValue()).floatValue();
            float fadeScalarRain = (float)diffSystemTime * 0.01f;
            float wetnessHalflife = info.getWetnessHalfLife().floatValue();
            float drynessHalflife = info.getDrynessHalfLife().floatValue();
            float previousWetness = ((Float)tracked.getTrackedUniform("wetness").getValue()).floatValue();
            float tempRain = (float)Math.exp(Math.log(0.5) * (double)fadeScalarRain / (double)(previousWetness < rainStrength ? drynessHalflife : wetnessHalflife));
            tracked.markUniformUpdate("wetness", Float.valueOf(previousWetness * tempRain + rainStrength * (1.0f - tempRain)));
            wetnessHalflife = info.getWetness2HalfLife().floatValue();
            drynessHalflife = info.getDryness2HalfLife().floatValue();
            previousWetness = ((Float)tracked.getTrackedUniform("wetness2").getValue()).floatValue();
            tempRain = (float)Math.exp(Math.log(0.5) * (double)fadeScalarRain / (double)(previousWetness < rainStrength ? drynessHalflife : wetnessHalflife));
            tracked.markUniformUpdate("wetness2", Float.valueOf(previousWetness * tempRain + rainStrength * (1.0f - tempRain)));
            ItemStack mainItemStack = Minecraft.m_91087_().f_91074_.m_21205_();
            Item mainItem = mainItemStack.m_41720_();
            ItemStack offItemStack = Minecraft.m_91087_().f_91074_.m_21206_();
            Item offItem = offItemStack.m_41720_();
            int mainHandID = -1;
            mainHandID = BuiltInRegistries.f_257033_.m_7447_((Object)mainItem);
            mainHandID = ItemAliases.getItemAliasId((int)mainHandID);
            int offHandID = -1;
            offHandID = BuiltInRegistries.f_257033_.m_7447_((Object)offItem);
            offHandID = ItemAliases.getItemAliasId((int)offHandID);
            tracked.markUniformUpdate("heldItem", new Vector2i(mainHandID, offHandID));
            int packedLightAtPlayerEye = Minecraft.m_91087_().m_91290_().m_114394_(viewEntity, partialTicks);
            tracked.markUniformUpdate("eyeBrightness", new Vector2f((float)(packedLightAtPlayerEye & 0xFFFF), (float)(packedLightAtPlayerEye >> 16)));
            float eyeBrightnessHalfLife = info.getEyeBrightnessHalfLife().floatValue();
            float fadeScalarBrightness = (float)diffSystemTime * 0.01f;
            float tempBrightness = (float)Math.exp(Math.log(0.5) * (double)fadeScalarBrightness / (double)eyeBrightnessHalfLife);
            Vector2f previousEyeBrightnessSmooth = (Vector2f)tracked.getTrackedUniform("eyeBrightnessSmooth").getValue();
            Vector2f eyeBrightnessSmooth = new Vector2f(previousEyeBrightnessSmooth.x * tempBrightness + (float)(packedLightAtPlayerEye & 0xFFFF) * (1.0f - tempBrightness), previousEyeBrightnessSmooth.y * tempBrightness + (float)(packedLightAtPlayerEye >> 16) * (1.0f - tempBrightness));
            tracked.markUniformUpdate("eyeBrightnessSmooth", eyeBrightnessSmooth);
            tracked.markUniformUpdate("cameraFov", Float.valueOf((float)((GameRendererInvoker)Minecraft.m_91087_().f_91063_).invokeGetFov(Minecraft.m_91087_().f_91063_.m_109153_(), Minecraft.m_91087_().m_91296_(), true)));
        }
    }

    @Unique
    private static void focal$figureOutRainStrength(TrackedResources tracked, ClientLevel clientWorld, float partialTicks) {
        TrackedResource trackedRainStrength = tracked.getTrackedUniform("rainStrength");
        float rainStrength = clientWorld.m_46722_(partialTicks);
        if (trackedRainStrength.getValue() == null || (clientWorld.m_6106_().m_6533_() || (double)rainStrength != 1.0) && (!clientWorld.m_6106_().m_6533_() || (double)rainStrength != 0.0) || rainStrength == 0.0f && ((Float)trackedRainStrength.getValue()).floatValue() == 1.0f || rainStrength == 1.0f && ((Float)trackedRainStrength.getValue()).floatValue() == 0.0f) {
            trackedRainStrength.update(Float.valueOf(rainStrength));
        }
    }
}

