/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge1204.gui.widget;

import graphics.continuum.forge1204.gui.panel.ProductInfoPanel;
import graphics.continuum.forge1204.gui.widget.IDropdownMenuEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class DropdownMenuWidget<T extends IDropdownMenuEntry>
extends AbstractButton {
    private final ProductInfoPanel productInfoPanel;
    private final SortType<T> sortType;
    protected final Font font;
    private final List<T> menuEntries = new ArrayList<T>();
    private T selectedEntry;
    private int maxEntryWidth;
    private boolean extended;

    public DropdownMenuWidget(ProductInfoPanel productInfoPanel, int x, int y, int width, int height, String dropdownButtonText) {
        super(x, y, width, height, (Component)Component.m_237113_((String)dropdownButtonText));
        this.sortType = new SortType();
        this.productInfoPanel = productInfoPanel;
        this.font = Minecraft.m_91087_().f_91062_;
        this.maxEntryWidth = 0;
        this.f_93623_ = false;
    }

    public void addEntry(T entry) {
        this.menuEntries.add(entry);
        this.menuEntries.sort(this.sortType);
        this.maxEntryWidth = Math.max(this.maxEntryWidth, this.font.m_92895_(entry.getText()));
        this.f_93623_ = true;
    }

    public void addEntries(Collection<T> entries) {
        this.menuEntries.addAll(entries);
        this.menuEntries.sort(this.sortType);
        this.menuEntries.forEach(entry -> {
            this.maxEntryWidth = Math.max(this.maxEntryWidth, this.font.m_92895_(entry.getText()));
        });
        this.f_93623_ = !this.menuEntries.isEmpty();
    }

    public void addEntries(Collection<T> entries, Predicate<T> filter) {
        entries.removeIf(filter.negate());
        this.menuEntries.addAll(entries);
        this.menuEntries.sort(this.sortType);
        this.menuEntries.forEach(entry -> {
            this.maxEntryWidth = Math.max(this.maxEntryWidth, this.font.m_92895_(entry.getText()));
        });
        this.f_93623_ = !this.menuEntries.isEmpty();
    }

    public int getEntryIndex(T entry) {
        return this.menuEntries.indexOf(entry);
    }

    public void selectEntry(T entry) {
        this.selectedEntry = entry;
    }

    public void selectEntry(int index) {
        this.selectedEntry = (IDropdownMenuEntry)this.menuEntries.get(index);
    }

    public boolean isSelected(T entry) {
        return entry.equals(this.selectedEntry);
    }

    public void clearEntries() {
        this.menuEntries.clear();
        this.maxEntryWidth = 0;
        this.selectedEntry = null;
        this.f_93623_ = false;
    }

    public List<T> getEntries() {
        return this.menuEntries;
    }

    public int getEntriesLength() {
        Objects.requireNonNull(this.font);
        return 9 * this.menuEntries.size() + 10;
    }

    public int getEntryIndexAt(int mouseX, int mouseY) {
        int top = this.m_252907_() + this.f_93619_ + 5;
        int bottom = top + this.getEntriesLength() - 10;
        if (mouseY < top || mouseY >= bottom || mouseX < this.m_252754_() || mouseX > this.m_252754_() + this.f_93618_) {
            return -1;
        }
        float f = mouseY - top;
        Objects.requireNonNull(this.font);
        return (int)Math.floor(f / 9.0f);
    }

    public T getSelectedEntry() {
        return this.selectedEntry;
    }

    private boolean mouseInBounds(double mouseX, double mouseY, int top, int bottom, int left, int right, boolean extendedTest) {
        int dynamicBottom = extendedTest ? bottom + this.getEntriesLength() : bottom;
        return mouseX >= (double)left && mouseX <= (double)right && mouseY >= (double)top && mouseY <= (double)dynamicBottom;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        boolean validClick = this.mouseInBounds(mouseX, mouseY, this.m_252907_(), this.m_252907_() + this.f_93619_, this.m_252754_(), this.m_252754_() + this.f_93618_, this.extended);
        return validClick;
    }

    public void m_5691_() {
    }

    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        boolean wasActive = this.f_93623_;
        if (this.extended) {
            int index = 0;
            int hoveredEntry = this.getEntryIndexAt(pMouseX, pMouseY);
            int bgWidth = Math.max(this.maxEntryWidth + 10, this.f_93618_);
            int bgLeft = this.m_252754_() + this.f_93618_ / 2 - bgWidth / 2;
            int bgOuterColor = -15921907;
            int bgInnerColor = -16777216;
            pGuiGraphics.m_280509_(bgLeft, this.m_252907_(), bgLeft + bgWidth - 1, this.m_252907_() + this.f_93619_ + this.getEntriesLength(), -15921907);
            pGuiGraphics.m_280509_(bgLeft + 1, this.m_252907_() + 1, bgLeft + bgWidth - 2, this.m_252907_() + this.f_93619_ + this.getEntriesLength() - 1, -16777216);
            for (IDropdownMenuEntry entry : this.menuEntries) {
                int n = this.m_252754_();
                int n2 = this.m_252907_() + this.f_93619_ + 5;
                Objects.requireNonNull(this.font);
                entry.draw(pGuiGraphics, this, n, n2 + index * 9, index == hoveredEntry);
                ++index;
            }
            this.f_93623_ = false;
        }
        super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.f_93623_ = wasActive;
    }

    public void m_5716_(double mouseX, double mouseY) {
        int hoveredEntry;
        if (this.mouseInBounds(mouseX, mouseY, this.m_252907_(), this.m_252907_() + this.f_93619_, this.m_252754_(), this.m_252754_() + this.f_93618_, false)) {
            this.setExtended(!this.extended);
        } else if (this.extended && this.mouseInBounds(mouseX, mouseY, this.m_252907_(), this.m_252907_() + this.f_93619_, this.m_252754_(), this.m_252754_() + this.f_93618_, true) && (hoveredEntry = this.getEntryIndexAt((int)mouseX, (int)mouseY)) > -1) {
            ((IDropdownMenuEntry)this.menuEntries.get(hoveredEntry)).onClick(this);
        }
        super.m_5716_(mouseX, mouseY);
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public ProductInfoPanel getProductInfoPanel() {
        return this.productInfoPanel;
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    public static class SortType<T extends IDropdownMenuEntry>
    implements Comparator<T> {
        @Override
        public int compare(T a, T b) {
            return a.compareTo((IDropdownMenuEntry)b);
        }
    }
}

