/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge1204.gui.screen;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.forge1204.gui.panel.DownloadListPanel;
import graphics.continuum.forge1204.gui.screen.GuiScreen;
import graphics.continuum.forge1204.gui.screen.IProductListUser;
import graphics.continuum.forge1204.gui.screen.ProductManagerScreen;
import graphics.continuum.forge1204.gui.widget.ProductListWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class DownloadManagerScreen
extends GuiScreen
implements IProductListUser {
    private List<ContinuumProductType> sortedProductsList;
    private ProductManagerScreen.SortType sortType = ProductManagerScreen.SortType.NORMAL;
    private Button backButton;
    private ProductListWidget productList;
    private DownloadListPanel downloadsList;

    public DownloadManagerScreen(Screen previousScreen) {
        super(previousScreen, (Component)Component.m_237113_((String)"Download Management"));
    }

    public void updateDisplayedProductList() {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        this.sortedProductsList = new ArrayList<ContinuumProductType>(engineInstance.getProductManager().getProductList().keySet());
        this.sortedProductsList.add(ContinuumProductType.ALL);
        this.sortedProductsList.sort(this.sortType);
    }

    @Override
    protected void m_7856_() {
        String accountName = this.getModInstance().getAccount().getUsername();
        int accountDropdownWidth = this.f_96547_.m_92895_(accountName) + 10;
        this.backButton = Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.returnToPreviousScreen()).m_252794_(this.f_96543_ - 65, 5).m_253046_(60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.backButton);
        this.updateDisplayedProductList();
        int maxListWidth = 0;
        for (ContinuumProductType product : this.sortedProductsList) {
            maxListWidth = Math.max(maxListWidth, Minecraft.m_91087_().f_91062_.m_92895_(product.getDisplayName()));
        }
        maxListWidth = Math.max(maxListWidth, 100) + 10;
        this.productList = new ProductListWidget(this, maxListWidth, this.f_96544_, 30, 5);
        this.productList.refreshList();
        this.productList.m_252865_(5);
        this.m_142416_((GuiEventListener)this.productList);
        this.downloadsList = new DownloadListPanel(this, maxListWidth + 10, 30, 5);
        this.m_142416_((GuiEventListener)this.downloadsList);
    }

    @Override
    public void m_86600_() {
        this.downloadsList.tick();
    }

    @Override
    protected void preDraw(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(guiGraphics);
        this.productList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.downloadsList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void postDraw(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public Collection<ContinuumProductType> getSortedProducts() {
        return this.sortedProductsList;
    }

    @Override
    public void selectProductEntry(ProductListWidget.Entry product) {
        this.productList.m_6987_((AbstractSelectionList.Entry)product);
    }

    public ProductListWidget.Entry getSelectedProductEntry() {
        return (ProductListWidget.Entry)this.productList.m_93511_();
    }
}

