/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge1204.gui.panel;

import com.google.common.collect.Lists;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProductItem;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.forge1204.gui.FocalGuiUtils;
import graphics.continuum.forge1204.gui.panel.ScrollPanel;
import graphics.continuum.forge1204.gui.screen.DownloadManagerScreen;
import graphics.continuum.product.DownloadManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.joml.Vector4f;

public class DownloadListPanel
extends ScrollPanel
implements NarratableEntry {
    private final DownloadManagerScreen parent;
    private final List<Entry> listEntries = Lists.newArrayList();

    public DownloadListPanel(DownloadManagerScreen parentScreen, int left, int top, int padding) {
        super(parentScreen, left, top, parentScreen.f_96543_ - left - padding, parentScreen.f_96544_ - top - padding);
        this.parent = parentScreen;
    }

    @Override
    protected int getContentHeight() {
        int totalHeight = 0;
        for (Entry listEntry : this.listEntries) {
            totalHeight += listEntry.parent.getHeight();
        }
        return totalHeight;
    }

    @Override
    protected int getScrollAmount() {
        return 1;
    }

    @Override
    protected int getMinScroll() {
        return 0;
    }

    @Override
    public void tick() {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        DownloadManager downloadManager = engineInstance.getDownloadManager();
        ArrayList<DownloadManager.DownloadRequest> activeDownloads = new ArrayList<DownloadManager.DownloadRequest>();
        if (this.parent.getSelectedProductEntry().getProductType() == ContinuumProductType.ALL) {
            downloadManager.getAllDownloads().values().forEach(activeDownloads::addAll);
        } else {
            activeDownloads.addAll(downloadManager.getDownloadsForProduct(this.parent.getSelectedProductEntry().getProductType()));
        }
        this.listEntries.clear();
        this.m_6702_().clear();
        int cancelButtonHeight = 5;
        for (DownloadManager.DownloadRequest downloadRequest : activeDownloads) {
            Entry listEntry = new Entry(this, downloadRequest, this.top + cancelButtonHeight);
            this.listEntries.add(listEntry);
            cancelButtonHeight += listEntry.parent.getHeight();
        }
    }

    @Override
    protected void drawPreScissor(GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks) {
        Vector4f bgColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.5f);
        FocalGuiUtils.drawGradientRect(left, top, this.right, this.bottom, bgColor, bgColor);
    }

    @Override
    protected void drawScissor(GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks) {
        for (Entry listEntry : this.listEntries) {
            listEntry.render(guiGraphics, left, top, mouseX, mouseY, partialTicks);
            top += listEntry.getHeight();
        }
    }

    @Override
    protected void drawPostScissor(GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks) {
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    private static class Entry {
        private final Vector4f bgColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.1f);
        private final Vector4f fgColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.1f);
        private final Vector4f progressColor = new Vector4f(0.0f, 1.0f, 0.0f, 0.5f);
        private final Vector4f failedColor = new Vector4f(1.0f, 0.0f, 0.0f, 0.5f);
        private final DownloadListPanel parent;
        private final DownloadManager.DownloadRequest downloadRequest;
        private final Button cancelButton;
        private final Button restartButton;

        private Entry(DownloadListPanel parent, DownloadManager.DownloadRequest downloadRequest, int cancelButtonHeight) {
            this.parent = parent;
            this.downloadRequest = downloadRequest;
            this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> {
                if (!this.downloadRequest.hasFailed() && !this.downloadRequest.hasFinished()) {
                    this.downloadRequest.cancel();
                } else {
                    FocalEngineCore.getInstance().getDownloadManager().removeDownloadFromBin(this.downloadRequest.getProduct().product.getProductType(), this.downloadRequest);
                }
            }).m_252794_(parent.right - 65, cancelButtonHeight).m_253046_(60, 20).m_253136_();
            this.cancelButton.f_93623_ = downloadRequest.hasStarted();
            parent.addChild((GuiEventListener)this.cancelButton);
            this.restartButton = Button.m_253074_((Component)Component.m_237113_((String)"Restart"), button -> {
                DownloadManager downloadManager = FocalEngineCore.getInstance().getDownloadManager();
                ContinuumProductItem productItem = this.downloadRequest.getProduct();
                downloadManager.removeDownloadFromBin(productItem.product.getProductType(), this.downloadRequest);
                downloadManager.downloadItem(productItem);
            }).m_252794_(parent.right - this.cancelButton.m_5711_() - 70, cancelButtonHeight).m_253046_(60, 20).m_253136_();
            this.restartButton.f_93623_ = downloadRequest.hasFailed() || downloadRequest.wasCancelled();
            parent.addChild((GuiEventListener)this.restartButton);
        }

        public void render(GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks) {
            Font fontRenderer = this.parent.getClient().f_91062_;
            FocalGuiUtils.drawGradientRect(left, top, this.parent.right, top + this.getHeight(), this.bgColor, this.bgColor);
            FocalGuiUtils.drawGradientRect(left + 1, top + 1, this.parent.right - 1, top + this.getHeight() - 1, this.fgColor, this.fgColor);
            int textRight = this.parent.right - (this.downloadRequest.hasFinished() && !this.downloadRequest.hasFailed() ? 0 : this.cancelButton.m_5711_() + 10) - 10;
            switch (this.downloadRequest.getState()) {
                case DOWNLOADING: 
                case FINISHED: {
                    FocalGuiUtils.drawGradientRect(left + 1, top + 1, left + Math.round((float)(this.parent.width - 1) * this.downloadRequest.getProgress()), top + this.getHeight() - 1, this.progressColor, this.progressColor);
                    if (this.downloadRequest.getState() != DownloadManager.DownloadState.DOWNLOADING) {
                        this.cancelButton.m_93666_((Component)Component.m_237113_((String)"Remove"));
                    } else {
                        String progressText = new DecimalFormat("###.0").format(this.downloadRequest.getProgress() * 100.0f) + "%";
                        guiGraphics.m_280488_(fontRenderer, progressText, textRight - fontRenderer.m_92895_(progressText), top + 11, -1);
                    }
                    this.cancelButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                    break;
                }
                case FAILED: {
                    FocalGuiUtils.drawGradientRect(left + 1, top + 1, left + this.parent.width - 1, top + this.getHeight() - 1, this.failedColor, this.failedColor);
                    this.cancelButton.m_93666_((Component)Component.m_237113_((String)"Remove"));
                    this.cancelButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                    this.restartButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                }
            }
            String downloadName = this.parent.parent.getSelectedProductEntry().getProductType() == ContinuumProductType.ALL ? this.downloadRequest.getProduct().itemName : this.downloadRequest.getProduct().displayedVersionID;
            guiGraphics.m_280488_(fontRenderer, downloadName, left + 5, top + 11, -1);
        }

        public int getHeight() {
            return 30;
        }
    }
}

