/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge1204.gui.data.dropdown.banner;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProductItem;
import graphics.continuum.forge1204.gui.data.dropdown.banner.IInstallEntry;
import graphics.continuum.forge1204.gui.panel.ProductInfoPanel;
import graphics.continuum.forge1204.gui.screen.ConfirmOpenLinkScreen;
import graphics.continuum.forge1204.gui.widget.DropdownMenuWidget;
import graphics.continuum.forge1204.gui.widget.IDropdownMenuEntry;
import graphics.continuum.shaderpack.ShaderpackManager;
import graphics.continuum.util.Util;
import java.io.File;
import net.minecraft.client.gui.screens.Screen;

public class ProductBuildEntry
implements IInstallEntry {
    private final ContinuumProductItem productItem;
    private final String text;

    public ProductBuildEntry(ContinuumProductItem productItem) {
        this.productItem = productItem;
        this.text = productItem.displayedVersionID;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void onClick(DropdownMenuWidget dropdown) {
        dropdown.selectEntry(this);
        dropdown.getProductInfoPanel().setInstallState(this.getInstallState());
    }

    @Override
    public void onDownload(ProductInfoPanel productInfoPanel) {
        FocalEngineCore.getInstance().getDownloadManager().downloadItem(this.productItem);
    }

    @Override
    public void onPurchase(ProductInfoPanel productInfoPanel) {
        productInfoPanel.getClient().m_91152_((Screen)new ConfirmOpenLinkScreen(productInfoPanel.getParent(), this::confirmLink, this.getPurchaseLink(), false));
    }

    @Override
    public void onUninstall(ProductInfoPanel productInfoPanel) {
        File productItemFile = new File(this.productItem.product.getProductType().getInstallPath(this.productItem));
        productItemFile.delete();
        File productConfigFolder = new File(ShaderpackManager.CONFIGS_FOLDER.resolve(this.productItem.itemName).toString());
        if (productConfigFolder.exists()) {
            Util.deleteFolderRecursive(productConfigFolder);
        }
        productInfoPanel.setInstallState(this.getInstallState());
    }

    @Override
    public boolean isAccessible() {
        return this.productItem.isAccessible;
    }

    @Override
    public int compareTo(IDropdownMenuEntry o) {
        if (o instanceof ProductBuildEntry) {
            return ((ProductBuildEntry)o).productItem.compareTo(this.productItem);
        }
        return o.getText().compareTo(this.getText());
    }

    public ContinuumProductItem getProductItem() {
        return this.productItem;
    }

    public ProductInfoPanel.InstallState getInstallState() {
        ProductInfoPanel.InstallState installState = ProductInfoPanel.InstallState.CAN_PURCHASE_PRODUCT;
        if (FocalEngineCore.getInstance().getDownloadManager().hasItemDownload(this.getProductItem())) {
            installState = ProductInfoPanel.InstallState.CURRENTLY_DOWNLOADING_PRODUCT;
        } else if (FocalEngineCore.getInstance().getProductManager().isProductItemInstalled(this.productItem)) {
            installState = ProductInfoPanel.InstallState.UNINSTALL;
        } else if (this.isAccessible()) {
            installState = ProductInfoPanel.InstallState.CAN_DOWNLOAD_PRODUCT;
        }
        return installState;
    }
}

