/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge1204.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.joml.Vector4f;

public class FocalGuiUtils {
    public static void drawGradientRect(int left, int top, int right, int bottom, Vector4f startColor, Vector4f endColor) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)right, (double)top, 0.0).m_85950_(startColor.x, startColor.y, startColor.z, startColor.w).m_5752_();
        buffer.m_5483_((double)left, (double)top, 0.0).m_85950_(startColor.x, startColor.y, startColor.z, startColor.w).m_5752_();
        buffer.m_5483_((double)left, (double)bottom, 0.0).m_85950_(endColor.x, endColor.y, endColor.z, endColor.w).m_5752_();
        buffer.m_5483_((double)right, (double)bottom, 0.0).m_85950_(endColor.x, endColor.y, endColor.z, endColor.w).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static List<Component> wrapText(List<String> description, Font font, int maxLineLength) {
        ArrayList wrapped = Lists.newArrayList();
        for (String line : description) {
            if (line == null) {
                wrapped.add(null);
                continue;
            }
            MutableComponent chat = Component.m_237113_((String)line);
            if (maxLineLength < 0) continue;
            font.m_92865_().m_92414_((FormattedText)chat, maxLineLength, Style.f_131099_).forEach(iTextProperties -> wrapped.add(Component.m_237113_((String)iTextProperties.getString())));
        }
        return wrapped;
    }
}

