/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge120.oldmixin.optifine;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.renderpass.BlendState;
import graphics.continuum.data.renderpass.LegacyRenderPassInfo;
import graphics.continuum.forge120.mixin.access.ShadersFramebufferAccessor;
import graphics.continuum.forge120.oldmixin.mc.GameRendererInvoker;
import graphics.continuum.forge120.optifine.OptiFineBridgedShaderpack;
import graphics.continuum.renderer.framebuffer.FrameBuffer;
import graphics.continuum.renderer.framebuffer.FrameBufferManager;
import graphics.continuum.renderer.renderpass.passes.LegacyRenderPass;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.renderer.texture.TextureProxy;
import graphics.continuum.shaderpack.FocalShaderpackBase;
import graphics.continuum.shaderpack.ShaderpackManager;
import graphics.continuum.tracking.TrackedResources;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.optifine.render.GlAlphaState;
import net.optifine.shaders.DrawBuffers;
import net.optifine.shaders.GlState;
import net.optifine.shaders.ICustomTexture;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.Program;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersFramebuffer;
import net.optifine.shaders.uniform.ShaderUniform1i;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL46C;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Pseudo
@Mixin(targets={"net.optifine.shaders.Shaders"})
public abstract class ShadersMixin {
    @Shadow(remap=false)
    private static IShaderPack shaderPack;
    @Shadow(remap=false)
    static int usedShadowColorBuffers;
    @Shadow(remap=false)
    static int usedShadowDepthBuffers;
    @Shadow(remap=false)
    static ShadersFramebuffer sfb;
    @Shadow(remap=false)
    static float[] sunPosition;
    @Shadow(remap=false)
    static float[] moonPosition;
    @Shadow(remap=false)
    static float[] shadowLightPosition;
    @Shadow(remap=false)
    @Final
    static FloatBuffer modelView;
    @Shadow(remap=false)
    static int usedDepthBuffers;
    @Shadow(remap=false)
    public static boolean isRenderingWorld;
    @Shadow(remap=false)
    public static Program activeProgram;

    @Shadow(remap=false)
    protected static void setProgramUniform1i(ShaderUniform1i su, int value) {
    }

    @Redirect(method={"Lnet/optifine/shaders/Shaders;startup(Lnet/minecraft/client/Minecraft;)V"}, at=@At(value="INVOKE", target="Lnet/optifine/shaders/Shaders;loadConfig()V", remap=false), remap=false)
    @Dynamic
    private static void focal$removeShaderPackLoad() {
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;listOfShaders()Ljava/util/ArrayList;"}, at={@At(value="RETURN")}, remap=false)
    @Dynamic
    private static void focal$addToShaderList(CallbackInfoReturnable<ArrayList<String>> cir) {
        List packs = (List)cir.getReturnValue();
        ShaderpackManager shaderpackManager = FocalEngineCore.getInstance().getShaderpackManager();
        shaderpackManager.rescan();
        packs.addAll(2, shaderpackManager.getInjectedNames());
    }

    @Inject(method={"getShaderPack(Ljava/lang/String;)Lnet/optifine/shaders/IShaderPack;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    @Dynamic
    private static void focal$bridgeShaderpacks(String name, CallbackInfoReturnable<IShaderPack> cir) {
        FocalEngineCore focalEngineCore = FocalEngineCore.getInstance();
        if (focalEngineCore == null) {
            return;
        }
        ShaderpackManager shaderpackManager = focalEngineCore.getShaderpackManager();
        shaderpackManager.rescan();
        IShaderPack bridged = OptiFineBridgedShaderpack.getOptiFineBridge(name);
        if (bridged != null) {
            FocalShaderpackBase shaderpack = ((OptiFineBridgedShaderpack)bridged).getBridged();
            shaderpack.create();
            shaderpack.extractConfigFolder();
            cir.setReturnValue((Object)bridged);
            cir.cancel();
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;loadShaderPack()V"}, at={@At(value="RETURN")}, remap=false)
    @Dynamic
    private static void focal$loadContinuumPackIfSelected(CallbackInfo ci) {
        FocalEngineCore focalEngineCore = FocalEngineCore.getInstance();
        if (focalEngineCore == null) {
            return;
        }
        ShaderpackManager shaderpackManager = focalEngineCore.getShaderpackManager();
        if (shaderpackManager == null) {
            return;
        }
        if (shaderPack instanceof OptiFineBridgedShaderpack) {
            shaderpackManager.loadShaderpack(shaderPack.getName(), true);
        } else {
            shaderpackManager.loadShaderpack(null, false);
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;beginRender(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/Camera;FJ)V"}, at={@At(value="TAIL")}, remap=false)
    @Dynamic
    private static void focal$injectPreRender(Minecraft minecraft, Camera activeRenderInfo, float partialTicks, long finishTimeNano, CallbackInfo ci) {
        FocalEngineCore optiForge = FocalEngineCore.getInstance();
        if (optiForge == null) {
            System.err.println("FocalEngineForge is null");
            return;
        }
        Logger log = optiForge.getLogger();
        ShaderpackManager shaderpackManager = optiForge.getShaderpackManager();
        if (shaderpackManager == null) {
            log.error("ShaderpackManager is null");
            return;
        }
        if (FocalEngineCore.getInstance().getShaderpackManager().isAnyShaderpackLoaded()) {
            GL46C.glPushDebugGroup((int)33354, (int)0, (CharSequence)"Focal Engine Pre Render");
            FocalEngineCore modInstance = FocalEngineCore.getInstance();
            FrameBufferManager frameBufferManager = modInstance.getFrameBufferManager();
            if (frameBufferManager == null) {
                log.error("FrameBufferManager is null");
                return;
            }
            if (frameBufferManager.getDefaultFrameBuffer() == null) {
                log.error("DefaultFrameBuffer is null!");
                return;
            }
            modInstance.getShaderpackManager().preRender();
            if (modInstance.getTextureManager() == null) {
                log.error("TextureManager is null");
                return;
            }
            GL46C.glPopDebugGroup();
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;renderComposites(Lnet/optifine/shaders/ShadersFramebuffer;[Lnet/optifine/shaders/Program;Z[Lnet/optifine/shaders/ICustomTexture;)V"}, at={@At(value="INVOKE", target="Lnet/optifine/shaders/Shaders;renderFinal()V", shift=At.Shift.BEFORE, remap=false)}, remap=false)
    @Dynamic
    private static void focal$injectShaderpackRender(ShadersFramebuffer framebuffer, Program[] ps, boolean renderFinal, ICustomTexture[] customTextures, CallbackInfo ci) {
        FocalEngineCore focalEngineCore = FocalEngineCore.getInstance();
        ShaderpackManager shaderpackManager = focalEngineCore.getShaderpackManager();
        if (shaderpackManager != null) {
            if (shaderpackManager.isAnyShaderpackLoaded()) {
                ShadersMixin.focal_engine$updateCameraFov();
                shaderpackManager.renderFrame();
            }
        } else {
            throw new NullPointerException("shaderpackManager");
        }
    }

    @Unique
    private static void focal_engine$updateCameraFov() {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            engineInstance.getTrackedResources().markUniformUpdate("cameraFov", Float.valueOf((float)((GameRendererInvoker)Minecraft.m_91087_().f_91063_).invokeGetFov(Minecraft.m_91087_().f_91063_.m_109153_(), Minecraft.m_91087_().m_91296_(), true)));
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;beginRender(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/Camera;FJ)V"}, at={@At(value="INVOKE", target="Lnet/optifine/shaders/ShadersFramebuffer;setColorTextures(Z)V", shift=At.Shift.BEFORE, remap=false)}, cancellable=true, remap=false)
    @Dynamic
    private static void beginRender(Minecraft minecraft, Camera activeRenderInfo, float partialTicks, long finishTimeNano, CallbackInfo ci) {
        FocalEngineCore modInstance = FocalEngineCore.getInstance();
        if (modInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            Shaders.checkGLError((String)"end beginRender");
            ci.cancel();
        }
    }

    @Redirect(method={"Lnet/optifine/shaders/Shaders;beginRenderPass(FJ)V"}, at=@At(value="INVOKE", target="Lnet/optifine/shaders/ShadersFramebuffer;bindFramebuffer()V", remap=false), remap=false)
    @Dynamic
    private static void ignoreBeginRenderPassFramebufferBind(ShadersFramebuffer shadersFramebuffer) {
        FocalEngineCore modInstance = FocalEngineCore.getInstance();
        if (!modInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            shadersFramebuffer.bindFramebuffer();
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;renderDeferred()V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    @Dynamic
    private static void skipRenderDeferred(CallbackInfo ci) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            ci.cancel();
        }
    }

    @Redirect(method={"Lnet/optifine/shaders/Shaders;useProgram(L;)V"}, at=@At(value="INVOKE", target="Lnet/optifine/shaders/GlState;setDrawBuffers(Lnet/optifine/shaders/DrawBuffers;)V"), remap=false)
    @Dynamic
    private static void setDrawBuffers(DrawBuffers drawBuffers) {
        FocalEngineCore modInstance = FocalEngineCore.getInstance();
        if (!modInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            GlState.setDrawBuffers((DrawBuffers)drawBuffers);
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;useProgram(L;)V"}, at={@At(value="INVOKE", target="Lnet/optifine/shaders/GlState;setDrawBuffers(Lnet/optifine/shaders/DrawBuffers;)V", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false)
    @Dynamic
    private static void injectJsonDrawBuffers(Program program, CallbackInfo ci, int i, DrawBuffers drawBuffers) {
        FocalEngineCore modInstance = FocalEngineCore.getInstance();
        if (modInstance.getShaderpackManager().isAnyShaderpackLoaded() && isRenderingWorld) {
            LegacyRenderPass legacyRenderPass = modInstance.getRenderPassManager().getLegacyRenderPass(program.getName());
            if (legacyRenderPass != null) {
                LegacyRenderPassInfo legacyInfo = legacyRenderPass.getLegacyRenderPassInfo();
                TextureManager textureManager = modInstance.getTextureManager();
                int taaJitterUniformIdx = GL46C.glGetUniformLocation((int)program.getId(), (CharSequence)"taaJitter");
                Vector2f taaJitter = (Vector2f)modInstance.getTrackedResources().getTrackedUniform("taaJitter").getValue();
                GL46C.glProgramUniform2f((int)program.getId(), (int)taaJitterUniformIdx, (float)taaJitter.x, (float)taaJitter.y);
                int noiseTexUniformIdx = GL46C.glGetUniformLocation((int)program.getId(), (CharSequence)"noiseTex");
                GL46C.glProgramUniform1i((int)program.getId(), (int)noiseTexUniformIdx, (int)textureManager.getTexture("noiseTex").getTextureID(null, false));
                FrameBuffer frameBuffer = modInstance.getFrameBufferManager().getDefaultFrameBuffer();
                frameBuffer.bindAndUpdateViewport();
                frameBuffer.updateDrawBuffers(legacyRenderPass.getActiveDrawBuffers(), legacyRenderPass.getColorAttachmentBuffer());
                if (legacyInfo.isDepthTest() != null) {
                    GL46C.glDepthMask((boolean)legacyInfo.isDepthTest());
                }
                if (legacyInfo.isAlphaTest() != null) {
                    GlAlphaState glAlphaState = new GlAlphaState(legacyInfo.isAlphaTest().booleanValue());
                }
                if (!legacyInfo.getBufferBlendStates().isEmpty()) {
                    GL46C.glEnable((int)3042);
                    for (BlendState blendState : legacyInfo.getBufferBlendStates()) {
                        blendState.updateBlendState(legacyRenderPass.getActiveDrawBuffers().get(blendState.textureName) - 36064);
                    }
                }
            } else {
                GlState.setDrawBuffers((DrawBuffers)drawBuffers);
            }
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;setEntityColor(FFFF)V"}, at={@At(value="INVOKE", target="Lnet/optifine/shaders/uniform/ShaderUniform4f;setValue(FFFF)V", remap=false, shift=At.Shift.AFTER)}, remap=false)
    @Dynamic
    private static void updateEntityColorValue(float r, float g, float b, float a, CallbackInfo ci) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            engineInstance.getTrackedResources().markUniformUpdate("entityColor", new Vector4f(r, g, b, a));
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;setCamera(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;F)V"}, at={@At(value="RETURN")}, remap=false)
    @Dynamic
    private static void updateMatrixValues(PoseStack matrixStack, Camera activeRenderInfo, float partialTicks, CallbackInfo ci) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            TrackedResources trackedResources = engineInstance.getTrackedResources();
            Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)matrixStack.m_85850_().m_252922_()).transpose();
            Matrix4f modelViewMatrixInverse = new Matrix4f((Matrix4fc)modelViewMatrix).invert();
            Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix()).transpose();
            Matrix4f projectionMatrixInverse = new Matrix4f((Matrix4fc)projectionMatrix).invert();
            trackedResources.markUniformUpdate("previousCameraViewMatrix", trackedResources.isTrackingUniform("cameraViewMatrix") ? trackedResources.getTrackedUniform("cameraViewMatrix").getValue() : modelViewMatrix);
            trackedResources.markUniformUpdate("previousCameraViewMatrixInverse", trackedResources.isTrackingUniform("cameraViewMatrixInverse") ? trackedResources.getTrackedUniform("cameraViewMatrixInverse").getValue() : modelViewMatrixInverse);
            trackedResources.markUniformUpdate("previousCameraProjectionMatrix", trackedResources.isTrackingUniform("cameraProjectionMatrix") ? trackedResources.getTrackedUniform("cameraProjectionMatrix").getValue() : projectionMatrix);
            trackedResources.markUniformUpdate("previousCameraProjectionMatrixInverse", trackedResources.isTrackingUniform("cameraProjectionMatrixInverse") ? trackedResources.getTrackedUniform("cameraProjectionMatrixInverse").getValue() : projectionMatrixInverse);
            trackedResources.markUniformUpdate("cameraViewMatrix", modelViewMatrix);
            trackedResources.markUniformUpdate("cameraViewMatrixInverse", modelViewMatrixInverse);
            trackedResources.markUniformUpdate("cameraProjectionMatrix", projectionMatrix);
            trackedResources.markUniformUpdate("cameraProjectionMatrixInverse", projectionMatrixInverse);
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;setCameraShadow(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;F)V"}, at={@At(value="RETURN")}, remap=false)
    @Dynamic
    private static void updateShadowMatrixValues(PoseStack matrixStack, Camera activeRenderInfo, float partialTicks, CallbackInfo ci) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            TrackedResources trackedResources = engineInstance.getTrackedResources();
            Matrix4f shadowModelViewMatrix = new Matrix4f((Matrix4fc)matrixStack.m_85850_().m_252922_()).transpose();
            Matrix4f shadowModelViewMatrixInverse = new Matrix4f((Matrix4fc)shadowModelViewMatrix).invert();
            Matrix4f shadowProjectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix()).transpose();
            Matrix4f shadowProjectionMatrixInverse = new Matrix4f((Matrix4fc)shadowProjectionMatrix).invert();
            trackedResources.markUniformUpdate("shadowViewMatrix", shadowModelViewMatrix);
            trackedResources.markUniformUpdate("shadowViewMatrixInverse", shadowModelViewMatrixInverse);
            trackedResources.markUniformUpdate("shadowProjectionMatrix", shadowProjectionMatrix);
            trackedResources.markUniformUpdate("shadowProjectionMatrixInverse", shadowProjectionMatrixInverse);
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;endWater()V"}, at={@At(value="RETURN")}, remap=false)
    @Dynamic
    private static void updateLightVectors(CallbackInfo ci) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            TrackedResources trackedResources = engineInstance.getTrackedResources();
            trackedResources.markUniformUpdate("sunPosition", new Vector3f(sunPosition));
            trackedResources.markUniformUpdate("moonPosition", new Vector3f(moonPosition));
            trackedResources.markUniformUpdate("shadowLightPosition", new Vector3f(shadowLightPosition));
            Vector3f sunVector = new Vector3f(sunPosition).normalize();
            Vector3f moonVector = new Vector3f(moonPosition).normalize();
            Vector3f shadowLightVector = new Vector3f(shadowLightPosition).normalize();
            trackedResources.markUniformUpdate("sunVector", sunVector);
            trackedResources.markUniformUpdate("moonVector", moonVector);
            trackedResources.markUniformUpdate("shadowLightVector", shadowLightVector);
            Matrix4f modelViewMatrix = new Matrix4f(modelView);
            Matrix3f modelViewInverse3x3 = new Matrix3f((Matrix4fc)modelViewMatrix).invert();
            trackedResources.markUniformUpdate("wSunVector", new Vector3f((Vector3fc)sunVector).mul((Matrix3fc)modelViewInverse3x3));
            trackedResources.markUniformUpdate("wMoonVector", new Vector3f((Vector3fc)moonVector).mul((Matrix3fc)modelViewInverse3x3));
            trackedResources.markUniformUpdate("wShadowLightVector", new Vector3f((Vector3fc)shadowLightVector).mul((Matrix3fc)modelViewInverse3x3));
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;setupShadowFrameBuffer()V"}, at={@At(value="RETURN")}, remap=false)
    @Dynamic
    private static void getShadowTextures(CallbackInfo ci) {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        if (engineInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            TextureManager textureManager = FocalEngineCore.getInstance().getTextureManager();
            if (textureManager == null) {
                return;
            }
            ShadersFramebufferAccessor sfbAccessor = (ShadersFramebufferAccessor)sfb;
            ((TextureProxy)textureManager.getTexture("shadowtex0")).updateTextureID(sfbAccessor.accessor$getDepthTextures().get(0));
            ((TextureProxy)textureManager.getTexture("shadowtex1")).updateTextureID(sfbAccessor.accessor$getDepthTextures().get(1));
            ((TextureProxy)textureManager.getTexture("shadowcolor0")).updateTextureID(sfbAccessor.accessor$getColorTextures().getA(0));
            ((TextureProxy)textureManager.getTexture("shadowcolor1")).updateTextureID(sfbAccessor.accessor$getColorTextures().getA(1));
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;createFragShader(L;Ljava/lang/String;)I"}, at={@At(value="RETURN")}, remap=false)
    @Dynamic
    private static void forceShadowTextures(Program program, String filename, CallbackInfoReturnable<Integer> cir) {
        if (FocalEngineCore.getInstance().getShaderpackManager().isAnyShaderpackLoaded()) {
            usedShadowDepthBuffers = 2;
            usedShadowColorBuffers = 2;
            usedDepthBuffers = 2;
        }
    }
}

