/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge120.mixin.render;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.renderpass.BlendState;
import graphics.continuum.data.renderpass.LegacyRenderPassInfo;
import graphics.continuum.forge120.mixin.access.GlStateManagerInvoker;
import graphics.continuum.renderer.framebuffer.FrameBuffer;
import graphics.continuum.renderer.framebuffer.FrameBufferManager;
import graphics.continuum.renderer.renderpass.passes.LegacyRenderPass;
import graphics.continuum.renderer.texture.TextureManager;
import graphics.continuum.shaderpack.ShaderpackManager;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.optifine.render.GlAlphaState;
import net.optifine.shaders.DrawBuffers;
import net.optifine.shaders.GlState;
import net.optifine.shaders.ICustomTexture;
import net.optifine.shaders.Program;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersFramebuffer;
import org.apache.logging.log4j.Logger;
import org.joml.Vector2f;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL41C;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Shaders.class})
public class FocalEngineRender {
    @Shadow(remap=false)
    public static boolean isRenderingWorld;

    @Inject(method={"Lnet/optifine/shaders/Shaders;beginRender(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/Camera;FJ)V"}, at={@At(value="TAIL")}, remap=false)
    @Dynamic
    private static void focal$injectPreRender(Minecraft minecraft, Camera activeRenderInfo, float partialTicks, long finishTimeNano, CallbackInfo ci) {
        FocalEngineCore optiForge = FocalEngineCore.getInstance();
        if (optiForge == null) {
            System.err.println("FocalEngineForge is null");
            return;
        }
        Logger log = optiForge.getLogger();
        ShaderpackManager shaderpackManager = optiForge.getShaderpackManager();
        if (shaderpackManager == null) {
            log.error("ShaderpackManager is null");
            return;
        }
        if (FocalEngineCore.getInstance().getShaderpackManager().isAnyShaderpackLoaded()) {
            FocalEngineCore modInstance = FocalEngineCore.getInstance();
            FrameBufferManager frameBufferManager = modInstance.getFrameBufferManager();
            if (frameBufferManager == null) {
                log.error("FrameBufferManager is null");
                return;
            }
            if (frameBufferManager.getDefaultFrameBuffer() == null) {
                log.error("DefaultFrameBuffer is null!");
                return;
            }
            modInstance.getShaderpackManager().preRender();
            if (modInstance.getTextureManager() == null) {
                log.error("TextureManager is null");
            }
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;renderComposites(Lnet/optifine/shaders/ShadersFramebuffer;[Lnet/optifine/shaders/Program;Z[Lnet/optifine/shaders/ICustomTexture;)V"}, at={@At(value="INVOKE", target="Lnet/optifine/shaders/Shaders;renderFinal()V", shift=At.Shift.BEFORE, remap=false)}, remap=false)
    @Dynamic
    private static void focal$injectShaderpackRender(ShadersFramebuffer framebuffer, Program[] ps, boolean renderFinal, ICustomTexture[] customTextures, CallbackInfo ci) {
        FocalEngineCore focalEngineCore = FocalEngineCore.getInstance();
        ShaderpackManager shaderpackManager = focalEngineCore.getShaderpackManager();
        if (shaderpackManager != null) {
            if (shaderpackManager.isAnyShaderpackLoaded()) {
                int boundVao = GL30C.glGetInteger((int)34229);
                shaderpackManager.renderFrame();
                GL30C.glBindVertexArray((int)boundVao);
            }
        } else {
            throw new NullPointerException("shaderpackManager");
        }
    }

    @Redirect(method={"Lnet/optifine/shaders/Shaders;useProgram(Lnet/optifine/shaders/Program;)V"}, at=@At(value="INVOKE", target="Lnet/optifine/shaders/GlState;setDrawBuffers(Lnet/optifine/shaders/DrawBuffers;)V"), remap=false)
    @Dynamic
    private static void setDrawBuffers(DrawBuffers drawBuffers) {
        FocalEngineCore modInstance = FocalEngineCore.getInstance();
        if (!modInstance.getShaderpackManager().isAnyShaderpackLoaded()) {
            GlState.setDrawBuffers((DrawBuffers)drawBuffers);
        }
    }

    @Inject(method={"Lnet/optifine/shaders/Shaders;useProgram(Lnet/optifine/shaders/Program;)V"}, at={@At(value="INVOKE", target="Lnet/optifine/shaders/GlState;setDrawBuffers(Lnet/optifine/shaders/DrawBuffers;)V", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false)
    @Dynamic
    private static void injectJsonDrawBuffers(Program program, CallbackInfo ci, int i, DrawBuffers drawBuffers) {
        LegacyRenderPass legacyRenderPass;
        FocalEngineCore modInstance = FocalEngineCore.getInstance();
        if (modInstance.getShaderpackManager().isAnyShaderpackLoaded() && isRenderingWorld && (legacyRenderPass = modInstance.getRenderPassManager().getLegacyRenderPass(program.getName())) != null) {
            LegacyRenderPassInfo legacyInfo = legacyRenderPass.getLegacyRenderPassInfo();
            TextureManager textureManager = modInstance.getTextureManager();
            int taaJitterUniformIdx = GL20C.glGetUniformLocation((int)program.getId(), (CharSequence)"taaJitter");
            Vector2f taaJitter = (Vector2f)modInstance.getTrackedResources().getTrackedUniform("taaJitter").getValue();
            GL41C.glProgramUniform2f((int)program.getId(), (int)taaJitterUniformIdx, (float)taaJitter.x, (float)taaJitter.y);
            int noiseTexUniformIdx = GL20C.glGetUniformLocation((int)program.getId(), (CharSequence)"noiseTex");
            GL41C.glProgramUniform1i((int)program.getId(), (int)noiseTexUniformIdx, (int)textureManager.getTexture("noiseTex").getTextureID(null, false));
            FrameBuffer frameBuffer = modInstance.getFrameBufferManager().getDefaultFrameBuffer();
            frameBuffer.bindAndUpdateViewport();
            frameBuffer.updateDrawBuffers(legacyRenderPass.getActiveDrawBuffers(), legacyRenderPass.getColorAttachmentBuffer());
            if (legacyInfo.isDepthTest() != null) {
                GL30C.glDepthMask((boolean)legacyInfo.isDepthTest());
            }
            if (legacyInfo.isAlphaTest() != null) {
                GlAlphaState alphaState = new GlAlphaState(legacyInfo.isAlphaTest().booleanValue());
                GlStateManagerInvoker.focal$unlockAlpha();
                GlStateManagerInvoker.focal$lockAlpha(alphaState);
            }
            if (!legacyInfo.getBufferBlendStates().isEmpty()) {
                GL30C.glEnable((int)3042);
                for (BlendState blendState : legacyInfo.getBufferBlendStates()) {
                    blendState.updateBlendState(legacyRenderPass.getActiveDrawBuffers().get(blendState.textureName) - 36064);
                }
            }
        }
    }
}

