/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge120.gui.widget;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.forge120.gui.FocalGuiUtils;
import graphics.continuum.forge120.gui.screen.IProductListUser;
import graphics.continuum.product.DownloadManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import org.joml.Vector4f;

public class ProductListWidget
extends ObjectSelectionList<Entry>
implements AutoCloseable {
    private final IProductListUser parent;

    public ProductListWidget(IProductListUser parent, int width, int height, int topPadding, int bottomPadding) {
        Minecraft minecraft = Minecraft.m_91087_();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        super(minecraft, width, height, topPadding, height - bottomPadding, 9 + 15);
        this.parent = parent;
    }

    public void refreshList() {
        this.m_93516_();
        this.parent.getSortedProducts().forEach(product -> this.m_7085_((AbstractSelectionList.Entry)new Entry(this, (ContinuumProductType)((Object)product))));
        if (this.m_6702_().size() > 0) {
            this.parent.selectProductEntry((Entry)this.m_6702_().get(0));
        }
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void close() throws Exception {
        for (Entry entry : this.m_6702_()) {
            entry.close();
        }
    }

    public class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements AutoCloseable {
        private final ProductListWidget parent;
        private final ContinuumProductType productType;

        public Entry(ProductListWidget owningList, ContinuumProductType productType) {
            this.parent = owningList;
            this.productType = productType;
        }

        public void m_6311_(GuiGraphics guiGraphics, int itemIndex, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float p_render_9_) {
            int entryLeft = this.parent.f_93393_ + 5;
            int entryTop = rowTop + 5;
            guiGraphics.m_280488_(((ProductListWidget)ProductListWidget.this).f_93386_.f_91062_, this.productType.getDisplayName(), entryLeft, entryTop, 0xFFFFFF);
            this.drawUpdateBar(entryLeft, entryTop + 12, rowWidth - 10);
        }

        private void drawUpdateBar(int left, int top, int width) {
            List<DownloadManager.DownloadRequest> activeDownloads = FocalEngineCore.getInstance().getDownloadManager().getDownloadsForProduct(this.productType);
            if (activeDownloads == null) {
                return;
            }
            Vector4f bgColor = new Vector4f(1.0f, 1.0f, 1.0f, 0.1f);
            Vector4f progressColor = new Vector4f(0.0f, 1.0f, 0.0f, 0.5f);
            Vector4f failedColor = new Vector4f(1.0f, 0.0f, 0.0f, 0.5f);
            if (activeDownloads.size() == 1) {
                DownloadManager.DownloadRequest download = activeDownloads.get(0);
                FocalGuiUtils.drawGradientRect(left - 1, top - 1, left + width + 1, top + 1, bgColor, bgColor);
                if (!download.hasFailed()) {
                    FocalGuiUtils.drawGradientRect(left - 1, top - 1, left + Math.round((float)(width + 1) * download.getProgress()), top + 1, progressColor, progressColor);
                } else {
                    FocalGuiUtils.drawGradientRect(left - 1, top - 1, left + width + 1, top + 1, failedColor, failedColor);
                }
            } else {
                int totalDownloads = activeDownloads.size();
                int barWidth = Math.round((float)(width + 2 - totalDownloads) / (float)totalDownloads);
                for (int i = 0; i < totalDownloads; ++i) {
                    DownloadManager.DownloadRequest download = activeDownloads.get(i);
                    int barLeft = left + barWidth * i + (i > 0 ? 1 : 0);
                    int barRight = left + barWidth * (i + 1);
                    int barRightDl = left + barWidth * i + Math.round((float)barWidth * download.getProgress());
                    FocalGuiUtils.drawGradientRect(barLeft, top - 1, barRight, top + 1, bgColor, bgColor);
                    if (!download.hasFailed()) {
                        FocalGuiUtils.drawGradientRect(barLeft, top - 1, barRightDl, top + 1, progressColor, progressColor);
                        continue;
                    }
                    FocalGuiUtils.drawGradientRect(barLeft, top - 1, barRight, top + 1, failedColor, failedColor);
                }
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
            this.parent.parent.selectProductEntry(this);
            return false;
        }

        @Override
        public void close() throws Exception {
        }

        public ContinuumProductType getProductType() {
            return this.productType;
        }

        public Component m_142172_() {
            return Component.m_237115_((String)"");
        }
    }
}

