/*
 * Decompiled with CFR 0.152.
 */
package graphics.continuum.forge120.gui.screen;

import graphics.continuum.FocalEngineCore;
import graphics.continuum.data.copp.ContinuumProductType;
import graphics.continuum.forge120.gui.panel.ProductInfoPanel;
import graphics.continuum.forge120.gui.screen.AccountLoginScreen;
import graphics.continuum.forge120.gui.screen.DownloadManagerScreen;
import graphics.continuum.forge120.gui.screen.GuiScreen;
import graphics.continuum.forge120.gui.screen.IProductListUser;
import graphics.continuum.forge120.gui.widget.DropdownMenuWidget;
import graphics.continuum.forge120.gui.widget.IDropdownMenuEntry;
import graphics.continuum.forge120.gui.widget.ProductListWidget;
import graphics.continuum.network.ContinuumAccount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ProductManagerScreen
extends GuiScreen
implements IProductListUser {
    private List<ContinuumProductType> sortedProductsList;
    private SortType sortType = SortType.NORMAL;
    private DropdownMenuWidget<IDropdownMenuEntry> accountDropdown;
    private Button loginButton;
    private ProductListWidget productSelectionList;
    private ProductInfoPanel productInfoPanel;
    private Button downloadManagerButton;
    public final IDropdownMenuEntry accountLogoutEntry = new IDropdownMenuEntry(){

        @Override
        public String getText() {
            return "Logout";
        }

        @Override
        public void onClick(DropdownMenuWidget dropdown) {
            FocalEngineCore.getInstance().forgetAccount();
            ProductManagerScreen.this.m_7856_();
        }
    };

    public ProductManagerScreen(Screen previousScreen) {
        super(previousScreen, (Component)Component.m_237113_((String)"Continuum Product Manager"));
    }

    @Override
    protected void m_7856_() {
        int accountDropdownWidth;
        this.accountDropdown = null;
        this.loginButton = null;
        this.downloadManagerButton = null;
        this.productInfoPanel = null;
        this.productSelectionList = null;
        this.m_169413_();
        ContinuumAccount account = this.getModInstance().getAccount();
        if (!account.isAdhocAccount()) {
            String accountName = this.getModInstance().getAccount().getUsername();
            accountDropdownWidth = this.f_96547_.m_92895_(accountName) + 10;
            this.accountDropdown = new DropdownMenuWidget(null, 5, 5, accountDropdownWidth, 20, accountName);
            this.accountDropdown.addEntry(this.accountLogoutEntry);
        } else {
            accountDropdownWidth = this.f_96547_.m_92895_("Login") + 10;
            this.loginButton = Button.m_253074_((Component)Component.m_237113_((String)"Login"), button -> this.f_96541_.m_91152_((Screen)new AccountLoginScreen((Screen)this, null))).m_252794_(5, 5).m_253046_(accountDropdownWidth, 20).m_253136_();
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.returnToPreviousScreen()).m_252794_(this.f_96543_ - 65, 5).m_253046_(60, 20).m_253136_());
        this.updateDisplayedProductList();
        int maxListWidth = 0;
        for (ContinuumProductType product : this.sortedProductsList) {
            maxListWidth = Math.max(maxListWidth, Minecraft.m_91087_().f_91062_.m_92895_(product.getDisplayName()));
        }
        maxListWidth = Math.max(maxListWidth, 100) + 10;
        this.productInfoPanel = new ProductInfoPanel(this, maxListWidth + 10, 30, 5);
        this.m_142416_((GuiEventListener)this.productInfoPanel);
        this.productSelectionList = new ProductListWidget(this, maxListWidth, this.f_96544_, 30, 5);
        this.productSelectionList.refreshList();
        this.productSelectionList.m_93507_(5);
        this.m_142416_((GuiEventListener)this.productSelectionList);
        String downloadManagementText = "Current Downloads";
        this.downloadManagerButton = Button.m_253074_((Component)Component.m_237113_((String)downloadManagementText), button -> Minecraft.m_91087_().m_91152_((Screen)new DownloadManagerScreen(this))).m_252794_(10 + accountDropdownWidth, 5).m_253046_(this.f_96547_.m_92895_(downloadManagementText) + 10, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.downloadManagerButton);
        if (account.isAdhocAccount()) {
            this.m_142416_((GuiEventListener)this.loginButton);
        } else {
            this.m_142416_((GuiEventListener)this.accountDropdown);
        }
    }

    public void updateDisplayedProductList() {
        FocalEngineCore engineInstance = FocalEngineCore.getInstance();
        engineInstance.getProductManager().checkForUpdatesAndNotify();
        this.sortedProductsList = new ArrayList<ContinuumProductType>(engineInstance.getProductManager().getProductList().keySet());
        this.sortedProductsList.sort(this.sortType);
    }

    @Override
    public void m_86600_() {
        this.productInfoPanel.tick();
    }

    @Override
    protected void preDraw(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(guiGraphics);
        this.productInfoPanel.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.productSelectionList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.accountDropdown != null) {
            this.accountDropdown.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void postDraw(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void selectProductEntry(ProductListWidget.Entry entry) {
        this.productSelectionList.m_6987_((AbstractSelectionList.Entry)entry);
        FocalEngineCore.getInstance().getProductManager().selectProduct(entry.getProductType());
        this.productInfoPanel.destroy();
        this.productInfoPanel.init();
    }

    @Override
    public Collection<ContinuumProductType> getSortedProducts() {
        return this.sortedProductsList;
    }

    public ProductInfoPanel getProductInfoPanel() {
        return this.productInfoPanel;
    }

    @Override
    public void returnToPreviousScreen() {
        super.returnToPreviousScreen();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum SortType implements Comparator<ContinuumProductType>
    {
        NORMAL("NORMAL"),
        A_TO_Z("A->Z"){

            @Override
            public int compare(ContinuumProductType a, ContinuumProductType b) {
                return a.getDisplayName().compareTo(b.getDisplayName());
            }
        }
        ,
        Z_TO_A("Z->A"){

            @Override
            public int compare(ContinuumProductType a, ContinuumProductType b) {
                return b.getDisplayName().compareTo(a.getDisplayName());
            }
        };

        private final String displayName;

        private SortType(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public int compare(ContinuumProductType a, ContinuumProductType b) {
            return a.compareTo(b);
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

